/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetCacheEntry;
import oracle.jdbc.driver.ResultSetCacheEntryKey;
import oracle.jdbc.driver.T4CTTIOqcsta;
import oracle.jdbc.driver.T4CTTIkscn;
import oracle.jdbc.driver.T4CTTIqcinv;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.util.RepConversion;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
final class ResultSetCache
implements oracle.jdbc.internal.ResultSetCache {
    static final int CACHE_ID_SIZE = 16;
    static final int COMPILE_KEY_SIZE = 16;
    static final int RUNTIME_KEY_SIZE = 16;
    private static final long STAT_SEND_INTERVAL = 30000L;
    private final byte[] cacheId = new byte[16];
    private final byte[] cacheIdAsNibbles = new byte[32];
    private boolean isCacheIdAsNibblesReady = false;
    private final long cacheMaxSize;
    private final long cacheLagInMillis;
    private AtomicLong timeOfLastSCN = new AtomicLong(System.currentTimeMillis());
    private long invalidationCount = 0L;
    private long invalidatedQueryCount = 0L;
    private long validQueriesPurged = 0L;
    private long invalidatedBeforeCompletion = 0L;
    private int cacheHits = 0;
    private long lastStatSentAt;
    private T4CTTIOqcsta oqcsta;
    private AtomicBoolean needToSendStats = new AtomicBoolean(false);
    private long currentCacheSize = 0L;
    private long registrationId = -1L;
    private ResultSetCacheState state = ResultSetCacheState.INIT;
    private long visibleSCN;
    private LinkedHashMap<ResultSetCacheEntryKey, ResultSetCacheEntry> cacheEntryTable = new LinkedHashMap(10);
    private Hashtable<Long, LinkedList<ResultSetCacheEntry>> queryIdIndex = new Hashtable(10);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    ResultSetCache(long l2, int n2) {
        assert (l2 > 0L);
        assert (n2 >= 0);
        new Random().nextBytes(this.cacheId);
        this.cacheMaxSize = l2;
        this.cacheLagInMillis = n2;
    }

    ResultSetCacheState getState() {
        return this.state;
    }

    synchronized void updateCurrentCacheSize(long l2) {
        this.currentCacheSize += l2;
    }

    @Override
    public synchronized long getCurrentCacheSize() {
        return this.currentCacheSize;
    }

    void cacheEntryTableRemove(ResultSetCacheEntry resultSetCacheEntry) {
        this.cacheEntryTable.remove(resultSetCacheEntry.getResultSetCacheEntryKey());
        this.updateCurrentCacheSize(-1L * resultSetCacheEntry.getSizeInMemory());
    }

    void cacheEntryTablePut(ResultSetCacheEntryKey resultSetCacheEntryKey, ResultSetCacheEntry resultSetCacheEntry) {
        this.cacheEntryTable.put(resultSetCacheEntryKey, resultSetCacheEntry);
        this.updateCurrentCacheSize(resultSetCacheEntry.getSizeInMemory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(ResultSetCacheState resultSetCacheState) {
        if (resultSetCacheState == this.state) {
            return;
        }
        this.state = resultSetCacheState;
        if (resultSetCacheState == ResultSetCacheState.STARTED) {
            ResultSetCache resultSetCache = this;
            synchronized (resultSetCache) {
                this.notifyAll();
            }
        }
    }

    byte[] getCacheId() {
        return this.cacheId;
    }

    byte[] getCacheIdAsNibbles() {
        if (!this.isCacheIdAsNibblesReady) {
            RepConversion.bArray2Nibbles(this.cacheId, this.cacheIdAsNibbles);
            this.isCacheIdAsNibblesReady = true;
        }
        return this.cacheIdAsNibbles;
    }

    long getRegistrationId() {
        return this.registrationId;
    }

    void setRegistrationId(long l2) {
        this.registrationId = l2;
    }

    void setOQCSTA(T4CTTIOqcsta t4CTTIOqcsta) {
        this.oqcsta = t4CTTIOqcsta;
    }

    T4CTTIOqcsta getOQCSTA() {
        return this.oqcsta;
    }

    @Override
    public int getCacheLag() {
        return (int)this.cacheLagInMillis;
    }

    @Override
    public long getMaxCacheSize() {
        return this.cacheMaxSize;
    }

    @Override
    public long getNumberOfCacheEntries() {
        return this.cacheEntryTable.size();
    }

    @Override
    public long getInvalidationCount() {
        return this.invalidationCount;
    }

    @Override
    public long getInvalidatedQueryCount() {
        return this.invalidatedQueryCount;
    }

    @Override
    public long getInvalidatedBeforeCompletion() {
        return this.invalidatedBeforeCompletion;
    }

    @Override
    public long getValidQueriesPurged() {
        return this.validQueriesPurged;
    }

    @Override
    public int getCacheHits() {
        return this.cacheHits;
    }

    long getVisibleSCN() {
        return this.visibleSCN;
    }

    boolean hasCacheLagExpired() {
        return System.currentTimeMillis() - this.timeOfLastSCN.get() > this.cacheLagInMillis;
    }

    synchronized void processCommittedInvalidation(T4CTTIqcinv t4CTTIqcinv) {
        long l2 = t4CTTIqcinv.kpdqcqid;
        if (l2 == 0L) {
            return;
        }
        ++this.invalidationCount;
        long l3 = t4CTTIqcinv.kpdqcscn.getSCN();
        if (!T4CTTIkscn.isLessThanUnsigned(l3, this.visibleSCN)) {
            LinkedList<ResultSetCacheEntry> linkedList = this.queryIdIndex.get(l2);
            if (linkedList != null) {
                for (ResultSetCacheEntry resultSetCacheEntry : linkedList) {
                    resultSetCacheEntry.invalidate();
                    this.cacheEntryTableRemove(resultSetCacheEntry);
                    ++this.invalidatedQueryCount;
                }
            }
            this.queryIdIndex.remove(l2);
        }
        this.needToSendStats.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSetCacheEntry getResultSetCacheEntry(OracleStatement oracleStatement) throws SQLException {
        Object object;
        byte[] byArray = oracleStatement.getCompileKey();
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = oracleStatement.getRuntimeKey();
        if (byArray2 == null) {
            return null;
        }
        ResultSetCacheEntryKey resultSetCacheEntryKey = new ResultSetCacheEntryKey(byArray, byArray2);
        long l2 = oracleStatement.getQueryId();
        ArrayList<Long> arrayList = oracleStatement.connection.getResultSetCacheLocalInvalidations();
        if (l2 == 0L || arrayList.contains(l2)) {
            return null;
        }
        if (this.hasCacheLagExpired()) {
            object = this;
            synchronized (object) {
                if (this.hasCacheLagExpired()) {
                    oracleStatement.connection.pingDatabase();
                }
            }
        }
        if ((object = this.cacheEntryTable.get(resultSetCacheEntryKey)) == null) {
            ResultSetCache resultSetCache = this;
            synchronized (resultSetCache) {
                object = this.cacheEntryTable.get(resultSetCacheEntryKey);
                if (object == null) {
                    LinkedList<Object> linkedList;
                    while (this.getCurrentCacheSize() >= this.cacheMaxSize) {
                        linkedList = this.cacheEntryTable.entrySet().iterator();
                        Map.Entry<ResultSetCacheEntryKey, ResultSetCacheEntry> entry = null;
                        while (linkedList.hasNext()) {
                            entry = linkedList.next();
                        }
                        ResultSetCacheEntryKey resultSetCacheEntryKey2 = (ResultSetCacheEntryKey)entry.getKey();
                        ResultSetCacheEntry resultSetCacheEntry = entry.getValue();
                        this.queryIdIndex.get(resultSetCacheEntry.getQueryId()).remove(resultSetCacheEntry);
                        this.cacheEntryTableRemove(resultSetCacheEntry);
                    }
                    object = new ResultSetCacheEntry(resultSetCacheEntryKey, l2);
                    ((ResultSetCacheEntry)object).userName = oracleStatement.connection.userName;
                    this.cacheEntryTablePut(resultSetCacheEntryKey, (ResultSetCacheEntry)object);
                    linkedList = this.queryIdIndex.get(l2);
                    if (linkedList == null) {
                        linkedList = new LinkedList<Object>();
                        this.queryIdIndex.put(l2, linkedList);
                    }
                    linkedList.add(object);
                }
            }
        }
        if (object != null && ((ResultSetCacheEntry)object).userName.equals(oracleStatement.connection.userName)) {
            if (((ResultSetCacheEntry)object).isValid()) {
                ++this.cacheHits;
                this.needToSendStats.set(true);
                if (this.lastStatSentAt == 0L) {
                    this.lastStatSentAt = System.currentTimeMillis();
                }
            }
            return object;
        }
        return null;
    }

    synchronized void setVisibleSCN(long l2) {
        this.visibleSCN = l2;
        this.timeOfLastSCN.set(System.currentTimeMillis());
    }

    synchronized void registerConnection(OracleConnection oracleConnection) {
        if (this.state == ResultSetCacheState.INIT) {
            this.setState(ResultSetCacheState.STARTING);
        } else if (this.state == ResultSetCacheState.STARTING) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    boolean needToSendStatsResetIfTrue() {
        if (System.currentTimeMillis() - this.lastStatSentAt > 30000L && this.needToSendStats.weakCompareAndSet(true, false)) {
            this.lastStatSentAt = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    static {
        try {
            $$$methodRef$$$27 = ResultSetCache.class.getDeclaredConstructor(Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = ResultSetCache.class.getDeclaredMethod("needToSendStatsResetIfTrue", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = ResultSetCache.class.getDeclaredMethod("registerConnection", OracleConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = ResultSetCache.class.getDeclaredMethod("setVisibleSCN", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = ResultSetCache.class.getDeclaredMethod("getResultSetCacheEntry", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = ResultSetCache.class.getDeclaredMethod("processCommittedInvalidation", T4CTTIqcinv.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = ResultSetCache.class.getDeclaredMethod("hasCacheLagExpired", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = ResultSetCache.class.getDeclaredMethod("getVisibleSCN", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = ResultSetCache.class.getDeclaredMethod("getCacheHits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = ResultSetCache.class.getDeclaredMethod("getValidQueriesPurged", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = ResultSetCache.class.getDeclaredMethod("getInvalidatedBeforeCompletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = ResultSetCache.class.getDeclaredMethod("getInvalidatedQueryCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = ResultSetCache.class.getDeclaredMethod("getInvalidationCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = ResultSetCache.class.getDeclaredMethod("getNumberOfCacheEntries", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = ResultSetCache.class.getDeclaredMethod("getMaxCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ResultSetCache.class.getDeclaredMethod("getCacheLag", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ResultSetCache.class.getDeclaredMethod("getOQCSTA", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ResultSetCache.class.getDeclaredMethod("setOQCSTA", T4CTTIOqcsta.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ResultSetCache.class.getDeclaredMethod("setRegistrationId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ResultSetCache.class.getDeclaredMethod("getRegistrationId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ResultSetCache.class.getDeclaredMethod("getCacheIdAsNibbles", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ResultSetCache.class.getDeclaredMethod("getCacheId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ResultSetCache.class.getDeclaredMethod("setState", ResultSetCacheState.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ResultSetCache.class.getDeclaredMethod("cacheEntryTablePut", ResultSetCacheEntryKey.class, ResultSetCacheEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ResultSetCache.class.getDeclaredMethod("cacheEntryTableRemove", ResultSetCacheEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ResultSetCache.class.getDeclaredMethod("getCurrentCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ResultSetCache.class.getDeclaredMethod("updateCurrentCacheSize", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ResultSetCache.class.getDeclaredMethod("getState", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    static final class ResultSetCacheState
    extends Enum<ResultSetCacheState> {
        public static final /* enum */ ResultSetCacheState INIT;
        public static final /* enum */ ResultSetCacheState STARTING;
        public static final /* enum */ ResultSetCacheState STARTED;
        public static final /* enum */ ResultSetCacheState STARTUP_FAILED;
        private static final /* synthetic */ ResultSetCacheState[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static ResultSetCacheState[] values() {
            return (ResultSetCacheState[])$VALUES.clone();
        }

        public static ResultSetCacheState valueOf(String string) {
            return Enum.valueOf(ResultSetCacheState.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = ResultSetCacheState.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = ResultSetCacheState.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = ResultSetCacheState.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            INIT = new ResultSetCacheState();
            STARTING = new ResultSetCacheState();
            STARTED = new ResultSetCacheState();
            STARTUP_FAILED = new ResultSetCacheState();
            $VALUES = new ResultSetCacheState[]{INIT, STARTING, STARTED, STARTUP_FAILED};
        }
    }
}

