/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

final class T4C8TTIClob
extends T4C8TTILob {
    private static final String CLASS_NAME = T4C8TTIClob.class.getName();
    int[] nBytes = new int[1];

    T4C8TTIClob(T4CConnection _conn) {
        super(_conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long read(byte[] lobLocator, long offset, long numChars, boolean isNCLOB, char[] charOutBuffer, int _offsetInOutBuffer) throws SQLException, IOException {
        long l;
        byte[] binaryReadBuffer = null;
        try {
            this.initializeLobdef();
            boolean varWidthChar = this.isLobCharsetVariableWidth(lobLocator);
            int bufferSizeNeeded = this.getByteBufferSizeForConversion(varWidthChar, numChars);
            binaryReadBuffer = this.connection.getByteBuffer(bufferSizeNeeded);
            this.littleEndianClob = this.isLobCharsetLE(lobLocator);
            this.lobops = 2L;
            this.sourceLobLocator = lobLocator;
            this.sourceOffset = offset;
            this.lobamt = numChars;
            this.sendLobamt = true;
            this.outBuffer = binaryReadBuffer;
            this.doRPC();
            long charsRead = this.lobamt;
            this.decodeNetworkCharSet(charOutBuffer, _offsetInOutBuffer, varWidthChar, isNCLOB);
            l = charsRead;
            this.outBuffer = null;
        }
        catch (Throwable throwable) {
            this.outBuffer = null;
            this.connection.cacheBuffer(binaryReadBuffer);
            throw throwable;
        }
        this.connection.cacheBuffer(binaryReadBuffer);
        return l;
    }

    boolean isLobCharsetVariableWidth(byte[] lobLocator) {
        return (lobLocator[6] & 0xFFFFFF80) == -128;
    }

    int getByteBufferSizeForConversion(boolean isVariableWidthCharSet, long numberOfCharsToRead) {
        if (isVariableWidthCharSet) {
            return (int)numberOfCharsToRead * 2;
        }
        return (int)numberOfCharsToRead * 3;
    }

    private boolean isLobCharsetLE(byte[] lobLocator) {
        return 64 == (lobLocator[7] & 0x40);
    }

    private void decodeNetworkCharSet(char[] charOutBuffer, int _offsetInOutBuffer, boolean isVariableWidthCS, boolean isNCLOB) throws SQLException {
        if (isVariableWidthCS) {
            this.decodeVariableWidthCharSet(charOutBuffer, _offsetInOutBuffer);
        } else {
            this.decodeFixedWidthCharSet(charOutBuffer, _offsetInOutBuffer, isNCLOB);
        }
    }

    private void decodeVariableWidthCharSet(char[] charOutBuffer, int _offsetInOutBuffer) throws SQLException {
        if (this.connection.versionNumber < 10101) {
            DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, charOutBuffer);
        } else if (this.littleEndianClob) {
            CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, (int)this.lobBytesRead, true);
        } else {
            CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, (int)this.lobBytesRead, true);
        }
    }

    private void decodeFixedWidthCharSet(char[] charOutBuffer, int _offsetInOutBuffer, boolean isNCLOB) throws SQLException {
        if (!isNCLOB) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, this.nBytes, charOutBuffer.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, charOutBuffer, _offsetInOutBuffer, this.nBytes, charOutBuffer.length);
        }
    }

    long write(byte[] lobLocator, long offset, boolean isNCLOB, char[] _inBuffer, long offsetInBuffer, long numChars) throws SQLException, IOException {
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "write", "offset={0}, isNCLOB={1}, offsetInBuffer={2}, numChars={3}", (String)null, (Throwable)null, (Object)offset, (Object)isNCLOB, (Object)offsetInBuffer, (Object)numChars);
        this.validateLobOperation(lobLocator, 64, "write()");
        this.prepareForWrite(lobLocator, offset, isNCLOB, _inBuffer, offsetInBuffer, numChars);
        this.doRPC();
        return this.lobamt;
    }

    private void prepareForWrite(byte[] lobLocator, long offset, boolean isNCLOB, char[] _inBuffer, long offsetInBuffer, long numChars) throws SQLException {
        boolean varWidthChar = this.isLobCharsetVariableWidth(lobLocator);
        this.littleEndianClob = this.isLobCharsetLE(lobLocator);
        int byteBufferSize = this.getByteBufferSizeForConversion(varWidthChar, numChars);
        byte[] binaryWriteBuffer = new byte[byteBufferSize];
        int[] amount = new int[]{-1};
        int bytesConverted = this.encodeNetworkCharSet(_inBuffer, (int)offsetInBuffer, (int)numChars, binaryWriteBuffer, varWidthChar, isNCLOB, amount);
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = lobLocator;
        this.sourceOffset = offset;
        this.lobamt = amount[0] == -1 ? 0L : (long)amount[0];
        this.sendLobamt = true;
        this.inBuffer = binaryWriteBuffer;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = bytesConverted;
    }

    int encodeNetworkCharSet(char[] inChars, int inCharsOffset, int inCharsLength, byte[] outBytes, boolean isVariableWidthCS, boolean isNCLOB, int[] amount) throws SQLException {
        if (isVariableWidthCS) {
            return this.encodeVariableWidthCharSet(inChars, inCharsOffset, inCharsLength, outBytes, amount);
        }
        return this.encodeFixedWidthCharSet(inChars, inCharsOffset, inCharsLength, outBytes, isNCLOB, amount);
    }

    private int encodeVariableWidthCharSet(char[] inChars, int inCharsOffset, int inCharsLength, byte[] outBytes, int[] amount) throws SQLException {
        int byteAmount;
        if (this.connection.versionNumber < 10101) {
            DBConversion.javaCharsToUcs2Bytes(inChars, inCharsOffset, outBytes, 0, inCharsLength);
            byteAmount = inCharsLength;
        } else if (this.littleEndianClob) {
            CharacterSet.convertJavaCharsToAL16UTF16LEBytes(inChars, inCharsOffset, outBytes, 0, inCharsLength);
            byteAmount = inCharsLength * 2;
        } else {
            CharacterSet.convertJavaCharsToAL16UTF16Bytes(inChars, inCharsOffset, outBytes, 0, inCharsLength);
            byteAmount = inCharsLength * 2;
        }
        if (amount != null && amount.length > 0) {
            amount[0] = inCharsLength;
        }
        return byteAmount;
    }

    private int encodeFixedWidthCharSet(char[] inChars, int inCharsOffset, int inCharsLength, byte[] outBytes, boolean isNCLOB, int[] amount) throws SQLException {
        boolean isCountingCodePoints;
        short encodedCharSet;
        short databaseCharSet;
        if (isNCLOB) {
            encodedCharSet = databaseCharSet = this.meg.conv.serverNCharSetId;
        } else {
            encodedCharSet = this.meg.conv.clientCharSetId;
            databaseCharSet = this.meg.conv.serverCharSetId;
        }
        LobAmtUnit lobAmtUnit = LobAmtUnit.get(encodedCharSet, databaseCharSet);
        if (amount == null || amount.length == 0) {
            isCountingCodePoints = false;
        } else if (lobAmtUnit == LobAmtUnit.CODE_POINT) {
            isCountingCodePoints = true;
        } else if (lobAmtUnit == LobAmtUnit.CODE_UNIT && encodedCharSet == 2000) {
            isCountingCodePoints = false;
            amount[0] = inCharsLength;
        } else {
            isCountingCodePoints = false;
            amount[0] = -1;
        }
        return this.meg.conv.javaCharsToCHARBytes(inChars, inCharsOffset, outBytes, 0, encodedCharSet, inCharsLength, (int[])(isCountingCodePoints ? amount : null));
    }

    @Override
    Datum createTemporaryLob(Connection conn, boolean cache, int duration) throws SQLException, IOException {
        return this.createTemporaryLob(conn, cache, duration, (short)1);
    }

    Datum createTemporaryLob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException, IOException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "createTemporaryLob", "cache={0}, duration={1}, form_of_use={2}", (String)null, (Throwable)null, (Object)cache, (Object)duration, (Object)form_of_use);
        if (duration == 12) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158).fillInStackTrace();
        }
        CLOB clob = null;
        this.initializeLobdef();
        this.lobops = 272L;
        int tempLobSize = this.getTemporaryLobSize();
        this.sourceLobLocator = new byte[tempLobSize];
        this.sourceLobLocator[1] = (byte)(tempLobSize - 2);
        this.sourceOffset = form_of_use == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = duration;
        this.lobamt = duration;
        this.sendLobamt = true;
        this.nullO2U = true;
        short s = this.characterSet = form_of_use == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = cache ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            clob = form_of_use == 1 ? new CLOB((OracleConnection)conn, this.sourceLobLocator) : new NCLOB((OracleConnection)conn, this.sourceLobLocator);
        }
        return clob;
    }

    @Override
    boolean openLob(byte[] lobLocator, int mode) throws SQLException, IOException {
        boolean wasOpened = false;
        int kokl_mode = 2;
        if (mode == 0) {
            kokl_mode = 1;
        }
        wasOpened = this.openLob(lobLocator, kokl_mode, 32768);
        return wasOpened;
    }

    @Override
    boolean closeLob(byte[] lobLocator) throws SQLException, IOException {
        boolean wasClosed = false;
        wasClosed = this.closeLob(lobLocator, 65536);
        return wasClosed;
    }

    @Override
    boolean isOpenLob(byte[] lobLocator) throws SQLException, IOException {
        return this.isOpenLob(lobLocator, 69632);
    }

    private static enum LobAmtUnit {
        CODE_UNIT,
        CODE_POINT,
        UNKNOWN;


        private static LobAmtUnit get(short driverCharSet, short serverCharSet) {
            if (driverCharSet != serverCharSet) {
                return UNKNOWN;
            }
            switch (driverCharSet) {
                case 2000: {
                    return CODE_UNIT;
                }
                case 1: 
                case 2: 
                case 31: 
                case 46: 
                case 178: 
                case 871: 
                case 873: {
                    return CODE_POINT;
                }
            }
            return UNKNOWN;
        }
    }
}

