/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.RoundingMode;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import oracle.jdbc.OracleType;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.SimpleByteArray;

public final class VectorData {
    private static final byte LVECTOR_H_MAGIC = -37;
    private static final short LVECTOR_H_FLAG1_OPTIONAL = Short.MIN_VALUE;
    private static final short LVECTOR_H_FLAG1_LITENDIAN = 1;
    private static final short LVECTOR_H_FLAG1_NORM = 2;
    private static final short LVECTOR_H_FLAG1_UKDIM = 4;
    private static final short LVECTOR_H_FLAG1_IEEETYP = 8;
    private static final short LVECTOR_H_FLAG1_NORMSRC = 16;
    private static final byte LVECTOR_H_INT8 = 1;
    private static final byte LVECTOR_H_IEEE_FLOAT16 = 2;
    private static final byte LVECTOR_H_BINARY_FLOAT32 = 4;
    private static final byte LVECTOR_H_IEEE_FLOAT32 = 8;
    private static final byte LVECTOR_H_CANONICAL_DOUBLE = 16;
    private static final byte LVECTOR_H_IEEE_DOUBLE = 32;
    static final byte LVECTOR_FLEX = 0;
    static final byte LVECTOR_FLOAT16 = 1;
    static final byte LVECTOR_FLOAT32 = 2;
    static final byte LVECTOR_DOUBLE = 3;
    static final byte LVECTOR_INT8 = 4;
    private static final int BUFFER_SIZE = 16384;

    private VectorData() {
    }

    public static byte[] encode(Object values, OracleType vectorType) throws SQLException {
        Encoder<?> encoder = VectorData.getEncoder(values.getClass(), vectorType.getVendorTypeNumber());
        int byteLength = encoder.getByteLength(values);
        byte[] data = new byte[byteLength];
        SimpleByteArray dataByteArray = new SimpleByteArray(CommonDiagnosable.getInstance(), data);
        encoder.encode(values, false, dataByteArray);
        return data;
    }

    static <T> Encoder<? super T> getEncoder(Class<T> objectClass, int vectorType) throws SQLException {
        if (objectClass == double[].class) {
            switch (vectorType) {
                case -108: 
                case -105: {
                    return Float64Encoder.INSTANCE;
                }
                case -107: {
                    return Float32ConversionEncoder.DOUBLE_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.DOUBLE_ENCODER;
                }
            }
        } else if (objectClass == float[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.FLOAT_ENCODER;
                }
                case -107: 
                case -105: {
                    return Float32Encoder.INSTANCE;
                }
                case -106: {
                    return Int8ConversionEncoder.FLOAT_ENCODER;
                }
            }
        } else if (objectClass == byte[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.BYTE_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.BYTE_ENCODER;
                }
                case -106: 
                case -105: {
                    return Int8Encoder.INSTANCE;
                }
            }
        } else if (objectClass == long[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.LONG_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.LONG_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.LONG_ENCODER;
                }
            }
        } else if (objectClass == int[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.INT_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.INT_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.INT_ENCODER;
                }
            }
        } else if (objectClass == short[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.SHORT_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.SHORT_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.SHORT_ENCODER;
                }
            }
        } else if (objectClass == boolean[].class) {
            switch (vectorType) {
                case -108: {
                    return Float64ConversionEncoder.BOOLEAN_ENCODER;
                }
                case -107: {
                    return Float32ConversionEncoder.BOOLEAN_ENCODER;
                }
                case -106: {
                    return Int8ConversionEncoder.BOOLEAN_ENCODER;
                }
            }
        }
        OracleType oracleType = OracleType.toOracleType(vectorType);
        throw (SQLException)DatabaseError.createSqlException(null, 4, "Can not convert " + objectClass.getSimpleName() + " to " + oracleType + ". Supported conversions are specified in the JavaDoc of oracle.jdbc." + oracleType).fillInStackTrace();
    }

    public static OracleType decodeType(byte[] data) throws SQLException {
        SimpleByteArray dataByteArray = new SimpleByteArray(CommonDiagnosable.getInstance(), data);
        VectorData.validateMagicNumber(dataByteArray.get());
        VectorData.validateVersion(dataByteArray.get());
        VectorData.readFlag1(dataByteArray);
        byte typeCode = dataByteArray.get();
        switch (typeCode) {
            case 3: {
                return OracleType.VECTOR_FLOAT64;
            }
            case 2: {
                return OracleType.VECTOR_FLOAT32;
            }
            case 4: {
                return OracleType.VECTOR_INT8;
            }
        }
        throw VectorData.unrecognizedData("Unrecognized vector type: " + typeCode);
    }

    public static <T> T decode(byte[] data, Class<T> decodedClass, boolean isIeeeReencode) throws SQLException {
        return VectorData.decode(new SimpleByteArray(CommonDiagnosable.getInstance(), data), decodedClass, isIeeeReencode);
    }

    static <T> T decode(ByteArray data, Class<T> decodedClass, boolean isIeeeReencode) throws SQLException {
        VectorData.validateMagicNumber(data.get());
        VectorData.validateVersion(data.get());
        long flag1Position = data.getPosition();
        short flag1 = VectorData.readFlag1(data);
        Decoder decoder = VectorData.getDecoder(flag1, data.get());
        int length = data.getInt();
        if (VectorData.isNormFlagSet(flag1) || VectorData.isNormPaddingFlagSet(flag1)) {
            data.setPosition(data.getPosition() + 8L);
        }
        if (isIeeeReencode) {
            decoder = decoder.toIeee(data, length);
            data.putShort(flag1Position, (short)(flag1 | 8));
        }
        return (T)decoder.decode(data, length, decodedClass);
    }

    private static void validateMagicNumber(byte magicNumber) throws SQLException {
        if (magicNumber != -37) {
            throw VectorData.unrecognizedData("Possible data corruption. Unrecognized vector magic number: 0x" + Integer.toHexString(magicNumber & 0xFF));
        }
    }

    private static void validateVersion(byte version) throws SQLException {
        if (version != 0) {
            throw VectorData.unrecognizedData("Unrecognized vector version: " + version);
        }
    }

    private static short readFlag1(ByteArray data) throws SQLException {
        int flag1 = data.getShort();
        if ((flag1 & Short.MIN_VALUE) != 0) {
            throw VectorData.unrecognizedData("Unrecognized VECTOR flag: " + Integer.toHexString(flag1));
        }
        return (short)flag1;
    }

    private static boolean isNormFlagSet(short flag1) {
        return (flag1 & 2) != 0;
    }

    private static boolean isNormPaddingFlagSet(short flag1) {
        return (flag1 & 0x10) != 0;
    }

    private static SQLException unrecognizedData(String message) {
        return DatabaseError.createSqlException(null, 89, message);
    }

    private static Decoder getDecoder(short flag1, byte typeCode) throws SQLException {
        ByteArray.NumberEncoding numberEncoding = VectorData.getNumberEncoding(flag1);
        boolean isIeee = numberEncoding.isIeee();
        ByteOrder byteOrder = numberEncoding.byteOrder();
        switch (typeCode) {
            case 3: {
                return isIeee ? VectorData.getIeeeFloat64Decoder(byteOrder) : VectorData.getOracleFloat64Decoder(byteOrder);
            }
            case 2: {
                return isIeee ? VectorData.getIeeeFloat32Decoder(byteOrder) : VectorData.getOracleFloat32Decoder(byteOrder);
            }
            case 4: {
                return VectorData.getInt8Decoder();
            }
        }
        throw VectorData.unrecognizedData("Unrecognized vector type: " + typeCode);
    }

    private static ByteArray.NumberEncoding getNumberEncoding(short flag1) {
        boolean isLittleEndian;
        boolean isIeee = (flag1 & 8) != 0;
        boolean bl = isLittleEndian = (flag1 & 1) != 0;
        return isIeee ? (isLittleEndian ? ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN : ByteArray.NumberEncoding.IEEE_BIG_ENDIAN) : (isLittleEndian ? ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN : ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
    }

    private static Decoder getInt8Decoder() {
        return Int8Decoder.INSTANCE;
    }

    private static Decoder getIeeeFloat32Decoder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return IeeeFloat32Decoder.LITTLE_ENDIAN;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return IeeeFloat32Decoder.BIG_ENDIAN;
        }
        throw new IllegalArgumentException("Unrecognized ByteOrder: " + byteOrder);
    }

    private static Decoder getOracleFloat32Decoder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return OracleFloat32Decoder.LITTLE_ENDIAN;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return OracleFloat32Decoder.BIG_ENDIAN;
        }
        throw new IllegalArgumentException("Unrecognized ByteOrder: " + byteOrder);
    }

    private static Decoder getIeeeFloat64Decoder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return IeeeFloat64Decoder.LITTLE_ENDIAN;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return IeeeFloat64Decoder.BIG_ENDIAN;
        }
        throw new IllegalArgumentException("Unrecognized ByteOrder: " + byteOrder);
    }

    private static Decoder getOracleFloat64Decoder(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return OracleFloat64Decoder.LITTLE_ENDIAN;
        }
        if (byteOrder == ByteOrder.BIG_ENDIAN) {
            return OracleFloat64Decoder.BIG_ENDIAN;
        }
        throw new IllegalArgumentException("Unrecognized ByteOrder: " + byteOrder);
    }

    private static final class BooleanArrayConverter
    implements ArrayConverter<boolean[]> {
        private static final BooleanArrayConverter INSTANCE = new BooleanArrayConverter();

        private BooleanArrayConverter() {
        }

        @Override
        public int getLength(boolean[] array) {
            return array.length;
        }

        @Override
        public double getDouble(boolean[] array, int index) {
            return array[index] ? 1.0 : 0.0;
        }

        @Override
        public float getFloat(boolean[] array, int index) {
            return array[index] ? 1.0f : 0.0f;
        }

        @Override
        public byte getByte(boolean[] array, int index) {
            return array[index] ? (byte)1 : 0;
        }

        static /* synthetic */ BooleanArrayConverter access$3300() {
            return INSTANCE;
        }
    }

    private static final class ByteArrayConverter
    implements ArrayConverter<byte[]> {
        private static final ByteArrayConverter INSTANCE = new ByteArrayConverter();

        private ByteArrayConverter() {
        }

        @Override
        public int getLength(byte[] array) {
            return array.length;
        }

        @Override
        public double getDouble(byte[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(byte[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(byte[] array, int index) {
            return array[index];
        }

        static /* synthetic */ ByteArrayConverter access$3200() {
            return INSTANCE;
        }
    }

    private static final class ShortArrayConverter
    implements ArrayConverter<short[]> {
        private static final ShortArrayConverter INSTANCE = new ShortArrayConverter();

        private ShortArrayConverter() {
        }

        @Override
        public int getLength(short[] array) {
            return array.length;
        }

        @Override
        public double getDouble(short[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(short[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(short[] array, int index) {
            return (byte)array[index];
        }

        static /* synthetic */ ShortArrayConverter access$3100() {
            return INSTANCE;
        }
    }

    private static final class IntArrayConverter
    implements ArrayConverter<int[]> {
        private static final IntArrayConverter INSTANCE = new IntArrayConverter();

        private IntArrayConverter() {
        }

        @Override
        public int getLength(int[] array) {
            return array.length;
        }

        @Override
        public double getDouble(int[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(int[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(int[] array, int index) {
            return (byte)array[index];
        }

        static /* synthetic */ IntArrayConverter access$3000() {
            return INSTANCE;
        }
    }

    private static final class LongArrayConverter
    implements ArrayConverter<long[]> {
        private static final LongArrayConverter INSTANCE = new LongArrayConverter();

        private LongArrayConverter() {
        }

        @Override
        public int getLength(long[] array) {
            return array.length;
        }

        @Override
        public double getDouble(long[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(long[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(long[] array, int index) {
            return (byte)array[index];
        }

        static /* synthetic */ LongArrayConverter access$2900() {
            return INSTANCE;
        }
    }

    private static final class FloatArrayConverter
    implements ArrayConverter<float[]> {
        private static final FloatArrayConverter INSTANCE = new FloatArrayConverter();

        private FloatArrayConverter() {
        }

        @Override
        public int getLength(float[] array) {
            return array.length;
        }

        @Override
        public double getDouble(float[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(float[] array, int index) {
            return array[index];
        }

        @Override
        public byte getByte(float[] array, int index) {
            return (byte)array[index];
        }

        static /* synthetic */ FloatArrayConverter access$2800() {
            return INSTANCE;
        }
    }

    private static final class DoubleArrayConverter
    implements ArrayConverter<double[]> {
        private static final DoubleArrayConverter INSTANCE = new DoubleArrayConverter();

        private DoubleArrayConverter() {
        }

        @Override
        public int getLength(double[] array) {
            return array.length;
        }

        @Override
        public double getDouble(double[] array, int index) {
            return array[index];
        }

        @Override
        public float getFloat(double[] array, int index) {
            return (float)array[index];
        }

        @Override
        public byte getByte(double[] array, int index) {
            return (byte)array[index];
        }

        static /* synthetic */ DoubleArrayConverter access$3400() {
            return INSTANCE;
        }
    }

    private static interface ArrayConverter<T> {
        public int getLength(T var1);

        public double getDouble(T var1, int var2);

        public float getFloat(T var1, int var2);

        public byte getByte(T var1, int var2);
    }

    static final class Int8ConversionEncoder<T>
    extends Encoder<T> {
        private static final Int8ConversionEncoder<double[]> DOUBLE_ENCODER = new Int8ConversionEncoder<double[]>(DoubleArrayConverter.access$3400());
        private static final Int8ConversionEncoder<float[]> FLOAT_ENCODER = new Int8ConversionEncoder<float[]>(FloatArrayConverter.access$2800());
        private static final Int8ConversionEncoder<long[]> LONG_ENCODER = new Int8ConversionEncoder<long[]>(LongArrayConverter.access$2900());
        private static final Int8ConversionEncoder<int[]> INT_ENCODER = new Int8ConversionEncoder<int[]>(IntArrayConverter.access$3000());
        private static final Int8ConversionEncoder<short[]> SHORT_ENCODER = new Int8ConversionEncoder<short[]>(ShortArrayConverter.access$3100());
        private static final Int8ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Int8ConversionEncoder<boolean[]>(BooleanArrayConverter.access$3300());
        private final ArrayConverter<T> converter;

        Int8ConversionEncoder(ArrayConverter<T> converter) {
            super((byte)4);
            this.converter = converter;
        }

        @Override
        protected void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getLength(values);
            for (int i = 0; i < length; ++i) {
                data.put(this.converter.getByte(values, i));
            }
        }

        @Override
        protected double computeNorm(T values) {
            int length = this.getLength(values);
            long squareSum = 0L;
            for (int i = 0; i < length; ++i) {
                byte value = this.converter.getByte(values, i);
                squareSum += (long)(value * value);
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(T values) {
            return this.converter.getLength(values);
        }
    }

    static final class Float32ConversionEncoder<T>
    extends Encoder<T> {
        private static final Float32ConversionEncoder<double[]> DOUBLE_ENCODER = new Float32ConversionEncoder<double[]>(DoubleArrayConverter.access$3400());
        private static final Float32ConversionEncoder<long[]> LONG_ENCODER = new Float32ConversionEncoder<long[]>(LongArrayConverter.access$2900());
        private static final Float32ConversionEncoder<int[]> INT_ENCODER = new Float32ConversionEncoder<int[]>(IntArrayConverter.access$3000());
        private static final Float32ConversionEncoder<short[]> SHORT_ENCODER = new Float32ConversionEncoder<short[]>(ShortArrayConverter.access$3100());
        private static final Float32ConversionEncoder<byte[]> BYTE_ENCODER = new Float32ConversionEncoder<byte[]>(ByteArrayConverter.access$3200());
        private static final Float32ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Float32ConversionEncoder<boolean[]>(BooleanArrayConverter.access$3300());
        private final ArrayConverter<T> converter;

        Float32ConversionEncoder(ArrayConverter<T> converter) {
            super((byte)2);
            this.converter = converter;
        }

        @Override
        protected void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getLength(values);
            int bufferSize = Math.min(length, 4096);
            float[] buffer = new float[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int bufferIndex = 0;
                while (bufferIndex < buffer.length && valueIndex < length) {
                    buffer[bufferIndex++] = this.converter.getFloat(values, valueIndex++);
                }
                data.putFloats(buffer, 0, bufferIndex, NUMBER_ENCODING);
            }
        }

        @Override
        protected double computeNorm(T values) {
            int length = this.getLength(values);
            double squareSum = 0.0;
            for (int i = 0; i < length; ++i) {
                float value = this.converter.getFloat(values, i);
                squareSum += (double)(value * value);
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(T values) {
            return this.converter.getLength(values);
        }
    }

    private static final class Float64ConversionEncoder<T>
    extends Encoder<T> {
        private static final Float64ConversionEncoder<float[]> FLOAT_ENCODER = new Float64ConversionEncoder<float[]>(FloatArrayConverter.access$2800());
        private static final Float64ConversionEncoder<long[]> LONG_ENCODER = new Float64ConversionEncoder<long[]>(LongArrayConverter.access$2900());
        private static final Float64ConversionEncoder<int[]> INT_ENCODER = new Float64ConversionEncoder<int[]>(IntArrayConverter.access$3000());
        private static final Float64ConversionEncoder<short[]> SHORT_ENCODER = new Float64ConversionEncoder<short[]>(ShortArrayConverter.access$3100());
        private static final Float64ConversionEncoder<byte[]> BYTE_ENCODER = new Float64ConversionEncoder<byte[]>(ByteArrayConverter.access$3200());
        private static final Float64ConversionEncoder<boolean[]> BOOLEAN_ENCODER = new Float64ConversionEncoder<boolean[]>(BooleanArrayConverter.access$3300());
        private final ArrayConverter<T> converter;

        Float64ConversionEncoder(ArrayConverter<T> converter) {
            super((byte)3);
            this.converter = converter;
        }

        @Override
        protected void encodeValues(T values, ByteArray data) throws SQLException {
            int length = this.getLength(values);
            int bufferSize = Math.min(length, 2048);
            double[] buffer = new double[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int bufferIndex = 0;
                while (bufferIndex < buffer.length && valueIndex < length) {
                    buffer[bufferIndex++] = this.converter.getDouble(values, valueIndex++);
                }
                data.putDoubles(buffer, 0, bufferIndex, NUMBER_ENCODING);
            }
        }

        @Override
        protected double computeNorm(T values) {
            int length = this.getLength(values);
            double squareSum = 0.0;
            for (int i = 0; i < length; ++i) {
                double value = this.converter.getDouble(values, i);
                squareSum += value * value;
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(T values) {
            return this.converter.getLength(values);
        }
    }

    private static final class Int8Encoder
    extends Encoder<byte[]> {
        private static final Int8Encoder INSTANCE = new Int8Encoder();

        Int8Encoder() {
            super((byte)4);
        }

        @Override
        protected void encodeValues(byte[] values, ByteArray data) throws SQLException {
            data.put(values);
        }

        @Override
        protected double computeNorm(byte[] values) {
            long squareSum = 0L;
            for (byte value : values) {
                squareSum += (long)(value * value);
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(byte[] values) {
            return values.length;
        }
    }

    private static final class Float32Encoder
    extends Encoder<float[]> {
        private static final Float32Encoder INSTANCE = new Float32Encoder();

        Float32Encoder() {
            super((byte)2);
        }

        @Override
        protected void encodeValues(float[] values, ByteArray data) throws SQLException {
            data.putFloats(values, NUMBER_ENCODING);
        }

        @Override
        protected double computeNorm(float[] values) {
            double squareSum = 0.0;
            for (float value : values) {
                squareSum += (double)(value * value);
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(float[] values) {
            return values.length;
        }
    }

    private static final class Float64Encoder
    extends Encoder<double[]> {
        private static final Float64Encoder INSTANCE = new Float64Encoder();

        Float64Encoder() {
            super((byte)3);
        }

        @Override
        protected void encodeValues(double[] values, ByteArray data) throws SQLException {
            data.putDoubles(values, NUMBER_ENCODING);
        }

        @Override
        protected double computeNorm(double[] values) {
            double squareSum = 0.0;
            for (double value : values) {
                squareSum += value * value;
            }
            return Math.sqrt(squareSum);
        }

        @Override
        protected int getLength(double[] values) {
            return values.length;
        }
    }

    static abstract class Encoder<T> {
        protected static final ByteArray.NumberEncoding NUMBER_ENCODING = Encoder.getNumberEncoding();
        private final byte dimensionType;

        private static ByteArray.NumberEncoding getNumberEncoding() {
            String configuredEncoding = System.getProperty("oracle.jdbc.vectorEncoding");
            if (configuredEncoding == null) {
                return ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN;
            }
            try {
                return ByteArray.NumberEncoding.valueOf(configuredEncoding);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                return ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN;
            }
        }

        protected Encoder(byte dimensionType) {
            this.dimensionType = dimensionType;
        }

        final int getByteLength(T values) {
            int dimensionBytes;
            int valuesLength = this.getLength(values);
            switch (this.dimensionType) {
                case 3: {
                    dimensionBytes = valuesLength << 3;
                    break;
                }
                case 2: {
                    dimensionBytes = valuesLength << 2;
                    break;
                }
                case 4: {
                    dimensionBytes = valuesLength;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized type: " + this.dimensionType);
                }
            }
            return 17 + dimensionBytes;
        }

        final void encode(T values, boolean isComputingNorm, ByteArray data) throws SQLException {
            data.put((byte)-37);
            data.put((byte)0);
            int length = this.getLength(values);
            short flag1 = 2;
            if (!isComputingNorm) {
                flag1 = (short)(flag1 | 0x10);
            }
            if (NUMBER_ENCODING.isIeee()) {
                flag1 = (short)(flag1 | 8);
            }
            if (NUMBER_ENCODING.byteOrder() == ByteOrder.LITTLE_ENDIAN) {
                flag1 = (short)(flag1 | 1);
            }
            data.putShort(flag1);
            data.put(this.dimensionType);
            data.putInt(length);
            if (isComputingNorm) {
                data.putDouble(this.computeNorm(values), NUMBER_ENCODING);
            } else {
                data.putLong(-1L);
            }
            this.encodeValues(values, data);
        }

        protected abstract double computeNorm(T var1);

        protected abstract void encodeValues(T var1, ByteArray var2) throws SQLException;

        protected abstract int getLength(T var1);
    }

    private static final class IeeeFloat64Decoder
    extends Float64Decoder {
        private static final IeeeFloat64Decoder BIG_ENDIAN = new IeeeFloat64Decoder(ByteArray.NumberEncoding.IEEE_BIG_ENDIAN);
        private static final IeeeFloat64Decoder LITTLE_ENDIAN = new IeeeFloat64Decoder(ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN);

        private IeeeFloat64Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }
    }

    private static final class OracleFloat64Decoder
    extends Float64Decoder {
        static final OracleFloat64Decoder BIG_ENDIAN = new OracleFloat64Decoder(ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
        static final OracleFloat64Decoder LITTLE_ENDIAN = new OracleFloat64Decoder(ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN);

        private OracleFloat64Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }

        @Override
        public Decoder toIeee(ByteArray data, int length) throws SQLException {
            return this.numberEncoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? this.littleEndianToIeee(data, length) : this.bigEndianToIeee(data, length);
        }

        private Decoder bigEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 3);
            for (position = data.getPosition(); position < limit; position += 8L) {
                long bits = data.getLong(position);
                if ((bits & Long.MIN_VALUE) != 0L) {
                    data.put(position, (byte)(bits >> 56 & 0x7FL));
                    continue;
                }
                data.putLong(position, bits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return IeeeFloat64Decoder.BIG_ENDIAN;
        }

        private Decoder littleEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 3);
            for (position = data.getPosition(); position < limit; position += 8L) {
                long bits = data.getLong(position);
                if ((bits & 0x80L) != 0L) {
                    data.put(position + 7L, (byte)(bits & 0x7FL));
                    continue;
                }
                data.putLong(position, bits ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return IeeeFloat64Decoder.LITTLE_ENDIAN;
        }
    }

    private static abstract class Float64Decoder
    extends Decoder {
        protected static final DecimalFormat POSITIVE_FORMAT;
        protected static final DecimalFormat NEGATIVE_FORMAT;
        protected final ByteArray.NumberEncoding numberEncoding;

        Float64Decoder(ByteArray.NumberEncoding numberEncoding) {
            this.numberEncoding = numberEncoding;
        }

        @Override
        final int byteLength() {
            return 8;
        }

        @Override
        final void decodeDoubles(ByteArray data, double[] array, int length) {
            data.getDoubles(array, 0, length, this.numberEncoding);
        }

        @Override
        final void decodeBooleans(ByteArray data, boolean[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = value != 0.0;
            }, length);
        }

        @Override
        final void decodeBytes(ByteArray data, byte[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = (byte)value;
            }, length);
        }

        @Override
        final void decodeInts(ByteArray data, int[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = (int)value;
            }, length);
        }

        @Override
        final void decodeShorts(ByteArray data, short[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = (short)value;
            }, length);
        }

        @Override
        final void decodeLongs(ByteArray data, long[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = (long)value;
            }, length);
        }

        @Override
        final void decodeFloats(ByteArray data, float[] array, int length) {
            this.streamDoubles(data, (index, value) -> {
                array[index] = (float)value;
            }, length);
        }

        @Override
        final String decodeString(ByteArray data, int length) {
            DecimalFormat positiveFormat = (DecimalFormat)POSITIVE_FORMAT.clone();
            DecimalFormat negativeFormat = (DecimalFormat)NEGATIVE_FORMAT.clone();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            this.streamDoubles(data, (index, value) -> {
                if (index > 0) {
                    stringBuilder.append(',');
                }
                String stringValue = value == 0.0 ? "0" : (value >= 1.0 || value <= -1.0 ? positiveFormat.format(value) : negativeFormat.format(value));
                stringBuilder.append(stringValue);
            }, length);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        private void streamDoubles(ByteArray data, IntDoubleConsumer consumer, int length) {
            int bufferSize = Math.min(length, 2048);
            double[] buffer = new double[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int getLength = Math.min(length - valueIndex, bufferSize);
                this.decodeDoubles(data, buffer, getLength);
                for (int i = 0; i < getLength; ++i) {
                    consumer.accept(valueIndex++, buffer[i]);
                }
            }
        }

        static {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            decimalFormatSymbols.setExponentSeparator("E+");
            POSITIVE_FORMAT = new DecimalFormat("0.0###############E000", decimalFormatSymbols);
            POSITIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            NEGATIVE_FORMAT = new DecimalFormat("0.0###############E000", decimalFormatSymbols);
            NEGATIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
        }

        private static interface IntDoubleConsumer {
            public void accept(int var1, double var2);
        }
    }

    private static final class IeeeFloat32Decoder
    extends Float32Decoder {
        static final IeeeFloat32Decoder BIG_ENDIAN = new IeeeFloat32Decoder(ByteArray.NumberEncoding.IEEE_BIG_ENDIAN);
        static final IeeeFloat32Decoder LITTLE_ENDIAN = new IeeeFloat32Decoder(ByteArray.NumberEncoding.IEEE_LITTLE_ENDIAN);

        private IeeeFloat32Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }
    }

    private static final class OracleFloat32Decoder
    extends Float32Decoder {
        private static final OracleFloat32Decoder BIG_ENDIAN = new OracleFloat32Decoder(ByteArray.NumberEncoding.ORACLE_BIG_ENDIAN);
        private static final OracleFloat32Decoder LITTLE_ENDIAN = new OracleFloat32Decoder(ByteArray.NumberEncoding.ORACLE_LITTLE_ENDIAN);

        private OracleFloat32Decoder(ByteArray.NumberEncoding numberEncoding) {
            super(numberEncoding);
        }

        @Override
        protected Decoder toIeee(ByteArray data, int length) throws SQLException {
            return this.numberEncoding.byteOrder() == ByteOrder.LITTLE_ENDIAN ? this.littleEndianToIeee(data, length) : this.bigEndianToIeee(data, length);
        }

        private Decoder bigEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 2);
            for (position = data.getPosition(); position < limit; position += 4L) {
                int bits = data.getInt(position);
                if ((bits & Integer.MIN_VALUE) != 0) {
                    data.put(position, (byte)(bits >> 24 & 0x7F));
                    continue;
                }
                data.putInt(position, ~bits);
            }
            return IeeeFloat32Decoder.BIG_ENDIAN;
        }

        private Decoder littleEndianToIeee(ByteArray data, int length) throws SQLException {
            long position;
            long limit = position + ((long)length << 2);
            for (position = data.getPosition(); position < limit; position += 4L) {
                int bits = data.getInt(position);
                if ((bits & 0x80) != 0) {
                    data.put(position + 3L, (byte)(bits & 0x7F));
                    continue;
                }
                data.putInt(position, ~bits);
            }
            return IeeeFloat32Decoder.LITTLE_ENDIAN;
        }
    }

    private static abstract class Float32Decoder
    extends Decoder {
        protected static final DecimalFormat POSITIVE_FORMAT;
        protected static final DecimalFormat NEGATIVE_FORMAT;
        protected final ByteArray.NumberEncoding numberEncoding;

        Float32Decoder(ByteArray.NumberEncoding numberEncoding) {
            this.numberEncoding = numberEncoding;
        }

        @Override
        final int byteLength() {
            return 4;
        }

        @Override
        final void decodeFloats(ByteArray data, float[] floatArray, int length) {
            data.getFloats(floatArray, 0, length, this.numberEncoding);
        }

        @Override
        final void decodeBooleans(ByteArray data, boolean[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = value != 0.0f;
            }, length);
        }

        @Override
        final void decodeBytes(ByteArray data, byte[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = (byte)value;
            }, length);
        }

        @Override
        final void decodeInts(ByteArray data, int[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = (int)value;
            }, length);
        }

        @Override
        final void decodeShorts(ByteArray data, short[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = (short)value;
            }, length);
        }

        @Override
        final void decodeLongs(ByteArray data, long[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = (long)value;
            }, length);
        }

        @Override
        final void decodeDoubles(ByteArray data, double[] array, int length) {
            this.streamFloats(data, (index, value) -> {
                array[index] = value;
            }, length);
        }

        @Override
        final String decodeString(ByteArray data, int length) {
            DecimalFormat positiveFormat = (DecimalFormat)POSITIVE_FORMAT.clone();
            DecimalFormat negativeFormat = (DecimalFormat)NEGATIVE_FORMAT.clone();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            this.streamFloats(data, (index, value) -> {
                if (index > 0) {
                    stringBuilder.append(',');
                }
                String stringValue = value == 0.0f ? "0" : (value >= 1.0f || value <= -1.0f ? positiveFormat.format(value) : negativeFormat.format(value));
                stringBuilder.append(stringValue);
            }, length);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }

        private void streamFloats(ByteArray data, IntFloatConsumer consumer, int length) {
            int bufferSize = Math.min(length, 4096);
            float[] buffer = new float[bufferSize];
            int valueIndex = 0;
            while (valueIndex < length) {
                int getLength = Math.min(length - valueIndex, bufferSize);
                this.decodeFloats(data, buffer, getLength);
                for (int i = 0; i < getLength; ++i) {
                    consumer.accept(valueIndex++, buffer[i]);
                }
            }
        }

        static {
            DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            decimalFormatSymbols.setExponentSeparator("E+");
            POSITIVE_FORMAT = new DecimalFormat("0.0#######E000", decimalFormatSymbols);
            POSITIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
            decimalFormatSymbols = DecimalFormatSymbols.getInstance(Locale.US);
            NEGATIVE_FORMAT = new DecimalFormat("0.0#######E000", decimalFormatSymbols);
            NEGATIVE_FORMAT.setRoundingMode(RoundingMode.HALF_EVEN);
        }

        private static interface IntFloatConsumer {
            public void accept(int var1, float var2);
        }
    }

    private static final class Int8Decoder
    extends Decoder {
        private static final Int8Decoder INSTANCE = new Int8Decoder();

        private Int8Decoder() {
        }

        @Override
        int byteLength() {
            return 1;
        }

        @Override
        void decodeBooleans(ByteArray data, boolean[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get() != 0;
            }
        }

        @Override
        void decodeBytes(ByteArray data, byte[] array, int length) {
            data.getBytes(array, 0, length);
        }

        @Override
        void decodeShorts(ByteArray data, short[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
        }

        @Override
        void decodeInts(ByteArray data, int[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
        }

        @Override
        void decodeLongs(ByteArray data, long[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
        }

        @Override
        void decodeFloats(ByteArray data, float[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
        }

        @Override
        void decodeDoubles(ByteArray data, double[] array, int length) {
            for (int i = 0; i < length; ++i) {
                array[i] = data.get();
            }
        }

        @Override
        String decodeString(ByteArray data, int length) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            for (int i = 0; i < length; ++i) {
                byte value = data.get();
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(value);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    private static abstract class Decoder {
        private Decoder() {
        }

        private <T> T decode(ByteArray data, int length, Class<T> decodedClass) {
            if (decodedClass == double[].class) {
                double[] doubleArray = new double[length];
                this.decodeDoubles(data, doubleArray, length);
                return (T)doubleArray;
            }
            if (decodedClass == float[].class) {
                float[] floatArray = new float[length];
                this.decodeFloats(data, floatArray, length);
                return (T)floatArray;
            }
            if (decodedClass == byte[].class) {
                byte[] array = new byte[length];
                this.decodeBytes(data, array, length);
                return (T)array;
            }
            if (decodedClass == short[].class) {
                short[] array = new short[length];
                this.decodeShorts(data, array, length);
                return (T)array;
            }
            if (decodedClass == int[].class) {
                int[] array = new int[length];
                this.decodeInts(data, array, length);
                return (T)array;
            }
            if (decodedClass == long[].class) {
                long[] array = new long[length];
                this.decodeLongs(data, array, length);
                return (T)array;
            }
            if (decodedClass == boolean[].class) {
                boolean[] array = new boolean[length];
                this.decodeBooleans(data, array, length);
                return (T)array;
            }
            if (decodedClass == String.class) {
                return decodedClass.cast(this.decodeString(data, length));
            }
            throw new IllegalStateException(decodedClass.getSimpleName());
        }

        protected Decoder toIeee(ByteArray data, int length) throws SQLException {
            return this;
        }

        abstract int byteLength();

        abstract void decodeBooleans(ByteArray var1, boolean[] var2, int var3);

        abstract void decodeBytes(ByteArray var1, byte[] var2, int var3);

        abstract void decodeShorts(ByteArray var1, short[] var2, int var3);

        abstract void decodeInts(ByteArray var1, int[] var2, int var3);

        abstract void decodeLongs(ByteArray var1, long[] var2, int var3);

        abstract void decodeFloats(ByteArray var1, float[] var2, int var3);

        abstract void decodeDoubles(ByteArray var1, double[] var2, int var3);

        abstract String decodeString(ByteArray var1, int var2);
    }
}

