/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.driver.AbstractTrueCacheConnection;
import oracle.jdbc.driver.AbstractTrueCacheResultSet;
import oracle.jdbc.driver.AbstractTrueCacheStatement;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OraclePreparedStatement;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@ProxyFor(value={OraclePreparedStatement.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractTrueCachePreparedStatement
extends AbstractTrueCacheStatement {
    protected String originalSql;
    ConcurrentHashMap<Integer, AbstractTrueCacheStatement.CallHistoryEntry> bindMap = new ConcurrentHashMap();
    private AutoKeyInfo autoKeyInfo;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    List<ConcurrentHashMap<Integer, AbstractTrueCacheStatement.CallHistoryEntry>> bindBatchList = new ArrayList<ConcurrentHashMap<Integer, AbstractTrueCacheStatement.CallHistoryEntry>>();

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Statement getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Statement var1);

    void initialize(AbstractTrueCacheConnection connection, String sql, OracleResultSet.ResultSetType resultSetType, int statementType) throws SQLException {
        this.originalSql = sql;
        super.initialize(connection, resultSetType, statementType);
    }

    void initialize(AbstractTrueCacheConnection connection, String sql, AutoKeyInfo autoKeyInfo, int statementType) throws SQLException {
        this.autoKeyInfo = autoKeyInfo;
        this.initialize(connection, sql, OracleResultSet.ResultSetType.UNKNOWN, statementType);
    }

    @Override
    protected void createStatement(AbstractTrueCacheConnection connection) throws SQLException {
        this.primaryStatement = this.createPreparedStatement(connection.getPrimaryConnection(), this.originalSql);
        OracleConnection tcConnectionP = connection.getTrueCacheConnection();
        if (tcConnectionP != null) {
            this.tcStatement = this.createPreparedStatement(tcConnectionP, this.originalSql);
        }
    }

    public void setArray(int paramIndex, Array x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setArray";
            Class[] argsType = new Class[]{Integer.TYPE, Array.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBigDecimal";
            Class[] argsType = new Class[]{Integer.TYPE, BigDecimal.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlob(int paramIndex, Blob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlob";
            Class[] argsType = new Class[]{Integer.TYPE, Blob.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBoolean(int paramIndex, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBoolean";
            Class[] argsType = new Class[]{Integer.TYPE, Boolean.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setByte(int paramIndex, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setByte";
            Class[] argsType = new Class[]{Integer.TYPE, Byte.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBytes";
            Class[] argsType = new Class[]{Integer.TYPE, byte[].class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClob(int paramIndex, Clob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClob";
            Class[] argsType = new Class[]{Integer.TYPE, Clob.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDate(int paramIndex, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDate";
            Class[] argsType = new Class[]{Integer.TYPE, Date.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDate(int paramIndex, Date x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDate";
            Class[] argsType = new Class[]{Integer.TYPE, Date.class, Calendar.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDouble";
            Class[] argsType = new Class[]{Integer.TYPE, Double.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setFloat";
            Class[] argsType = new Class[]{Integer.TYPE, Float.TYPE};
            Object[] args = new Object[]{paramIndex, Float.valueOf(x)};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setInt(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setInt";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setLong(int paramIndex, long x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setLong";
            Class[] argsType = new Class[]{Integer.TYPE, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClob(int paramIndex, NClob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClob";
            Class[] argsType = new Class[]{Integer.TYPE, NClob.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNString(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNString";
            Class[] argsType = new Class[]{Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setObject(int paramIndex, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObject";
            Class[] argsType = new Class[]{Integer.TYPE, Object.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setObject(int paramIndex, Object x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObject";
            Class[] argsType = new Class[]{Integer.TYPE, Object.class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRef(int paramIndex, Ref x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRef";
            Class[] argsType = new Class[]{Integer.TYPE, Ref.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRowId(int paramIndex, RowId x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRowId";
            Class[] argsType = new Class[]{Integer.TYPE, RowId.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setShort(int paramIndex, short x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setShort";
            Class[] argsType = new Class[]{Integer.TYPE, Short.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setSQLXML(int paramIndex, SQLXML x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setSQLXML";
            Class[] argsType = new Class[]{Integer.TYPE, SQLXML.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setString(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setString";
            Class[] argsType = new Class[]{Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTime(int paramIndex, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTime";
            Class[] argsType = new Class[]{Integer.TYPE, Time.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTime(int paramIndex, Time x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTime";
            Class[] argsType = new Class[]{Integer.TYPE, Time.class, Calendar.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimestamp";
            Class[] argsType = new Class[]{Integer.TYPE, Timestamp.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimestamp(int paramIndex, Timestamp x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimestamp";
            Class[] argsType = new Class[]{Integer.TYPE, Timestamp.class, Calendar.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setURL(int paramIndex, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setURL";
            Class[] argsType = new Class[]{Integer.TYPE, URL.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setARRAY(int paramIndex, ARRAY x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setARRAY";
            Class[] argsType = new Class[]{Integer.TYPE, ARRAY.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBFILE(int paramIndex, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBFILE";
            Class[] argsType = new Class[]{Integer.TYPE, BFILE.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBfile(int paramIndex, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBfile";
            Class[] argsType = new Class[]{Integer.TYPE, BFILE.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryFloat";
            Class[] argsType = new Class[]{Integer.TYPE, Float.TYPE};
            Object[] args = new Object[]{paramIndex, Float.valueOf(x)};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryFloat(int paramIndex, BINARY_FLOAT x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryFloat";
            Class[] argsType = new Class[]{Integer.TYPE, BINARY_FLOAT.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryDouble";
            Class[] argsType = new Class[]{Integer.TYPE, Double.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryDouble(int paramIndex, BINARY_DOUBLE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryDouble";
            Class[] argsType = new Class[]{Integer.TYPE, BINARY_DOUBLE.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBLOB(int paramIndex, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBLOB";
            Class[] argsType = new Class[]{Integer.TYPE, BLOB.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCHAR(int paramIndex, CHAR x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCHAR";
            Class[] argsType = new Class[]{Integer.TYPE, CHAR.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCLOB(int paramIndex, CLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCLOB";
            Class[] argsType = new Class[]{Integer.TYPE, CLOB.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCursor(int paramIndex, ResultSet x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCursor";
            Class[] argsType = new Class[]{Integer.TYPE, ResultSet.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDATE(int paramIndex, DATE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDATE";
            Class[] argsType = new Class[]{Integer.TYPE, DATE.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setFixedCHAR(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setFixedCHAR";
            Class[] argsType = new Class[]{Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setINTERVALDS";
            Class[] argsType = new Class[]{Integer.TYPE, INTERVALDS.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setINTERVALYM";
            Class[] argsType = new Class[]{Integer.TYPE, INTERVALYM.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNUMBER(int paramIndex, NUMBER x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNUMBER";
            Class[] argsType = new Class[]{Integer.TYPE, NUMBER.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setOPAQUE(int paramIndex, OPAQUE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setOPAQUE";
            Class[] argsType = new Class[]{Integer.TYPE, OPAQUE.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setOracleObject";
            Class[] argsType = new Class[]{Integer.TYPE, Datum.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setORAData";
            Class[] argsType = new Class[]{Integer.TYPE, ORAData.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRAW(int paramIndex, RAW x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRAW";
            Class[] argsType = new Class[]{Integer.TYPE, RAW.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setREF(int paramIndex, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setREF";
            Class[] argsType = new Class[]{Integer.TYPE, REF.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRefType(int paramIndex, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRefType";
            Class[] argsType = new Class[]{Integer.TYPE, REF.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setROWID(int paramIndex, ROWID x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setROWID";
            Class[] argsType = new Class[]{Integer.TYPE, ROWID.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setSTRUCT(int paramIndex, STRUCT x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setSTRUCT";
            Class[] argsType = new Class[]{Integer.TYPE, STRUCT.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMPLTZ";
            Class[] argsType = new Class[]{Integer.TYPE, TIMESTAMPLTZ.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMPTZ";
            Class[] argsType = new Class[]{Integer.TYPE, TIMESTAMPTZ.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMP";
            Class[] argsType = new Class[]{Integer.TYPE, TIMESTAMP.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCustomDatum";
            Class[] argsType = new Class[]{Integer.TYPE, CustomDatum.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlob(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlob";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlob(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlob";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClob(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClob";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClob(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClob";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClob(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClob";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClob(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClob";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStream(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStream(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStream(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStream(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStream(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStream";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStream(int paramIndex, Reader x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStream";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStream(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStream";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNCharacterStream(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNCharacterStream";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNCharacterStream(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNCharacterStream";
            Class[] argsType = new Class[]{Integer.TYPE, Reader.class, Long.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setUnicodeStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setUnicodeStream";
            Class[] argsType = new Class[]{Integer.TYPE, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setStructDescriptor(int paramIndex, StructDescriptor x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setStructDescriptor";
            Class[] argsType = new Class[]{Integer.TYPE, StructDescriptor.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setStringForClob(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setStringForClob";
            Class[] argsType = new Class[]{Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBytesForBlob";
            Class[] argsType = new Class[]{Integer.TYPE, byte[].class};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNull(int paramIndex, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNull";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNull(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNull";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setInternalBytes(int paramIndex, byte[] x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setInternalBytes";
            Class[] argsType = new Class[]{Integer.TYPE, byte[].class, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setArrayAtName(String parameterName, Array x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setArrayAtName";
            Class[] argsType = new Class[]{String.class, Array.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBigDecimalAtName(String parameterName, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBigDecimalAtName";
            Class[] argsType = new Class[]{String.class, BigDecimal.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlobAtName(String parameterName, Blob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlobAtName";
            Class[] argsType = new Class[]{String.class, Blob.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBooleanAtName(String parameterName, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBooleanAtName";
            Class[] argsType = new Class[]{String.class, Boolean.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setByteAtName(String parameterName, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setByteAtName";
            Class[] argsType = new Class[]{String.class, Byte.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBytesAtName(String parameterName, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBytesAtName";
            Class[] argsType = new Class[]{String.class, byte[].class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClobAtName(String parameterName, Clob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClobAtName";
            Class[] argsType = new Class[]{String.class, Clob.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDateAtName(String parameterName, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDateAtName";
            Class[] argsType = new Class[]{String.class, Date.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDateAtName(String parameterName, Date x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDateAtName";
            Class[] argsType = new Class[]{String.class, Date.class, Calendar.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDoubleAtName(String parameterName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDoubleAtName";
            Class[] argsType = new Class[]{String.class, Double.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setFloatAtName(String parameterName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setFloatAtName";
            Class[] argsType = new Class[]{String.class, Float.TYPE};
            Object[] args = new Object[]{parameterName, Float.valueOf(x)};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setIntAtName(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setIntAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setLongAtName(String parameterName, long x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setLongAtName";
            Class[] argsType = new Class[]{String.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClobAtName(String parameterName, NClob x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClobAtName";
            Class[] argsType = new Class[]{String.class, NClob.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNStringAtName(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNStringAtName";
            Class[] argsType = new Class[]{String.class, String.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setObjectAtName(String parameterName, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObjectAtName";
            Class[] argsType = new Class[]{String.class, Object.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setObjectAtName(String parameterName, Object x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObjectAtName";
            Class[] argsType = new Class[]{String.class, Object.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRefAtName(String parameterName, Ref x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRefAtName";
            Class[] argsType = new Class[]{String.class, Ref.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRowIdAtName(String parameterName, RowId x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRowIdAtName";
            Class[] argsType = new Class[]{String.class, RowId.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setShortAtName(String parameterName, short x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setShortAtName";
            Class[] argsType = new Class[]{String.class, Short.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setSQLXMLAtName(String parameterName, SQLXML x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setSQLXMLAtName";
            Class[] argsType = new Class[]{String.class, SQLXML.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setStringAtName(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setStringAtName";
            Class[] argsType = new Class[]{String.class, String.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimeAtName(String parameterName, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimeAtName";
            Class[] argsType = new Class[]{String.class, Time.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimeAtName(String parameterName, Time x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimeAtName";
            Class[] argsType = new Class[]{String.class, Time.class, Calendar.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimestampAtName";
            Class[] argsType = new Class[]{String.class, Timestamp.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTimestampAtName(String parameterName, Timestamp x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTimestampAtName";
            Class[] argsType = new Class[]{String.class, Timestamp.class, Calendar.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setURLAtName(String parameterName, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setURLAtName";
            Class[] argsType = new Class[]{String.class, URL.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setARRAYAtName(String parameterName, ARRAY x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setARRAYAtName";
            Class[] argsType = new Class[]{String.class, ARRAY.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBFILEAtName(String parameterName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBFILEAtName";
            Class[] argsType = new Class[]{String.class, BFILE.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBfileAtName(String parameterName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBfileAtName";
            Class[] argsType = new Class[]{String.class, BFILE.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryFloatAtName(String parameterName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryFloatAtName";
            Class[] argsType = new Class[]{String.class, Float.TYPE};
            Object[] args = new Object[]{parameterName, Float.valueOf(x)};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryFloatAtName(String parameterName, BINARY_FLOAT x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryFloatAtName";
            Class[] argsType = new Class[]{String.class, BINARY_FLOAT.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryDoubleAtName(String parameterName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryDoubleAtName";
            Class[] argsType = new Class[]{String.class, Double.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryDoubleAtName(String parameterName, BINARY_DOUBLE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryDoubleAtName";
            Class[] argsType = new Class[]{String.class, BINARY_DOUBLE.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBLOBAtName(String parameterName, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBLOBAtName";
            Class[] argsType = new Class[]{String.class, BLOB.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCHARAtName(String parameterName, CHAR x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCHARAtName";
            Class[] argsType = new Class[]{String.class, CHAR.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCLOBAtName(String parameterName, CLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCLOBAtName";
            Class[] argsType = new Class[]{String.class, CLOB.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCursorAtName(String parameterName, ResultSet x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCursorAtName";
            Class[] argsType = new Class[]{String.class, ResultSet.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setDATEAtName(String parameterName, DATE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setDATEAtName";
            Class[] argsType = new Class[]{String.class, DATE.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setFixedCHARAtName(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setFixedCHARAtName";
            Class[] argsType = new Class[]{String.class, String.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setINTERVALDSAtName(String parameterName, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setINTERVALDSAtName";
            Class[] argsType = new Class[]{String.class, INTERVALDS.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setINTERVALYMAtName(String parameterName, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setINTERVALYMAtName";
            Class[] argsType = new Class[]{String.class, INTERVALYM.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNUMBERAtName(String parameterName, NUMBER x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNUMBERAtName";
            Class[] argsType = new Class[]{String.class, NUMBER.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setOPAQUEAtName(String parameterName, OPAQUE x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setOPAQUEAtName";
            Class[] argsType = new Class[]{String.class, OPAQUE.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setOracleObjectAtName(String parameterName, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setOracleObjectAtName";
            Class[] argsType = new Class[]{String.class, Datum.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setORADataAtName(String parameterName, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setORADataAtName";
            Class[] argsType = new Class[]{String.class, ORAData.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRAWAtName(String parameterName, RAW x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRAWAtName";
            Class[] argsType = new Class[]{String.class, RAW.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setREFAtName(String parameterName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setREFAtName";
            Class[] argsType = new Class[]{String.class, REF.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setRefTypeAtName(String parameterName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setRefTypeAtName";
            Class[] argsType = new Class[]{String.class, REF.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setROWIDAtName(String parameterName, ROWID x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setROWIDAtName";
            Class[] argsType = new Class[]{String.class, ROWID.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setSTRUCTAtName(String parameterName, STRUCT x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setSTRUCTAtName";
            Class[] argsType = new Class[]{String.class, STRUCT.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMPLTZAtName(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMPLTZAtName";
            Class[] argsType = new Class[]{String.class, TIMESTAMPLTZ.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMPTZAtName(String parameterName, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMPTZAtName";
            Class[] argsType = new Class[]{String.class, TIMESTAMPTZ.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setTIMESTAMPAtName(String parameterName, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setTIMESTAMPAtName";
            Class[] argsType = new Class[]{String.class, TIMESTAMP.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCustomDatumAtName(String parameterName, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCustomDatumAtName";
            Class[] argsType = new Class[]{String.class, CustomDatum.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlobAtName(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlobAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBlobAtName(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBlobAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClobAtName(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClobAtName";
            Class[] argsType = new Class[]{String.class, Reader.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setClobAtName(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setClobAtName";
            Class[] argsType = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClobAtName(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClobAtName";
            Class[] argsType = new Class[]{String.class, Reader.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNClobAtName(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNClobAtName";
            Class[] argsType = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setAsciiStreamAtName(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setAsciiStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBinaryStreamAtName(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBinaryStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStreamAtName";
            Class[] argsType = new Class[]{String.class, Reader.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStreamAtName";
            Class[] argsType = new Class[]{String.class, Reader.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCharacterStreamAtName(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setCharacterStreamAtName";
            Class[] argsType = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNCharacterStreamAtName";
            Class[] argsType = new Class[]{String.class, Reader.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNCharacterStreamAtName(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNCharacterStreamAtName";
            Class[] argsType = new Class[]{String.class, Reader.class, Long.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setUnicodeStreamAtName(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setUnicodeStreamAtName";
            Class[] argsType = new Class[]{String.class, InputStream.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNullAtName(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNullAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE, String.class};
            Object[] args = new Object[]{parameterName, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setNullAtName(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setNullAtName";
            Class[] argsType = new Class[]{String.class, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setStructDescriptorAtName(String parameterName, StructDescriptor x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setStructDescriptorAtName";
            Class[] argsType = new Class[]{String.class, StructDescriptor.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setStringForClobAtName(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setStringForClobAtName";
            Class[] argsType = new Class[]{String.class, String.class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setBytesForBlobAtName(String parameterName, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setBytesForBlobAtName";
            Class[] argsType = new Class[]{String.class, byte[].class};
            Object[] args = new Object[]{parameterName, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerReturnParameter(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerReturnParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerReturnParameter(int paramIndex, int x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerReturnParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void registerReturnParameter(int paramIndex, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "registerReturnParameter";
            Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
            Object[] args = new Object[]{paramIndex, x, y};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setCheckBindTypes(boolean flag) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                preparedStatement.setCheckBindTypes(flag);
            } else {
                Class[] argsType = new Class[]{Boolean.TYPE};
                Object[] args = new Object[]{flag};
                AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry("setCheckBindTypes", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void setFormOfUse(int parameterIndex, short formOfUse) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                preparedStatement.setFormOfUse(parameterIndex, formOfUse);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Short.TYPE};
                Object[] args = new Object[]{parameterIndex, formOfUse};
                AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry("setFormOfUse", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineParameterTypeBytes(int parameterIndex, int type, int maxSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                preparedStatement.defineParameterTypeBytes(parameterIndex, type, maxSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{parameterIndex, type, maxSize};
                AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry("defineParameterTypeBytes", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineParameterTypeChars(int parameterIndex, int type, int maxSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                preparedStatement.defineParameterTypeChars(parameterIndex, type, maxSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{parameterIndex, type, maxSize};
                AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry("defineParameterTypeChars", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public void defineParameterType(int parameterIndex, int type, int maxSize) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                preparedStatement.defineParameterType(parameterIndex, type, maxSize);
            } else {
                Class[] argsType = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
                Object[] args = new Object[]{parameterIndex, type, maxSize};
                AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry("defineParameterType", argsType, args);
                this.appendCallEntry(entry);
            }
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
            if (preparedStatement != null) {
                ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                return resultSetMetaData;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public void setObject(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObject";
            Class[] argsType = new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, x, targetSqlType, scale};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    public void setObjectAtName(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setObjectAtName";
            Class[] argsType = new Class[]{String.class, Object.class, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{parameterName, x, targetSqlType, scale};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            int paramIndex = this.addNamedPara(parameterName);
            this.bindMap.put(paramIndex, entry);
        }
    }

    @Deprecated
    public void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            String methodName = "setPlsqlIndexTable";
            Class[] argsType = new Class[]{Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
            Object[] args = new Object[]{paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen};
            AbstractTrueCacheStatement.CallHistoryEntry entry = new AbstractTrueCacheStatement.CallHistoryEntry(methodName, argsType, args);
            this.bindMap.put(paramIndex, entry);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected void prePstmtExecuteQuery(Method m, Object receiver, Object ... args) {
        try {
            ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionLock();
            this.ensureOpen();
            OraclePreparedStatement preparedStatement = this.getDelegatePreparedStatement();
            this.setDelegate(preparedStatement);
            this.delegatesBindCalls(preparedStatement, this.bindMap);
            this.delegatesBeforePstmtExecuteCalls(preparedStatement);
        }
        catch (SQLException ex) {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={})})
    protected ResultSet postPstmtExecuteQuery(Method m, ResultSet result) {
        try {
            result = this.createResultSetProxy(result);
            this.currentResultSet = (AbstractTrueCacheResultSet)((Object)result);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="executeUpdate", args={})})
    protected Object postPstmtExecuteUpdate(Method m, Object result) {
        try {
            Object object = result;
            return object;
        }
        finally {
            ((AbstractTrueCacheConnection)this.getCreator()).releaseConnectionLock();
        }
    }

    @OnError(value=SQLException.class)
    protected Object onErrorPstmt(Method m, SQLException e) throws SQLException {
        ((AbstractTrueCacheConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw e;
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="executeQuery", args={String.class}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preStmtExecuteQuery(Method m, Object receiver, Object ... args) {
        super.preStmtExecuteQuery(m, receiver, args);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={String.class})})
    protected ResultSet postStmtExecuteQuery(Method m, ResultSet result) {
        return super.postStmtExecuteQuery(m, result);
    }

    @Override
    @Post
    @Methods(signatures={@Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected Object postStmtExecuteUpdate(Method m, Object result) {
        return super.postStmtExecuteUpdate(m, result);
    }

    public ResultSet getReturnResultSet() throws SQLException {
        ResultSet result;
        block14: {
            result = null;
            AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OraclePreparedStatement preparedStatement = (OraclePreparedStatement)this.getDelegate();
                if (preparedStatement != null) {
                    result = preparedStatement.getReturnResultSet();
                    if (result != null) {
                        result = this.createResultSetProxy(result);
                        this.currentResultSet = (AbstractTrueCacheResultSet)((Object)result);
                    }
                    break block14;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1707).fillInStackTrace();
            }
        }
        return result;
    }

    public void clearParameters() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            ((OraclePreparedStatement)this.primaryStatement).clearParameters();
            ((OraclePreparedStatement)this.tcStatement).clearParameters();
            this.clearBindParams();
        }
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            OraclePreparedStatement psStatement = this.getDelegatePreparedStatement();
            ParameterMetaData parameterMetaData = psStatement.getParameterMetaData();
            return parameterMetaData;
        }
    }

    public String getOriginalSql() throws SQLException {
        return this.originalSql;
    }

    public void addBatch() throws SQLException {
        try (Monitor.CloseableLock lock = ((AbstractTrueCacheConnection)this.getCreator()).acquireConnectionCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.bindBatchList.add(this.bindMap);
            this.bindMap = new ConcurrentHashMap();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int[] executeBatch() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try {
            try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
                OraclePreparedStatement psStatement = this.getDelegatePreparedStatement();
                this.setDelegate(psStatement);
                this.delegatesBindBatchCalls(psStatement);
                int[] nArray = psStatement.executeBatch();
                return nArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.clearBatchItems();
            this.setDelegate(null);
        }
    }

    @Override
    public void close() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.clearBindParams();
            this.clearBatchItems();
            super.close();
            this.primaryStatement.close();
            if (this.tcStatement != null) {
                this.tcStatement.close();
            }
        }
    }

    @Override
    public void closeWithKey(String key) throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        try (Monitor.CloseableLock lock = applicationConnection.acquireConnectionCloseableLock();){
            this.getDelegatePreparedStatement().closeWithKey(key);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="enterImplicitCache", args={}), @Signature(name="enterExplicitCache", args={}), @Signature(name="exitImplicitCacheToActive", args={}), @Signature(name="exitExplicitCacheToActive", args={}), @Signature(name="exitImplicitCacheToClose", args={}), @Signature(name="exitExplicitCacheToClose", args={}), @Signature(name="setDisableStmtCaching", args={boolean.class}), @Signature(name="OracleGetParameterMetaData", args={})})
    protected void preUnsupportedPreparedStatementMethods(Method m, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="creationState", args={}), @Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={}), @Signature(name="setShardingKeyRpnTokens", args={byte[].class}), @Signature(name="getShardingKeyRpnTokens", args={}), @Signature(name="setCursorName", args={String.class}), @Signature(name="getserverCursor", args={})})
    protected void preUnsupportedStatementMethods(Method m, Object receiver, Object ... args) {
        super.preUnsupportedStatementMethods(m, receiver, args);
    }

    protected OraclePreparedStatement createPreparedStatement(OracleConnection connection, String sql) throws SQLException {
        if (this.autoKeyInfo == null) {
            return (OraclePreparedStatement)connection.prepareStatement(sql, this.resultSetType.getType(), this.resultSetType.getConcur());
        }
        switch (this.autoKeyInfo.getColumnIdentifier()) {
            case ROWID: {
                return (OraclePreparedStatement)connection.prepareStatement(sql, 1);
            }
            case INDEX: {
                return (OraclePreparedStatement)connection.prepareStatement(sql, this.autoKeyInfo.getColumnIndexes());
            }
            case NAME: {
                return (OraclePreparedStatement)connection.prepareStatement(sql, this.autoKeyInfo.getColumnNames());
            }
        }
        throw new IllegalStateException("Unrecognized identifier: " + (Object)((Object)this.autoKeyInfo.getColumnIdentifier()));
    }

    void delegatesBindCalls(OraclePreparedStatement preparedStatement, ConcurrentHashMap<Integer, AbstractTrueCacheStatement.CallHistoryEntry> currentBindMap) throws SQLException {
        try {
            for (AbstractTrueCacheStatement.CallHistoryEntry entry : currentBindMap.values()) {
                Method m = preparedStatement.getClass().getMethod(entry.methodName, entry.argsType);
                m.invoke((Object)preparedStatement, entry.args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    void delegatesBindBatchCalls(OraclePreparedStatement preparedStatement) throws SQLException {
        for (ConcurrentHashMap<Integer, AbstractTrueCacheStatement.CallHistoryEntry> currentBindMap : this.bindBatchList) {
            this.delegatesBindCalls(preparedStatement, currentBindMap);
            preparedStatement.addBatch();
        }
    }

    void delegatesBeforePstmtExecuteCalls(OraclePreparedStatement preparedStatement) throws SQLException {
        try {
            AbstractTrueCacheStatement.CallHistoryEntry entry = this.head;
            while (entry != this.tail) {
                Method m = preparedStatement.getClass().getMethod(entry.methodName, entry.argsType);
                m.invoke((Object)preparedStatement, entry.args);
                entry = entry.nextEntry;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new SQLException(ex);
        }
    }

    int addNamedPara(String parameterName) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (parameterName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String iParameterName = parameterName.toUpperCase().intern();
        for (int i = 0; i < this.parameterCount; ++i) {
            if (iParameterName != this.namedParameters[i]) continue;
            return i + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] newList = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, newList, 0, this.namedParameters.length);
            this.namedParameters = newList;
        }
        this.namedParameters[this.parameterCount++] = iParameterName;
        return this.parameterCount;
    }

    void clearBindParams() {
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.bindMap.clear();
    }

    @Override
    void clearBatchItems() {
        this.bindBatchList.clear();
    }

    private OraclePreparedStatement getDelegatePreparedStatement() throws SQLException {
        AbstractTrueCacheConnection applicationConnection = (AbstractTrueCacheConnection)this.getCreator();
        return applicationConnection.isReadOnly() && applicationConnection.getTrueCacheConnection() != null && this.tcStatement != null ? (OraclePreparedStatement)this.tcStatement : (OraclePreparedStatement)this.primaryStatement;
    }
}

