/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import oracle.jdbc.connector.OracleLocalTransaction;
import oracle.jdbc.connector.OracleManagedConnectionMetaData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.OracleXAConnection;

public class OracleManagedConnection
implements ManagedConnection {
    private OracleXAConnection xaConnection = null;
    private Hashtable connectionListeners = null;
    private Connection connection = null;
    private PrintWriter logWriter = null;
    private PasswordCredential passwordCredential = null;
    private OracleLocalTransaction localTxn = null;

    OracleManagedConnection(XAConnection xaconn) {
        this.xaConnection = (OracleXAConnection)xaconn;
        this.connectionListeners = new Hashtable(10);
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = this.xaConnection.getConnection();
            return this.connection;
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public void destroy() throws ResourceException {
        try {
            if (this.xaConnection != null) {
                Connection _pconn = this.xaConnection.getPhysicalHandle();
                if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)_pconn).getTxnMode() == 1) {
                    throw new IllegalStateException("Could not close connection while transaction is active");
                }
            }
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.xaConnection != null) {
                this.xaConnection.close();
            }
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public void cleanup() throws ResourceException {
        try {
            if (this.connection != null) {
                if (this.localTxn != null && this.localTxn.isBeginCalled || ((OracleConnection)this.connection).getTxnMode() == 1) {
                    throw new IllegalStateException("Could not close connection while transaction is active");
                }
                this.connection.close();
            }
        }
        catch (SQLException exc) {
            throw new EISSystemException("SQLException: " + exc.getMessage(), (Throwable)exc);
        }
    }

    public void associateConnection(Object connection) {
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionListeners.put(listener, listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionListeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        try {
            return this.xaConnection.getXAResource();
        }
        catch (SQLException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        if (this.localTxn == null) {
            this.localTxn = new OracleLocalTransaction(this);
        }
        return this.localTxn;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new OracleManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    Connection getPhysicalConnection() throws ResourceException {
        try {
            return this.xaConnection.getPhysicalHandle();
        }
        catch (Exception exc) {
            throw new EISSystemException("Exception: " + exc.getMessage(), (Throwable)exc);
        }
    }

    void setPasswordCredential(PasswordCredential pcred) {
        this.passwordCredential = pcred;
    }

    PasswordCredential getPasswordCredential() {
        return this.passwordCredential;
    }

    void eventOccurred(int eventType) throws ResourceException {
        Enumeration allListeners = this.connectionListeners.keys();
        block7: while (allListeners.hasMoreElements()) {
            ConnectionEventListener listener = (ConnectionEventListener)allListeners.nextElement();
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, eventType);
            switch (eventType) {
                case 1: {
                    listener.connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    listener.localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    listener.localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    listener.localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    listener.connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType in eventOccurred(): " + eventType);
        }
    }
}

