/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OracleOsonValueFactory;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonValueFactory;

public class OsonContext {
    protected final OsonBuffer b;
    protected final OsonHeader header;
    protected final OsonValueFactory valueFactory;
    protected final OracleJsonExceptions.ExceptionFactory exceptionFactory;

    public OsonContext(OsonBuffer osonBuffer, OsonHeader osonHeader, OsonValueFactory osonValueFactory, OracleJsonExceptions.ExceptionFactory exceptionFactory) {
        this.b = osonBuffer;
        this.header = osonHeader;
        this.exceptionFactory = exceptionFactory;
        this.valueFactory = osonValueFactory;
    }

    public OsonContext(OsonBuffer osonBuffer, OsonHeader osonHeader) {
        this(osonBuffer, osonHeader, OracleOsonValueFactory.INSTANCE, OracleJsonExceptions.ORACLE_FACTORY);
    }

    public OsonContext(OsonBuffer osonBuffer) {
        this(osonBuffer, new OsonHeader(osonBuffer, OracleJsonExceptions.ORACLE_FACTORY));
    }

    public OsonContext(OsonContext osonContext) {
        this(osonContext.b, osonContext.header);
    }

    public OsonBuffer getBuffer() {
        return this.b;
    }

    public OsonHeader getHeader() {
        return this.header;
    }

    public OsonValueFactory getFactory() {
        return this.valueFactory;
    }

    public OracleJsonExceptions.ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }
}

