/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.tree.OracleJsonNumberImpl;
import oracle.sql.json.OracleJsonValue;

public class OsonAbstractObject
extends OsonStructureImpl {
    boolean fidSorted;
    int fidArrayOffset;

    public OsonAbstractObject(OsonContext osonContext) {
        super(osonContext);
    }

    @Override
    public OracleJsonValue.OracleJsonType getOracleJsonType() {
        return OracleJsonValue.OracleJsonType.OBJECT;
    }

    public OsonAbstractObject(OsonContext osonContext, int n2) {
        super(osonContext);
        this.init(n2);
    }

    public OsonAbstractArray getJsonArrayInternal(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return null;
        }
        return this.getArrayInternal(n2);
    }

    public OsonAbstractObject getJsonObjectInternal(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return null;
        }
        return this.getJsonObjectInternal(n2);
    }

    public String getString(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        String string2 = this.getStringInternal(n2);
        if (string2 == null) {
            throw new ClassCastException();
        }
        return string2;
    }

    public String getString(String string, String string2) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return string2;
        }
        String string3 = this.getStringInternal(n2);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public boolean getBoolean(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        Boolean bl = this.getBooleanInternal(n2);
        if (bl == null) {
            throw new ClassCastException();
        }
        return bl;
    }

    public boolean getBoolean(String string, boolean bl) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            return bl;
        }
        Boolean bl2 = this.getBooleanInternal(n2);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    public int getInt(String string, int n2) {
        int n3 = this.getChildOffset(string);
        if (n3 == -1) {
            return n2;
        }
        Object object = this.getValueInternal(n3);
        if (!(object instanceof OracleJsonNumberImpl)) {
            return n2;
        }
        return ((OracleJsonNumberImpl)object).intValue();
    }

    public int getInt(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumberImpl)this.getValueInternal(n2)).intValue();
    }

    public boolean isNull(String string) {
        int n2 = this.getChildOffset(string);
        if (n2 == -1) {
            throw new NullPointerException();
        }
        return this.isNullInternal(n2);
    }

    public boolean containsKey(Object object) {
        return object instanceof String && this.getChildOffset((String)object) != -1;
    }

    public boolean containsValue(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (!object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public Object getInternal(Object object) {
        if (!(object instanceof String)) {
            return null;
        }
        int n2 = this.getChildOffset((String)object);
        if (n2 < 0) {
            return null;
        }
        return this.getValueInternal(n2);
    }

    public Object getInternal(int n2) {
        int n3 = this.getChildOffset(n2);
        if (n3 < 0) {
            return null;
        }
        return this.getValueInternal(n3);
    }

    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new OsonStructureImpl.PositionIter<String>(){

                    @Override
                    public String getValue(int n2) {
                        return OsonAbstractObject.this.getFieldName(n2);
                    }
                };
            }

            @Override
            public int size() {
                return OsonAbstractObject.this.size;
            }
        };
    }

    @Override
    protected void init(int n2) {
        super.init(n2);
        int n3 = this.ctx.b.getUB1(n2);
        this.initChildOffseUb(n3);
        this.fidArrayOffset = n2 + 1;
        int n4 = n3 & 0x18;
        OsonHeader osonHeader = this.ctx.getHeader();
        if (n4 == 0) {
            this.size = this.ctx.b.getUB1(n2 + 1);
            ++this.fidArrayOffset;
            this.childArrayOffset = this.fidArrayOffset + this.size * osonHeader.numFieldIdBytes();
        } else if (n4 == 8) {
            this.size = this.ctx.b.getUB2(n2 + 1);
            this.fidArrayOffset += 2;
            this.childArrayOffset = this.fidArrayOffset + this.size * osonHeader.numFieldIdBytes();
        } else if (n4 == 16) {
            this.size = this.ctx.b.getUB4int(n2 + 1);
            this.fidArrayOffset += 4;
            this.childArrayOffset = this.fidArrayOffset + this.size * osonHeader.numFieldIdBytes();
        } else if (n4 == 24) {
            int n5;
            if (this.childOffsetUb == 4) {
                n5 = this.ctx.b.getUB4int(n2 + 1) + osonHeader.getTreeSegmentOffset();
                this.childArrayOffset = n2 + 1 + 4;
            } else {
                n5 = this.ctx.b.getUB2(n2 + 1) + osonHeader.getTreeSegmentOffset();
                this.childArrayOffset = n2 + 1 + 2;
            }
            int n6 = this.ctx.b.getUB1(n5);
            int n7 = n6 & 0x18;
            this.fidArrayOffset = n5 + 1;
            if (n7 == 0) {
                this.size = this.ctx.b.getUB1(n5 + 1);
                ++this.fidArrayOffset;
            } else if (n7 == 8) {
                this.size = this.ctx.b.getUB2(n5 + 1);
                this.fidArrayOffset += 2;
            } else if (n7 == 16) {
                this.size = this.ctx.b.getUB4int(n5 + 1);
                this.fidArrayOffset += 4;
            } else {
                throw new IllegalStateException();
            }
        }
        this.fidSorted = (n3 & 4) == 0 && osonHeader.fieldsSorted();
    }

    @Override
    protected int getChildOffset(int n2) {
        OsonHeader osonHeader = this.ctx.getHeader();
        if (osonHeader.relativeOffsets()) {
            if (this.childOffsetUb == 2) {
                short s2 = this.ctx.b.getShort(this.childArrayOffset + n2 * 2);
                s2 = (short)(s2 + (this.pos - osonHeader.getTreeSegmentOffset()));
                return (s2 & 0xFFFF) + osonHeader.getTreeSegmentOffset();
            }
            int n3 = this.ctx.b.getInt(this.childArrayOffset + n2 * 4);
            return ((n3 += this.pos - osonHeader.getTreeSegmentOffset()) & 0xFFFFFFFF) + osonHeader.getTreeSegmentOffset();
        }
        if (this.childOffsetUb == 2) {
            return this.ctx.b.getUB2(this.childArrayOffset + n2 * 2) + osonHeader.getTreeSegmentOffset();
        }
        return this.ctx.b.getUB4int(this.childArrayOffset + n2 * 4) + osonHeader.getTreeSegmentOffset();
    }

    protected int getChildOffset(String string) {
        int n2 = this.getChildPosition(string);
        if (n2 == -1) {
            return -1;
        }
        return this.getChildOffset(n2);
    }

    protected int getChildPosition(String string) {
        OsonHeader osonHeader = this.ctx.getHeader();
        int n2 = osonHeader.getFieldId(string);
        if (n2 == -1) {
            return -1;
        }
        this.ctx.b.position(this.pos + 1);
        int n3 = osonHeader.numFieldIdBytes() == 1 ? (this.fidSorted ? this.ctx.b.binarySearchUb1(this.fidArrayOffset, this.size, n2) : this.ctx.b.linearSearchUb1(this.fidArrayOffset, this.size, n2)) : (osonHeader.numFieldIdBytes() == 2 ? (this.fidSorted ? this.ctx.b.binarySearchUb2(this.fidArrayOffset, this.size, n2) : this.ctx.b.linearSearchUb2(this.fidArrayOffset, this.size, n2)) : (this.fidSorted ? this.ctx.b.binarySearchUb4(this.fidArrayOffset, this.size, n2) : this.ctx.b.linearSearchUb4(this.fidArrayOffset, this.size, n2)));
        if (n3 < 0) {
            return -1;
        }
        return n3;
    }

    public String getFieldName(int n2) {
        OsonHeader osonHeader = this.ctx.getHeader();
        int n3 = osonHeader.numFieldIdBytes() == 1 ? this.ctx.b.getUB1(this.fidArrayOffset + n2) : (osonHeader.numFieldIdBytes() == 2 ? this.ctx.b.getUB2(this.fidArrayOffset + n2 * 2) : this.ctx.b.getUB4int(this.fidArrayOffset + n2 * 4));
        return osonHeader.fieldNames[n3 - 1];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size) {
            return false;
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            String string = this.getFieldName(i2);
            Object object2 = this.getValueInternal(this.getChildOffset(i2));
            if (map.containsKey(string) && object2.equals(map.get(string))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        for (Map.Entry entry : new OsonEntrySet()) {
            n2 += entry.hashCode();
        }
        return n2;
    }

    protected class OsonObjectValues<T>
    extends AbstractCollection<T> {
        protected OsonObjectValues() {
        }

        @Override
        public Iterator<T> iterator() {
            return new OsonStructureImpl.PositionIter<T>(){

                @Override
                public T getValue(int n2) {
                    return OsonAbstractObject.this.getValueInternal(OsonAbstractObject.this.getChildOffset(n2++));
                }
            };
        }

        @Override
        public int size() {
            return OsonAbstractObject.this.size;
        }
    }

    protected class OsonEntrySet<T>
    extends AbstractSet<Map.Entry<String, T>> {
        protected OsonEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<String, T>> iterator() {
            return new OsonStructureImpl.PositionIter<Map.Entry<String, T>>(){

                @Override
                public Map.Entry<String, T> getValue(final int n2) {
                    return new Map.Entry<String, T>(){

                        @Override
                        public String getKey() {
                            return OsonAbstractObject.this.getFieldName(n2);
                        }

                        @Override
                        public T getValue() {
                            return OsonAbstractObject.this.getValueInternal(OsonAbstractObject.this.getChildOffset(n2));
                        }

                        @Override
                        public T setValue(T t2) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public int hashCode() {
                            return this.getKey().hashCode() ^ this.getValue().hashCode();
                        }

                        @Override
                        public boolean equals(Object object) {
                            if (object == this) {
                                return true;
                            }
                            if (!(object instanceof Map.Entry)) {
                                return false;
                            }
                            Map.Entry entry = (Map.Entry)object;
                            return this.getKey().equals(entry.getKey()) && this.getValue().equals(entry.getValue());
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return OsonAbstractObject.this.size;
        }
    }
}

