/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.net.Socket;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.Log;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.security.jps.service.keystore.KeyStoreServiceLoadStoreParameter;

public class CustomSSLSocketFactory {
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String PKCS11_WALLET_TYPE = "PKCS11";
    public static final String WINDOWS_MY_WALLET_TYPE = "Windows-MY";
    public static final String JKS_TYPE = "JKS";
    public static final String KSS_TYPE = "KSS";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    private static final String SSO_FILE_EXTENSION = ".sso";
    private static final String P12_FILE_EXTENSION = ".p12";
    private static final String PFX_FILE_EXTENSION = ".pfx";
    private static final String JKS_FILE_EXTENSION = ".jks";
    private static final String KSS_URI_SCHEME = "kss://";
    private static final String ORACLE_PKI_PROVIDER_CLASS = "oracle.security.pki.OraclePKIProvider";
    private static final String KSS_PROVIDER_CLASS = "oracle.security.jps.internal.keystore.provider.FarmKeyStoreProvider";
    public static SSLSocketFactory defSSLFactory;
    public static SSLContext defSSLContext;
    public static String defPropString;
    public static boolean initDefFactory;
    public static boolean initDefSSLContext;

    private CustomSSLSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSLSocketFactory getSSLSocketFactory(Properties properties) throws IOException {
        SSLSocketFactory sSLSocketFactory = null;
        SSLConfig sSLConfig = CustomSSLSocketFactory.readSSLConfig(properties);
        if (sSLConfig.keyStore != null) {
            if (sSLConfig.keyStore.equalsIgnoreCase("NONE")) return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (sSLConfig.trustStore != null && sSLConfig.trustStore.equalsIgnoreCase("NONE")) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        SSLContext sSLContext = CustomSSLSocketFactory.getSSLContext(sSLConfig);
        if (sSLContext != defSSLContext) return sSLContext.getSocketFactory();
        if (initDefFactory) return defSSLFactory;
        Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
        synchronized (CustomSSLSocketFactory.class) {
            if (initDefFactory) return defSSLFactory;
            defSSLFactory = sSLContext.getSocketFactory();
            initDefFactory = true;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return defSSLFactory;
        }
    }

    public static SSLEngine getSSLSocketEngine(String string, int n2, Properties properties) throws IOException {
        SSLConfig sSLConfig = CustomSSLSocketFactory.readSSLConfig(properties);
        if (sSLConfig.keyStore != null && sSLConfig.keyStore.equalsIgnoreCase("NONE") || sSLConfig.trustStore != null && sSLConfig.trustStore.equalsIgnoreCase("NONE")) {
            try {
                SSLEngine sSLEngine = SSLContext.getDefault().createSSLEngine();
                sSLEngine.setUseClientMode(true);
                return sSLEngine;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IOException(noSuchAlgorithmException);
            }
        }
        SSLEngine sSLEngine = CustomSSLSocketFactory.getSSLContext(sSLConfig).createSSLEngine(string, n2);
        sSLEngine.setUseClientMode(true);
        return sSLEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SSLContext getSSLContext(SSLConfig sSLConfig) throws IOException {
        if (!sSLConfig.propConcatenation.equals(defPropString)) return CustomSSLSocketFactory.createSSLContext(sSLConfig);
        if (initDefSSLContext) return defSSLContext;
        Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
        synchronized (CustomSSLSocketFactory.class) {
            if (initDefSSLContext) return defSSLContext;
            defSSLContext = CustomSSLSocketFactory.createSSLContext(sSLConfig);
            initDefSSLContext = true;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return defSSLContext;
        }
    }

    private static SSLContext createSSLContext(SSLConfig sSLConfig) throws NetException {
        try {
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (sSLConfig.keyStore != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(sSLConfig.keyStore, sSLConfig.keyStorePassword, sSLConfig.keyStoreType, sSLConfig.keyManagerFacAlgo);
            }
            if (sSLConfig.certificateAlias != null && sSLConfig.certificateAlias.trim().length() != 0 && keyManagerArray != null) {
                keyManagerArray = CustomSSLSocketFactory.wrapWithAliasKeyManager(keyManagerArray, sSLConfig.certificateAlias);
            }
            if (sSLConfig.trustStore != null) {
                trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(sSLConfig.trustStore, sSLConfig.trustStorePassword, sSLConfig.trustStoreType, sSLConfig.trustManagerFacAlgo, sSLConfig.isCaCertsTrusted);
            }
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, null);
            return sSLContext;
        }
        catch (Exception exception) {
            throw (NetException)new NetException(410).initCause(exception);
        }
    }

    private static X509ExtendedKeyManager[] wrapWithAliasKeyManager(KeyManager[] keyManagerArray, String string) {
        X509ExtendedKeyManager[] x509ExtendedKeyManagerArray = new X509ExtendedKeyManager[keyManagerArray.length];
        for (int i2 = 0; i2 < keyManagerArray.length; ++i2) {
            x509ExtendedKeyManagerArray[i2] = new AliasKeyManager((X509KeyManager)keyManagerArray[i2], string);
        }
        return x509ExtendedKeyManagerArray;
    }

    private static SSLConfig readSSLConfig(Properties properties) throws NetException {
        Object var3_1 = null;
        Object var2_2 = null;
        Object var1_3 = null;
        Object var5_4 = null;
        Object var6_5 = null;
        Object var4_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        String string = null;
        Object var12_12 = null;
        string = (String)properties.get(5);
        SSLConfig sSLConfig = string == null ? CustomSSLSocketFactory.readJavaxNetSSLConfig(properties) : CustomSSLSocketFactory.readWalletSSLConfig(properties);
        sSLConfig.isCaCertsTrusted = Boolean.valueOf((String)properties.get(41));
        return sSLConfig;
    }

    private static SSLConfig readJavaxNetSSLConfig(Properties properties) {
        SSLConfig sSLConfig = new SSLConfig();
        sSLConfig.keyStore = (String)properties.get(8);
        sSLConfig.certificateAlias = (String)properties.get(29);
        if (sSLConfig.keyStore != null) {
            sSLConfig.keyStoreType = (String)properties.get(9);
            if (sSLConfig.keyStoreType == null) {
                sSLConfig.keyStoreType = CustomSSLSocketFactory.resolveKeyStoreType(sSLConfig.keyStore);
            }
            sSLConfig.keyStorePassword = (String)properties.get(10);
            if (sSLConfig.keyStorePassword == null) {
                sSLConfig.keyStorePassword = "";
            }
            sSLConfig.keyManagerFacAlgo = (String)properties.get(14);
            if (sSLConfig.keyManagerFacAlgo == null) {
                sSLConfig.keyManagerFacAlgo = Security.getProperty("ssl.keyManagerFactory.algorithm");
            }
            if (sSLConfig.keyManagerFacAlgo == null) {
                sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            }
        }
        sSLConfig.trustStore = (String)properties.get(11);
        if (sSLConfig.trustStore != null) {
            sSLConfig.trustStoreType = (String)properties.get(12);
            if (sSLConfig.trustStoreType == null) {
                sSLConfig.trustStoreType = CustomSSLSocketFactory.resolveKeyStoreType(sSLConfig.trustStore);
            }
            sSLConfig.trustStorePassword = (String)properties.get(13);
            if (sSLConfig.trustStorePassword == null) {
                sSLConfig.trustStorePassword = "";
            }
            sSLConfig.trustManagerFacAlgo = (String)properties.get(15);
            if (sSLConfig.trustManagerFacAlgo == null) {
                sSLConfig.trustManagerFacAlgo = Security.getProperty("ssl.trustManagerFactory.algorithm");
            }
            if (sSLConfig.trustManagerFacAlgo == null) {
                sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
            }
        }
        sSLConfig.propConcatenation = sSLConfig.keyStore + "#" + sSLConfig.keyStoreType + "#" + sSLConfig.keyStorePassword + "#" + sSLConfig.trustStore + "#" + sSLConfig.trustStoreType + "#" + sSLConfig.trustStorePassword + "#" + sSLConfig.keyManagerFacAlgo + "#" + sSLConfig.trustManagerFacAlgo + "#" + sSLConfig.isCaCertsTrusted;
        return sSLConfig;
    }

    private static SSLConfig readWalletSSLConfig(Properties properties) throws NetException {
        Object object;
        String string;
        SSLConfig sSLConfig = new SSLConfig();
        sSLConfig.certificateAlias = (String)properties.get(29);
        boolean bl = false;
        String string2 = (String)properties.get(5);
        if (string2.startsWith("(")) {
            string = CustomSSLSocketFactory.processWalletLocation(string2);
        } else {
            string = string2.startsWith("file:") ? string2.substring("file:".length()) : string2;
            object = new File(string);
            if (!((File)object).exists()) {
                throw new NetException(407, "Couldn't find file at " + string);
            }
            if (!((File)object).isDirectory()) {
                bl = true;
            }
        }
        object = (String)properties.get(16);
        if (object == null) {
            sSLConfig.keyStore = !bl ? string + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME : string;
            sSLConfig.keyStoreType = SSO_WALLET_TYPE;
            sSLConfig.keyStorePassword = "";
            sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            sSLConfig.trustStore = sSLConfig.keyStore;
            sSLConfig.trustStoreType = SSO_WALLET_TYPE;
            sSLConfig.trustStorePassword = "";
            sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        } else {
            sSLConfig.keyStore = !bl ? string + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME : string;
            sSLConfig.keyStoreType = PKCS12_WALLET_TYPE;
            sSLConfig.keyStorePassword = object;
            sSLConfig.keyManagerFacAlgo = KeyManagerFactory.getDefaultAlgorithm();
            sSLConfig.trustStore = sSLConfig.keyStore;
            sSLConfig.trustStoreType = PKCS12_WALLET_TYPE;
            sSLConfig.trustStorePassword = object;
            sSLConfig.trustManagerFacAlgo = TrustManagerFactory.getDefaultAlgorithm();
        }
        sSLConfig.propConcatenation = string2 + "#" + sSLConfig.keyManagerFacAlgo + "#" + sSLConfig.trustManagerFacAlgo + "#" + sSLConfig.isCaCertsTrusted;
        return sSLConfig;
    }

    public static KeyManager[] getKeyManagerArray(String string, String string2, String string3, String string4) throws IOException {
        try {
            KeyStore keyStore = CustomSSLSocketFactory.loadKeyStore(string, string3, string2);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string4);
            keyManagerFactory.init(keyStore, string2.toCharArray());
            return keyManagerFactory.getKeyManagers();
        }
        catch (Exception exception) {
            throw (NetException)new NetException(408).initCause(exception);
        }
    }

    public static TrustManager[] getTrustManagerArray(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        try {
            KeyStore keyStore = CustomSSLSocketFactory.loadKeyStore(string, string3, string2);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string4);
            trustManagerFactory.init(bl ? CustomSSLSocketFactory.mergeCaCerts(keyStore) : keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            throw (NetException)new NetException(409).initCause(exception);
        }
    }

    private static KeyStore mergeCaCerts(KeyStore keyStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init((KeyStore)null);
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            for (X509Certificate x509Certificate : ((X509TrustManager)trustManager).getAcceptedIssuers()) {
                String string = x509Certificate.getIssuerX500Principal().getName();
                if (keyStore.containsAlias(string)) continue;
                keyStore.setCertificateEntry(string, x509Certificate);
            }
        }
        return keyStore;
    }

    public static String processWalletLocation(String string) throws NetException {
        String string2 = null;
        try {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = new NVFactory().createNVPair(string);
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "METHOD");
            NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "METHOD_DATA");
            NVPair nVPair4 = nVNavigator.findNVPair(nVPair3, "DIRECTORY");
            string2 = nVPair2.getAtom();
            if (string2.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String string3 = nVPair4.getAtom();
                return string3;
            }
            throw new NetException(412, string2);
        }
        catch (Exception exception) {
            throw (NetException)new NetException(407).initCause(exception);
        }
    }

    public static String getDefaultPropertiesString() {
        String string = null;
        String string2 = null;
        Object var2_2 = null;
        String string3 = null;
        String string4 = null;
        string2 = System.getProperty("oracle.net.wallet_location");
        string = string2 != null ? string2 : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (string3 == null) {
            string3 = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (string4 == null) {
            string4 = TrustManagerFactory.getDefaultAlgorithm();
        }
        return string + "#" + string3 + "#" + string4;
    }

    private static KeyStore getKeyStoreInstance(String string) throws KeyStoreException {
        try {
            return KeyStore.getInstance(string);
        }
        catch (KeyStoreException keyStoreException) {
            try {
                Provider provider = CustomSSLSocketFactory.loadKnownProvider(string);
                if (provider == null) {
                    throw keyStoreException;
                }
                return KeyStore.getInstance(string, provider);
            }
            catch (Exception exception) {
                throw keyStoreException;
            }
        }
    }

    private static Provider loadKnownProvider(String string) throws Exception {
        Object object;
        String string2;
        Provider provider = null;
        switch (string.toUpperCase()) {
            case "SSO": {
                string2 = ORACLE_PKI_PROVIDER_CLASS;
                break;
            }
            case "KSS": {
                string2 = KSS_PROVIDER_CLASS;
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null && (object = Class.forName(string2)) != null && Provider.class.isAssignableFrom((Class<?>)object)) {
            provider = AccessController.doPrivileged(() -> CustomSSLSocketFactory.lambda$loadKnownProvider$0((Class)object));
        }
        return provider;
    }

    private static String resolveKeyStoreType(String string) {
        if (string == null || string.length() == 0) {
            return KeyStore.getDefaultType();
        }
        String string2 = string.toLowerCase();
        if (string2.endsWith(SSO_FILE_EXTENSION)) {
            return SSO_WALLET_TYPE;
        }
        if (string2.endsWith(P12_FILE_EXTENSION) || string2.endsWith(PFX_FILE_EXTENSION)) {
            return PKCS12_WALLET_TYPE;
        }
        if (string2.endsWith(JKS_FILE_EXTENSION)) {
            return JKS_TYPE;
        }
        if (string2.startsWith(KSS_URI_SCHEME)) {
            return KSS_TYPE;
        }
        return KeyStore.getDefaultType();
    }

    @Log
    protected static void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, CustomSSLSocketFactory.class, executable, string);
    }

    private static KeyStore loadKeyStore(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        KeyStore keyStore = CustomSSLSocketFactory.getKeyStoreInstance(string2);
        if (KSS_TYPE.equals(string2)) {
            CustomSSLSocketFactory.loadKSSKeyStore(keyStore, string, string3);
        } else {
            CustomSSLSocketFactory.loadFileBasedKeyStore(keyStore, string, string3);
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadFileBasedKeyStore(KeyStore keyStore, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException {
        try (InputStream inputStream = Channels.newInputStream(FileChannel.open(Paths.get(string, new String[0]), StandardOpenOption.READ));){
            char[] cArray = string2.toCharArray();
            try {
                keyStore.load(inputStream, cArray);
                if (cArray == null) return;
            }
            catch (Throwable throwable) {
                if (cArray == null) throw throwable;
                for (int i2 = 0; i2 < cArray.length; ++i2) {
                    cArray[i2] = '\u0000';
                }
                throw throwable;
            }
            for (int i3 = 0; i3 < cArray.length; ++i3) {
                cArray[i3] = '\u0000';
            }
            return;
        }
    }

    private static void loadKSSKeyStore(KeyStore keyStore, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException {
        final class KSSLoader {
            KSSLoader() {
            }

            private final void load(KeyStore keyStore, String string, String string2) throws IOException, NoSuchAlgorithmException, CertificateException {
                KeyStoreServiceLoadStoreParameter keyStoreServiceLoadStoreParameter = new KeyStoreServiceLoadStoreParameter();
                if (string2 != null) {
                    keyStoreServiceLoadStoreParameter.setProtectionParameter((KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(string2.toCharArray()));
                }
                keyStoreServiceLoadStoreParameter.setKssUri(string);
                keyStore.load((KeyStore.LoadStoreParameter)keyStoreServiceLoadStoreParameter);
            }
        }
        new KSSLoader().load(keyStore, string, string2);
    }

    private static /* synthetic */ Provider lambda$loadKnownProvider$0(Class clazz) throws Exception {
        return (Provider)clazz.newInstance();
    }

    static {
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }

    static class AliasKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;

        AliasKeyManager(X509KeyManager x509KeyManager, String string) {
            this.keyManager = x509KeyManager;
            this.alias = string;
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            return this.chooseEngineClientAlias(stringArray, principalArray, null);
        }

        @Override
        public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
            for (String string : stringArray) {
                if (!this.isMatchFound(this.keyManager.getClientAliases(string, principalArray), this.alias)) continue;
                return this.alias;
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            return this.chooseEngineServerAlias(string, principalArray, null);
        }

        @Override
        public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
            String[] stringArray = this.keyManager.getServerAliases(string, principalArray);
            if (this.isMatchFound(stringArray, this.alias)) {
                return this.alias;
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this.keyManager.getCertificateChain(string);
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this.keyManager.getClientAliases(string, principalArray);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this.keyManager.getPrivateKey(string);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this.keyManager.getServerAliases(string, principalArray);
        }

        private boolean isMatchFound(String[] stringArray, String string) {
            if (stringArray == null) {
                return false;
            }
            for (String string2 : stringArray) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class SSLConfig {
        String keyStore;
        String keyStoreType;
        String keyStorePassword;
        String certificateAlias;
        String keyManagerFacAlgo;
        String trustStore;
        String trustStoreType;
        String trustStorePassword;
        String trustManagerFacAlgo;
        String sslContextProtocol;
        boolean isCaCertsTrusted;
        String propConcatenation;

        private SSLConfig() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof SSLConfig)) {
                return false;
            }
            SSLConfig sSLConfig = (SSLConfig)object;
            return Objects.equals(this.keyStore, sSLConfig.keyStore) && Objects.equals(this.keyStoreType, sSLConfig.keyStoreType) && Objects.equals(this.keyStorePassword, sSLConfig.keyStorePassword) && Objects.equals(this.certificateAlias, sSLConfig.certificateAlias) && Objects.equals(this.keyManagerFacAlgo, sSLConfig.keyManagerFacAlgo) && Objects.equals(this.trustStore, sSLConfig.trustStore) && Objects.equals(this.trustStoreType, sSLConfig.trustStoreType) && Objects.equals(this.trustStorePassword, sSLConfig.trustStorePassword) && Objects.equals(this.trustManagerFacAlgo, sSLConfig.trustManagerFacAlgo) && Objects.equals(this.sslContextProtocol, sSLConfig.sslContextProtocol) && Objects.equals(this.isCaCertsTrusted, sSLConfig.isCaCertsTrusted);
        }
    }
}

