/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn = 0;
    private int noColumnsInserted;
    private boolean rowDeleted = false;
    private boolean rowInserted = false;
    private static final byte COLUMN_CHANGED = 17;
    private boolean rowUpdated = false;
    int[][] columnTypeInfo;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleRow(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.noColumn = n2;
            this.column = new Object[n2];
            this.changedColumn = new Object[n2];
            this.columnChangeFlag = new byte[n2];
            this.isOriginalNull = new boolean[n2];
            this.columnTypeInfo = new int[n2][];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.columnChangeFlag[i2] = 0;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleRow(int n2, boolean bl) {
        this(n2);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowInserted = bl;
            this.noColumnsInserted = 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleRow(int n2, Object[] objectArray) {
        this(n2);
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(objectArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            System.arraycopy(objectArray, 0, this.column, 0, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnValue(int n2, Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowInserted) {
                ++this.noColumnsInserted;
            }
            this.column[n2 - 1] = object;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void markOriginalNull(int n2, boolean bl) throws SQLException {
        this.isOriginalNull[n2 - 1] = bl;
    }

    boolean isOriginalNull(int n2) throws SQLException {
        return this.isOriginalNull[n2 - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n2, Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.updateObject(n2, object, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void updateObject(int n2, Object object, int[] nArray) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.columnChangeFlag[n2 - 1] = 17;
        this.changedColumn[n2 - 1] = object;
        this.columnTypeInfo[n2 - 1] = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowUpdates() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.noColumnsInserted = 0;
            for (int i2 = 0; i2 < this.noColumn; ++i2) {
                this.columnChangeFlag[i2] = 0;
            }
            this.changedColumn = null;
            this.changedColumn = new Object[this.noColumn];
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getColumn(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.column[n2 - 1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getModifiedColumn(int n2) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.changedColumn[n2 - 1];
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColumnChanged(int n2) {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl = this.columnChangeFlag[n2 - 1] == 17;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowUpdated() {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.rowInserted || this.rowDeleted) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            for (n2 = 0; n2 < this.noColumn; n2 += 1) {
                if (this.columnChangeFlag[n2] != 17) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = 0;
            return n2 != 0;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowUpdated(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowUpdated = bl;
            if (!bl) {
                this.cancelRowUpdates();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowInserted() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowInserted);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.rowInserted;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRowDeletion() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowDeleted = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowDeleted(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowDeleted = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowDeleted() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.rowDeleted);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.rowDeleted;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getOriginalRow() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.column);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object[] objectArray = this.column;
            return objectArray;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowFullyPopulated() {
        try {
            boolean bl;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.rowInserted) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = bl = this.noColumnsInserted == this.noColumn;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInsertedFlag(boolean bl) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.rowInserted = bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void makeUpdatesOriginal() {
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            if (this.columnChangeFlag[i2] != 17) continue;
            this.column[i2] = this.changedColumn[i2];
            this.changedColumn[i2] = null;
            this.columnChangeFlag[i2] = 0;
        }
        this.rowUpdated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.columnChangeFlag = null;
            this.columnChangeFlag = new byte[this.noColumn];
            System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
            this.changedColumn = null;
            this.changedColumn = new Object[this.noColumn];
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection toCollection() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Vector<Object> vector = new Vector<Object>(this.noColumn);
            for (int i2 = 1; i2 <= this.noColumn; ++i2) {
                vector.add(this.isColumnChanged(i2) ? this.getModifiedColumn(i2) : this.getColumn(i2));
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + vector);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Vector<Object> vector2 = vector;
            return vector2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleRow createCopy() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleRow oracleRow = new OracleRow(this.noColumn);
            for (int i2 = 0; i2 < this.noColumn; ++i2) {
                oracleRow.column[i2] = this.getCopy(this.column[i2]);
                oracleRow.changedColumn[i2] = this.getCopy(this.changedColumn[i2]);
            }
            System.arraycopy(this.columnChangeFlag, 0, oracleRow.columnChangeFlag, 0, this.noColumn);
            oracleRow.noColumnsInserted = this.noColumnsInserted;
            oracleRow.rowDeleted = this.rowDeleted;
            oracleRow.rowInserted = this.rowInserted;
            oracleRow.rowUpdated = this.rowUpdated;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleRow);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OracleRow oracleRow2 = oracleRow;
            return oracleRow2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCopy(Object object) throws SQLException {
        try {
            Object object2;
            block47: {
                block45: {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.enter()) {
                                OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    object2 = null;
                    try {
                        if (object != null) break block45;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        Object var3_5 = null;
                        return var3_5;
                    }
                    catch (Exception exception) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleRow.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 349 + object.getClass().getName() + exception.getMessage());
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 349, object.getClass().getName() + exception.getMessage());
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                if (object instanceof String) {
                    object2 = (String)object;
                    break block47;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).toString());
                    break block47;
                }
                if (object instanceof Date) {
                    object2 = new Date(((Date)object).getTime());
                    break block47;
                }
                if (object instanceof Timestamp) {
                    object2 = new Timestamp(((Timestamp)object).getTime());
                    break block47;
                }
                if (object instanceof InputStream) {
                    object2 = new DataInputStream((InputStream)object);
                    break block47;
                }
                if (object instanceof OutputStream) {
                    object2 = new DataOutputStream((OutputStream)object);
                    break block47;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleRow.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 348 + object.getClass().getName());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 348, object.getClass().getName());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = object2;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() throws CloneNotSupportedException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                OracleRow oracleRow = this.createCopy();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleRow);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleRow oracleRow2 = oracleRow;
                return oracleRow2;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleRow.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing CloneNotSupportedException: " + "Error while cloning\n" + sQLException.getMessage());
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new CloneNotSupportedException("Error while cloning\n" + sQLException.getMessage());
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleRow.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleRow"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

