/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;

public class OracleConnectionPoolDataSource
extends OracleDataSource
implements ConnectionPoolDataSource {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnectionPoolDataSource() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.dataSourceName = "OracleConnectionPoolDataSource";
            this.isOracleDataSource = false;
            this.connCachingEnabled = false;
            this.fastConnFailover = false;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = null;
            String string2 = null;
            Object object = this;
            synchronized (object) {
                string = this.user;
                string2 = this.password;
            }
            object = this.getPooledConnection(string, string2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PooledConnection getPooledConnection(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.getPhysicalConnection(string, string2);
            OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
            if (string2 == null) {
                string2 = this.password;
            }
            oraclePooledConnection.setUserName(!string.startsWith("\"") ? string.toLowerCase() : string, string2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oraclePooledConnection);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OraclePooledConnection oraclePooledConnection2 = oraclePooledConnection;
            return oraclePooledConnection2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConnectionPoolDataSource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    PooledConnection getPooledConnection(Properties properties) throws SQLException {
        String string;
        Connection connection = this.getPhysicalConnection(properties);
        OraclePooledConnection oraclePooledConnection = new OraclePooledConnection(connection);
        String string2 = properties.getProperty("user");
        if (string2 == null) {
            string2 = ((OracleConnection)connection).getUserName();
        }
        if ((string = properties.getProperty("password")) == null) {
            string = this.password;
        }
        oraclePooledConnection.setUserName(!string2.startsWith("\"") ? string2.toLowerCase() : string2, string);
        return oraclePooledConnection;
    }

    protected Connection getPhysicalConnection() throws SQLException {
        return super.getConnection(this.user, this.password);
    }

    protected Connection getPhysicalConnection(String string, String string2, String string3) throws SQLException {
        this.url = string;
        return super.getConnection(string2, string3);
    }

    protected Connection getPhysicalConnection(String string, String string2) throws SQLException {
        return super.getConnection(string, string2);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionPoolDataSource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

