/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.REF;
import oracle.sql.StructDescriptor;

public class OracleTypeREF
extends OracleNamedType
implements Serializable {
    static final long serialVersionUID = 3186448715463064573L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeREF() {
    }

    public OracleTypeREF(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, oracleConnection);
    }

    public OracleTypeREF(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) {
        super(oracleTypeADT, n2, oracleConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        REF rEF = null;
        if (object != null) {
            if (object instanceof REF) {
                rEF = (REF)object;
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeREF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return rEF;
    }

    @Override
    public int getTypeCode() {
        return 2006;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1 || n2 == 2) {
            StructDescriptor structDescriptor = this.createStructDescriptor();
            return new REF(structDescriptor, (Connection)this.connection, byArray);
        }
        if (n2 == 3) {
            return byArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeREF.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + byArray);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        if (this.descriptor == null) {
            if (this.sqlName == null && this.getFullName(false) == null) {
                OracleTypeADT oracleTypeADT = new OracleTypeADT(this.getParent(), this.getOrder(), (Connection)this.connection);
                this.descriptor = new StructDescriptor(oracleTypeADT, (Connection)this.connection);
            } else {
                this.descriptor = StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
            }
        }
        return (StructDescriptor)this.descriptor;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeREF"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

