/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class TimeBinder
extends DateCommonBinder {
    Binder theTimeCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimeCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    static void init(Binder binder) {
        binder.type = (short)12;
        binder.bytelen = 7;
    }

    TimeBinder() {
        TimeBinder.init(this);
    }

    @Override
    Binder copyingBinder() {
        return this.theTimeCopyingBinder;
    }

    @Override
    void bind(OraclePreparedStatement oraclePreparedStatement, int n2, int n3, int n4, byte[] byArray, char[] cArray, short[] sArray, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) throws SQLException {
        Time[] timeArray = oraclePreparedStatement.parameterTime[n4];
        Time time = timeArray[n2];
        if (bl) {
            timeArray[n2] = null;
        }
        if (time == null) {
            sArray[n10] = -1;
        } else {
            sArray[n10] = 0;
            TimeBinder.setOracleHMS(TimeBinder.setOracleCYMD(time.getTime(), byArray, n7, oraclePreparedStatement), byArray, n7);
            byArray[0 + n7] = 119;
            byArray[2 + n7] = 1;
            byArray[3 + n7] = 1;
            byArray[1 + n7] = oraclePreparedStatement.connection.use1900AsYearForTime ? 100 : -86;
            sArray[n9] = (short)n5;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimeBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

