/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.internal.OracleStatement;

class T4CPreparedStatement
extends OraclePreparedStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CPreparedStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        super(physicalConnection, string, physicalConnection.defaultExecuteBatch, physicalConnection.defaultRowPrefetch, n2, n3);
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
        this.t4Connection = (T4CConnection)physicalConnection;
        this.theRowidBinder = theStaticT4CRowidBinder;
        this.theRowidNullBinder = theStaticT4CRowidNullBinder;
        this.theURowidBinder = theStaticT4CURowidBinder;
        this.theURowidNullBinder = theStaticT4CURowidNullBinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws SQLException, IOException {
        int n2;
        int n3;
        int n4;
        if (bl || bl4 || !bl2) {
            this.oacdefSent = null;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 439 + "sqlKind = " + (Object)((Object)this.sqlKind));
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 439, "sqlKind = " + (Object)((Object)this.sqlKind));
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl3) {
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        int n5 = this.numberOfDefinePositions;
        if (this.sqlKind.isDML()) {
            n5 = 0;
        }
        if (this.accessors != null) {
            for (n4 = 0; n4 < this.accessors.length; ++n4) {
                if (this.accessors[n4] == null) continue;
                this.accessors[n4].lastRowProcessed = 0;
            }
        }
        if (this.outBindAccessors != null) {
            for (n4 = 0; n4 < this.outBindAccessors.length; ++n4) {
                if (this.outBindAccessors[n4] == null) continue;
                this.outBindAccessors[n4].lastRowProcessed = 0;
            }
        }
        if (this.returnParamAccessors != null) {
            for (n4 = 0; n4 < this.returnParamAccessors.length; ++n4) {
                if (this.returnParamAccessors[n4] == null) continue;
                this.returnParamAccessors[n4].lastRowProcessed = 0;
            }
        }
        if (this.bindIndicators != null) {
            n4 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int n6 = 0;
            if (this.ibtBindChars != null) {
                n6 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int n7 = this.bindIndicatorSubRange + 5 + 10 * i2;
                n3 = this.bindIndicators[n7 + 2] & 0xFFFF;
                if (n3 == 0) continue;
                n2 = this.bindIndicators[n7 + 9] & 0xFFFF;
                n6 = n2 == 2 ? Math.max(n3 * this.connection.conversion.maxNCharSize, n6) : Math.max(n3 * this.connection.conversion.cMaxCharSize, n6);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n6];
            } else if (this.tmpBindsByteArray.length < n6) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n6];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
        int[] nArray = this.definedColumnType;
        int[] nArray2 = this.definedColumnSize;
        int[] nArray3 = this.definedColumnFormOfUse;
        if (bl5 && bl4 && this.sqlObject.includeRowid) {
            nArray = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, nArray, 1, this.definedColumnType.length);
            nArray[0] = -8;
            nArray2 = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, nArray2, 1, this.definedColumnSize.length);
            nArray3 = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, nArray3, 1, this.definedColumnFormOfUse.length);
        }
        this.allocateTmpByteArray();
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        this.t4Connection.sendPiggyBackedMessages();
        try {
            t4C8Oall.doOALL(bl, bl2, bl3, bl4, bl5, this.sqlKind, this.cursorId, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals), this.rowPrefetch, this.outBindAccessors, this.numberOfBindPositions, this.accessors, n5, this.bindBytes, this.bindChars, this.bindIndicators, this.bindIndicatorSubRange, this.connection.conversion, this.tmpBindsByteArray, this.parameterStream, this.parameterDatum, this.parameterOtype, this, this.ibtBindBytes, this.ibtBindChars, this.ibtBindIndicators, this.oacdefSent, nArray, nArray2, nArray3, this.registration);
            n3 = t4C8Oall.getCursorId();
            if (n3 != 0) {
                this.cursorId = n3;
            }
            this.oacdefSent = t4C8Oall.oacdefBindsSent;
        }
        catch (SQLException sQLException) {
            n2 = t4C8Oall.getCursorId();
            if (n2 != 0) {
                this.cursorId = n2;
            }
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void allocateTmpByteArray() {
        if (this.tmpByteArray == null) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        } else if (this.sizeTmpByteArray > this.tmpByteArray.length) {
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.t4Connection.all8.bindChars = null;
        this.t4Connection.all8.bindBytes = null;
        this.t4Connection.all8.tmpBindsByteArray = null;
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n3 == -15 || n3 == -9 || n3 == -16) {
            s2 = (short)2;
        }
        if (n2 < 1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (bl) {
            if (n3 == 1 || n3 == 12 || n3 == -15 || n3 == -9) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 108);
            }
        } else if (n4 < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 28);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 28);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        this.definedColumnSize[n5] = n4;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        if (this.accessors != null && n5 < this.accessors.length && this.accessors[n5] != null) {
            this.accessors[n5].definedColumnSize = n4;
            if (!(this.accessors[n5].internalType != 96 && this.accessors[n5].internalType != 1 || n3 != 1 && n3 != 12 || n4 > this.accessors[n5].oacmxl)) {
                this.needToPrepareDefineBuffer = true;
                this.columnsDefinedByUser = true;
                this.accessors[n5].initForDataAccess(n3, n4, null);
                this.accessors[n5].calculateSizeTmpByteArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefines() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.clearDefines();
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            this.t4Connection.all8.definesAccessors = null;
        }
    }

    @Override
    void saveDefineBuffersIfRequired(char[] cArray, byte[] byArray, short[] sArray, boolean bl) throws SQLException {
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = this.rowPrefetchInLastFetch < this.rowPrefetch;
        if (bl) {
            int n3;
            sArray = new short[this.defineIndicators.length];
            n2 = this.accessors[0].lengthIndexLastRow;
            int n4 = this.accessors[0].indicatorIndexLastRow;
            int n5 = n3 = bl2 ? this.accessors.length : 1;
            while (bl2 ? n3 >= 1 : n3 <= this.accessors.length) {
                int n6 = n2 + this.rowPrefetchInLastFetch * n3 - 1;
                int n7 = n4 + this.rowPrefetchInLastFetch * n3 - 1;
                sArray[n7] = this.defineIndicators[n7];
                sArray[n6] = this.defineIndicators[n6];
                n3 += bl2 ? -1 : 1;
            }
        }
        int n8 = n2 = bl2 ? this.accessors.length - 1 : 0;
        while (bl2 ? n2 > -1 : n2 < this.accessors.length) {
            this.accessors[n2].saveDataFromOldDefineBuffers(byArray, cArray, sArray, this.rowPrefetchInLastFetch != -1 ? this.rowPrefetchInLastFetch : this.rowPrefetch, this.rowPrefetch);
            n2 += bl2 ? -1 : 1;
        }
        super.saveDefineBuffersIfRequired(cArray, byArray, sArray, bl);
    }

    @Override
    void doSetSnapshotSCN(long l2) throws SQLException {
        this.inScn = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    Accessor allocateAccessor(int var1_1, int var2_2, int var3_3, int var4_4, short var5_5, String var6_6, boolean var7_7) throws SQLException {
        var8_8 /* !! */  = null;
        switch (var1_1) {
            case 96: {
                var8_8 /* !! */  = new T4CCharAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!var7_7) {
                    var8_8 /* !! */  = new T4CLongAccessor(this, var3_3, var4_4, var5_5, var2_2, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                var8_8 /* !! */  = new T4CVarcharAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 2: {
                var8_8 /* !! */  = new T4CNumberAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 6: {
                var8_8 /* !! */  = new T4CVarnumAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!var7_7) {
                    var8_8 /* !! */  = new T4CLongRawAccessor(this, var3_3, var4_4, var5_5, var2_2, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (!var7_7 || var6_6 == null) ** GOTO lbl36
                if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 12 + "sqlType=" + var2_2);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_10 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 12, "sqlType=" + var2_2);
                var9_10.fillInStackTrace();
                throw var9_10;
lbl36:
                // 1 sources

                if (var7_7) {
                    var8_8 /* !! */  = new T4COutRawAccessor(this, var4_4, var5_5, var2_2, this.t4Connection.mare);
                    break;
                }
                var8_8 /* !! */  = new T4CRawAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 100: {
                var8_8 /* !! */  = new T4CBinaryFloatAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 101: {
                var8_8 /* !! */  = new T4CBinaryDoubleAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 104: {
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
                    var8_8 /* !! */  = new T4CVarcharAccessor(this, 18, var5_5, var2_2, var7_7, this.t4Connection.mare);
                    var8_8 /* !! */ .definedColumnType = -8;
                    break;
                }
                var8_8 /* !! */  = new T4CRowidAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 102: {
                var8_8 /* !! */  = new T4CResultSetAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 12: {
                var8_8 /* !! */  = new T4CDateAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 113: {
                var8_8 /* !! */  = new T4CBlobAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 112: {
                var8_8 /* !! */  = new T4CClobAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 114: {
                var8_8 /* !! */  = new T4CBfileAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 109: {
                var8_8 /* !! */  = new T4CNamedTypeAccessor(this, var6_6, var5_5, var2_2, var7_7, this.t4Connection.mare);
                var8_8 /* !! */ .initMetadata();
                break;
            }
            case 111: {
                var8_8 /* !! */  = new T4CRefTypeAccessor(this, var6_6, var5_5, var2_2, var7_7, this.t4Connection.mare);
                var8_8 /* !! */ .initMetadata();
                break;
            }
            case 180: {
                var8_8 /* !! */  = new T4CTimestampAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 181: {
                var8_8 /* !! */  = new T4CTimestamptzAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 231: {
                var8_8 /* !! */  = new T4CTimestampltzAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 182: {
                var8_8 /* !! */  = new T4CIntervalymAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 183: {
                var8_8 /* !! */  = new T4CIntervaldsAccessor(this, var4_4, var5_5, var2_2, var7_7, this.t4Connection.mare);
                break;
            }
            case 995: {
                if (T4CPreparedStatement.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 89);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var9_11 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 89);
                var9_11.fillInStackTrace();
                throw var9_11;
            }
        }
        return var8_8 /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
        try {
            this.t4Connection.needLine();
            this.t4Connection.sendPiggyBackedMessages();
            this.t4Connection.describe.doODNY(this, 0, this.accessors, this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals));
            this.accessors = this.t4Connection.describe.getAccessors();
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.describedWithNames = true;
        this.described = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
        try {
            if (this.t4Connection.useFetchSizeWithLongColumn) {
                this.doOall8(true, true, true, true, false);
            } else {
                this.doOall8(true, true, false, true, this.definedColumnType != null);
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        finally {
            this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        this.needToParse = false;
        if (this.connection.calculateChecksum) {
            if (this.validRows > 0) {
                this.calculateCheckSum();
            } else if (this.rowsProcessed > 0) {
                long l2;
                this.checkSum = l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
            }
        }
        if (this.definedColumnType == null) {
            this.implicitDefineForLobPrefetchDone = false;
        }
        this.aFetchWasDoneDuringDescribe = false;
        if (this.t4Connection.all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            this.accessors[i2].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                boolean bl2 = false;
                if (this.columnsDefinedByUser) {
                    this.needToPrepareDefineBuffer = false;
                } else if (this.t4Connection.useLobPrefetch && this.accessors != null && this.defaultLobPrefetchSize != -1 && !this.implicitDefineForLobPrefetchDone && !this.aFetchWasDoneDuringDescribe && this.definedColumnType == null) {
                    boolean bl3 = false;
                    int[] nArray = new int[this.accessors.length];
                    int[] nArray2 = new int[this.accessors.length];
                    for (int i2 = 0; i2 < this.accessors.length; ++i2) {
                        nArray[i2] = this.getJDBCType(this.accessors[i2].internalType);
                        if (this.accessors[i2].internalType != 113 && this.accessors[i2].internalType != 112 && this.accessors[i2].internalType != 114) continue;
                        bl3 = true;
                        this.accessors[i2].lobPrefetchSizeForThisColumn = this.defaultLobPrefetchSize;
                        nArray2[i2] = this.defaultLobPrefetchSize;
                    }
                    if (bl3) {
                        this.definedColumnType = nArray;
                        this.definedColumnSize = nArray2;
                        bl2 = true;
                    }
                }
                this.doOall8(this.needToParse, !bl, true, false, bl2);
                this.needToParse = false;
                if (bl2) {
                    this.implicitDefineForLobPrefetchDone = true;
                }
            }
            finally {
                this.validRows = this.t4Connection.all8.getNumRows();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            this.calculateCheckSum();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void fetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        try {
            this.doOall8(false, false, true, false, false);
            this.validRows = this.t4Connection.all8.getNumRows();
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.calculateCheckSum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.connection.useFetchSizeWithLongColumn) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2, this);
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.do_close");
        if (this.cursorId != 0) {
            this.t4Connection.closeCursor(this.cursorId);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void closeQuery() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CPreparedStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    @Override
    Binder getRowidNullBinder(int n2) {
        if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            this.currentRowCharLens[n2] = 1;
            return this.theVarcharNullBinder;
        }
        return this.theRowidNullBinder;
    }

    @Override
    void doLocalInitialization() {
        super.doLocalInitialization();
        this.t4Connection.all8.bindChars = this.bindChars;
        this.t4Connection.all8.bindBytes = this.bindBytes;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CPreparedStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

