/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;

class SensitiveScrollableResultSet
extends ScrollableResultSet {
    int beginLastFetchedIndex;
    int endLastFetchedIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    SensitiveScrollableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n2, int n3) throws SQLException {
        super(scrollRsetStatement, oracleResultSetImpl, n2, n3);
        int n4 = oracleResultSetImpl.getValidRows();
        if (n4 > 0) {
            this.beginLastFetchedIndex = 1;
            this.endLastFetchedIndex = n4;
        } else {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.next()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.first()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.last()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.absolute(n2)) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.relative(n2)) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (super.previous()) {
                    this.handle_refetch();
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (!this.isValidRow(this.currentRow)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 11);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 11);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n2 = this.getFetchDirection();
                int n3 = 0;
                try {
                    n3 = this.refreshRowsInCache(this.currentRow, this.getFetchSize(), n2);
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            SensitiveScrollableResultSet.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + sQLException + 90 + "Unsupported syntax for refreshRow()");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), sQLException, 90, "Unsupported syntax for refreshRow()");
                    sQLException2.fillInStackTrace();
                    throw sQLException2;
                }
                if (n3 != 0) {
                    this.beginLastFetchedIndex = this.currentRow;
                    this.endLastFetchedIndex = this.currentRow + n3 - 1;
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        SensitiveScrollableResultSet.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int removeRowInCache(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n3 = super.removeRowInCache(n2);
            if (n3 != 0) {
                if (n2 >= this.beginLastFetchedIndex && n2 <= this.endLastFetchedIndex && this.beginLastFetchedIndex != this.endLastFetchedIndex) {
                    --this.endLastFetchedIndex;
                } else {
                    this.endLastFetchedIndex = 0;
                    this.beginLastFetchedIndex = 0;
                }
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handle_refetch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.currentRow >= this.beginLastFetchedIndex && this.currentRow <= this.endLastFetchedIndex || this.currentRow >= this.endLastFetchedIndex && this.currentRow <= this.beginLastFetchedIndex) {
                return false;
            }
            this.refreshRow();
            return true;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.SensitiveScrollableResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

