/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;

class OracleConversionReader
extends Reader {
    static final int CHUNK_SIZE = 4096;
    DBConversion dbConversion;
    int conversion;
    InputStream istream;
    char[] buf;
    byte[] byteBuf;
    int pos;
    int count;
    int numUnconvertedBytes;
    boolean isClosed;
    boolean endOfStream;
    private short csform;
    int[] nbytes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConversionReader(DBConversion dBConversion, InputStream inputStream, int n2) throws SQLException {
        if (dBConversion == null || inputStream == null || n2 != 8 && n2 != 9) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.dbConversion = dBConversion;
        this.conversion = n2;
        this.istream = inputStream;
        this.count = 0;
        this.pos = 0;
        this.numUnconvertedBytes = 0;
        this.isClosed = false;
        this.nbytes = new int[1];
        if (n2 == 8) {
            this.byteBuf = new byte[2048];
            this.buf = new char[4096];
        } else if (n2 == 9) {
            this.byteBuf = new byte[4096];
            this.buf = new char[4096];
        }
    }

    public void setFormOfUse(short s2) {
        this.csform = s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cArray) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (!this.needChars()) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + -1);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n4 = -1;
                return n4;
            }
            int n5 = n2;
            int n6 = n5 + Math.min(n3, cArray.length - n2);
            n5 += this.writeChars(cArray, n5, n6 - n5);
            while (n5 < n6 && this.needChars()) {
                n5 += this.writeChars(cArray, n5, n6 - n5);
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (n5 - n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n7 = n5 - n2;
            return n7;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean needChars() throws IOException {
        block25: {
            block23: {
                this.ensureOpen();
                if (this.pos < this.count) break block25;
                if (this.endOfStream) break block23;
                try {
                    int n2 = this.istream.read(this.byteBuf, this.numUnconvertedBytes, this.byteBuf.length - this.numUnconvertedBytes);
                    if (n2 == -1) {
                        this.endOfStream = true;
                        this.istream.close();
                        if (this.numUnconvertedBytes != 0) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 55);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 55);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                    }
                    if ((n2 += this.numUnconvertedBytes) <= 0) break block23;
                    switch (this.conversion) {
                        case 8: {
                            this.count = DBConversion.RAWBytesToHexChars(this.byteBuf, n2, this.buf);
                            break;
                        }
                        case 9: {
                            this.nbytes[0] = n2;
                            this.count = this.csform == 2 ? this.dbConversion.NCHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length) : this.dbConversion.CHARBytesToJavaChars(this.byteBuf, 0, this.buf, 0, this.nbytes, this.buf.length);
                            this.numUnconvertedBytes = this.nbytes[0];
                            for (int i2 = 0; i2 < this.numUnconvertedBytes; ++i2) {
                                this.byteBuf[i2] = this.byteBuf[n2 - this.numUnconvertedBytes + i2];
                            }
                            break;
                        }
                        default: {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                    }
                    if (this.count > 0) {
                        this.pos = 0;
                        return true;
                    }
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
            }
            return false;
        }
        return true;
    }

    protected int writeChars(char[] cArray, int n2, int n3) {
        int n4 = Math.min(n3, this.count - this.pos);
        System.arraycopy(this.buf, this.pos, cArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.ensureOpen();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.pos < this.count));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.pos < this.count;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.isClosed) {
                this.isClosed = true;
                this.istream.close();
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleConversionReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block10: {
            try {
                if (!this.isClosed) break block10;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleConversionReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleConversionReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

