/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource;
    private String xaDataSourceName;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory() throws ResourceException {
        block13: {
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory(XADataSource xADataSource) throws ResourceException {
        this.xaDataSource = null;
        this.xaDataSourceName = null;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xADataSource));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xaDataSource = xADataSource;
            this.xaDataSourceName = "XADataSource";
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXADataSourceName(String string) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.xaDataSourceName = string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXADataSourceName() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xaDataSourceName);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = this.xaDataSourceName;
            return string;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connectionManager));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            DataSource dataSource = (DataSource)((Object)this.xaDataSource);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dataSource);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DataSource dataSource2 = dataSource;
            return dataSource2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = this.createConnectionFactory(null);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(connectionRequestInfo));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                XAConnection xAConnection = null;
                PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
                xAConnection = passwordCredential == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(passwordCredential.getUserName(), new String(passwordCredential.getPassword()));
                OracleManagedConnection oracleManagedConnection = new OracleManagedConnection(xAConnection);
                oracleManagedConnection.setPasswordCredential(passwordCredential);
                oracleManagedConnection.setLogWriter(this.getLogWriter());
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleManagedConnection);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleManagedConnection oracleManagedConnection2 = oracleManagedConnection;
                return oracleManagedConnection2;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedConnection matchManagedConnections(Set set, Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        try {
            Object e22;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(set) + ", " + OracleLog.argument(subject) + ", " + OracleLog.argument(connectionRequestInfo));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PasswordCredential passwordCredential = this.getPasswordCredential(subject, connectionRequestInfo);
            for (Object e22 : set) {
                OracleManagedConnection oracleManagedConnection;
                if (!(e22 instanceof OracleManagedConnection) || !(oracleManagedConnection = (OracleManagedConnection)e22).getPasswordCredential().equals((Object)passwordCredential)) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleManagedConnection);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                OracleManagedConnection oracleManagedConnection2 = oracleManagedConnection;
                return oracleManagedConnection2;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            e22 = null;
            return e22;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(printWriter));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                this.xaDataSource.setLogWriter(printWriter);
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter getLogWriter() throws ResourceException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            try {
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                PrintWriter printWriter = this.xaDataSource.getLogWriter();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + printWriter);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                PrintWriter printWriter2 = printWriter;
                return printWriter2;
            }
            catch (SQLException sQLException) {
                EISSystemException eISSystemException = new EISSystemException("SQLException: " + sQLException.getMessage());
                eISSystemException.setLinkedException((Exception)sQLException);
                throw eISSystemException;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupXADataSource() throws ResourceException {
        try {
            Object object;
            InitialContext initialContext = null;
            try {
                object = System.getProperties();
                initialContext = new InitialContext((Hashtable<?, ?>)object);
            }
            catch (java.lang.SecurityException securityException) {
                // empty catch block
            }
            if (initialContext == null) {
                initialContext = new InitialContext();
            }
            if ((object = (XADataSource)initialContext.lookup(this.xaDataSourceName)) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleManagedConnectionFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing ResourceAdapterInternalException: " + "Invalid XADataSource object");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new ResourceAdapterInternalException("Invalid XADataSource object");
            }
            this.xaDataSource = object;
        }
        catch (NamingException namingException) {
            ResourceException resourceException = new ResourceException("NamingException: " + namingException.getMessage());
            resourceException.setLinkedException((Exception)namingException);
            throw resourceException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (subject != null) {
            Set<PasswordCredential> set = subject.getPrivateCredentials(PasswordCredential.class);
            for (PasswordCredential passwordCredential : set) {
                if (!passwordCredential.getManagedConnectionFactory().equals(this)) continue;
                return passwordCredential;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleManagedConnectionFactory.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SecurityException: " + "Can not find user/password information" + RAERR_MCF_GET_PCRED);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
        }
        if (connectionRequestInfo == null) {
            return null;
        }
        OracleConnectionRequestInfo oracleConnectionRequestInfo = (OracleConnectionRequestInfo)connectionRequestInfo;
        PasswordCredential passwordCredential = new PasswordCredential(oracleConnectionRequestInfo.getUser(), oracleConnectionRequestInfo.getPassword().toCharArray());
        passwordCredential.setManagedConnectionFactory((ManagedConnectionFactory)this);
        return passwordCredential;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

