/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static final long serialVersionUID = -3298750557928937840L;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int hexDigit2Nibble(char c2) throws SQLException {
        int n2 = Character.digit(c2, 16);
        if (n2 == -1) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.SEVERE, "         Throwing SQLException: 59Invalid hex digit: " + c2);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(null, 59, "Invalid hex digit: " + c2);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return n2;
    }

    public static byte[] hexString2Bytes(String string) throws SQLException {
        byte[] byArray;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        int n3 = 0;
        int n4 = 0;
        if (n2 == 0) {
            return new byte[0];
        }
        if (n2 % 2 > 0) {
            byArray = new byte[(n2 + 1) / 2];
            byArray[n3++] = (byte)RAW.hexDigit2Nibble(cArray[n4++]);
        } else {
            byArray = new byte[n2 / 2];
        }
        while (n3 < byArray.length) {
            byArray[n3] = (byte)(RAW.hexDigit2Nibble(cArray[n4++]) << 4 | RAW.hexDigit2Nibble(cArray[n4++]));
            ++n3;
        }
        return byArray;
    }

    public static RAW newRAW(Object object) throws SQLException {
        RAW rAW = new RAW(object);
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RAW oldRAW(Object object) throws SQLException {
        RAW rAW;
        if (object instanceof String) {
            String string = (String)object;
            byte[] byArray = null;
            try {
                byArray = string.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(OracleLog.INTERNAL_ERROR, "        Internal Error: 109ISO8859_1 character encoding not found");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(null, 109, "ISO8859_1 character encoding not found");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            rAW = new RAW(byArray);
        } else {
            rAW = new RAW(object);
        }
        return rAW;
    }

    public RAW() {
    }

    public RAW(byte[] byArray) {
        super(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW(Object object) throws SQLException {
        block21: {
            this();
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (object instanceof byte[]) {
                    this.setShareBytes((byte[])object);
                    break block21;
                }
                if (object instanceof String) {
                    this.setShareBytes(RAW.hexString2Bytes((String)object));
                    break block21;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJdbc() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray = this.getBytes();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConvertibleTo(Class clazz) {
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clazz));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if ((string = clazz.getName()).compareTo("java.lang.String") == 0 || string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl = true;
                return bl;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValue() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string = RepConversion.bArray2String(this.getBytes());
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader characterStreamValue() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)this.getLength();
            char[] cArray = new char[n2 * 2];
            byte[] byArray = this.shareBytes();
            DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + charArrayReader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CharArrayReader charArrayReader2 = charArrayReader;
            return charArrayReader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream asciiStreamValue() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = (int)this.getLength();
            char[] cArray = new char[n2 * 2];
            byte[] byArray = this.shareBytes();
            DBConversion.RAWBytesToHexChars(byArray, n2, cArray);
            byte[] byArray2 = new byte[n2 * 2];
            DBConversion.javaCharsToAsciiBytes(cArray, n2 * 2, byArray2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byteArrayInputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            return byteArrayInputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream binaryStreamValue() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream = this.getStream();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    RAW.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    public Object makeJdbcArray(int n2) {
        return new byte[n2][];
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.RAW"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

