/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleSQLOutput
implements SQLOutput {
    private StructDescriptor descriptor;
    private Object[] attributes;
    private int index;
    private oracle.jdbc.OracleConnection conn;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleSQLOutput(StructDescriptor structDescriptor, oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this.descriptor = structDescriptor;
        this.attributes = new Object[structDescriptor.getLength()];
        this.conn = oracleConnection;
        this.index = 0;
    }

    public STRUCT getSTRUCT() throws SQLException {
        return new STRUCT(this.descriptor, (Connection)this.conn, this.attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeString(String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = string;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBoolean(boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bl));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = bl;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeByte(byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(by));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = (int)by;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeShort(short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(s2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = (int)s2;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInt(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = n2;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLong(long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(l2));
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = new Long(l2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFloat(float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(f2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = new Float(f2);
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeDouble(double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(d2));
                    }
                    Object var4_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.attributes[this.index++] = new Double(d2);
            Object var6_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bigDecimal));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = bigDecimal;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = byArray;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDate(Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(date));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = date;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTime(Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(time));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = time;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(timestamp));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = timestamp;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCharacterStream(Reader reader) throws SQLException {
        try {
            char[] cArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(reader));
                    }
                    cArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            cArray = new char[100];
            int n2 = 0;
            try {
                while ((n2 = reader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLOutput.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        Object var7_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string = stringBuffer.substring(0, stringBuffer.length());
            this.attributes[this.index++] = string;
            Object var9_13 = null;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_17 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_15 = null;
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        try {
            byte[] byArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(inputStream));
                    }
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            byArray = new byte[100];
            char[] cArray = new char[100];
            int n2 = 0;
            try {
                while ((n2 = inputStream.read(byArray)) != -1) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        cArray[i2] = (char)byArray[i2];
                    }
                    stringBuffer.append(cArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleSQLOutput.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + iOException);
                        Object var8_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string = stringBuffer.substring(0, stringBuffer.length());
            this.attributes[this.index++] = string;
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(inputStream));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.writeAsciiStream(inputStream);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(SQLData sQLData) throws SQLException {
        try {
            StructDescriptor structDescriptor;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sQLData));
                    }
                    structDescriptor = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            STRUCT sTRUCT = null;
            if (sQLData != null) {
                structDescriptor = StructDescriptor.createDescriptor(sQLData.getSQLTypeName(), (Connection)this.conn);
                SQLOutput sQLOutput = structDescriptor.toJdbc2SQLOutput();
                sQLData.writeSQL(sQLOutput);
                sTRUCT = ((OracleSQLOutput)sQLOutput).getSTRUCT();
            }
            this.writeStruct(sTRUCT);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void writeObject(Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (object != null && object instanceof SQLData) {
                this.writeObject((SQLData)object);
            } else {
                this.attributes[this.index++] = object;
            }
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRef(Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(ref));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = ref;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBlob(Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(blob));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = blob;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void writeClob(Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(clob));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.attributes[this.index++] = clob;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStruct(Struct struct) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(struct));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = struct;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArray(Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(array));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = array;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeOracleObject(Datum datum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(datum));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = datum;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRef(REF rEF) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rEF));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = rEF;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public void writeBlob(BLOB bLOB) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bLOB));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = bLOB;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBfile(BFILE bFILE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(bFILE));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = bFILE;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClob(CLOB cLOB) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cLOB));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = cLOB;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeStruct(STRUCT sTRUCT) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(sTRUCT));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.attributes[this.index++] = sTRUCT;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeArray(ARRAY aRRAY) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(aRRAY));
                    }
                    Object var3_2 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.attributes[this.index++] = aRRAY;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_9 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNUMBER(NUMBER nUMBER) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(nUMBER));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = nUMBER;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeCHAR(CHAR cHAR) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(cHAR));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = cHAR;
            Object var5_5 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_9 = null;
            }
            catch (Throwable throwable2) {
                Object var7_10 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDATE(DATE dATE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(dATE));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = dATE;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRAW(RAW rAW) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rAW));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = rAW;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeROWID(ROWID rOWID) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rOWID));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.attributes[this.index++] = rOWID;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeURL(URL uRL) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleSQLOutput.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.OracleSQLOutput"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

