/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterSet;

public final class CharacterWalker {
    CharacterSet charSet;
    byte[] bytes;
    int next;
    int end;
    int shiftstate;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public CharacterWalker(CharacterSet characterSet, byte[] byArray, int n2, int n3) {
        this.charSet = characterSet;
        this.bytes = byArray;
        this.next = n2;
        this.end = n2 + n3;
        if (this.next < 0) {
            this.next = 0;
        }
        if (this.end > byArray.length) {
            this.end = byArray.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextCharacter() throws NoSuchElementException {
        try {
            return this.charSet.decode(this);
        }
        catch (SQLException sQLException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    CharacterWalker.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing java.util.NoSuchElementException: " + sQLException.getMessage());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw new NoSuchElementException(sQLException.getMessage());
        }
    }

    public boolean hasMoreCharacters() {
        return this.next < this.end;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterWalker"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

