/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.net.nt.MetricsEnabledSSLSocketInputStream;

class MetricsEnabledSSLSocketWrapper
extends SSLSocket {
    PhaseEventIntf waitEvent;
    MetricsEnabledSSLSocketInputStream meinput;
    SSLSocket socket;

    MetricsEnabledSSLSocketWrapper(Socket socket, PhaseEventIntf phaseEventIntf) {
        this.socket = (SSLSocket)socket;
        this.waitEvent = phaseEventIntf;
    }

    public MetricsEnabledSSLSocketWrapper() {
    }

    public MetricsEnabledSSLSocketWrapper(InetAddress inetAddress, int n2) throws IOException {
        super(inetAddress, n2);
    }

    public MetricsEnabledSSLSocketWrapper(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        super(inetAddress, n2, inetAddress2, n3);
    }

    public MetricsEnabledSSLSocketWrapper(String string, int n2) throws IOException {
        super(string, n2);
    }

    public MetricsEnabledSSLSocketWrapper(String string, int n2, InetAddress inetAddress, int n3) throws IOException {
        super(string, n2, inetAddress, n3);
    }

    public void bind(SocketAddress socketAddress) throws IOException {
        this.socket.bind(socketAddress);
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void connect(SocketAddress socketAddress) throws IOException {
        this.socket.connect(socketAddress);
    }

    public void connect(SocketAddress socketAddress, int n2) throws IOException {
        this.socket.connect(socketAddress, n2);
    }

    public SocketChannel getChannel() {
        return this.socket.getChannel();
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        if (this.meinput == null) {
            InputStream inputStream = this.socket.getInputStream();
            this.meinput = new MetricsEnabledSSLSocketInputStream(inputStream, this.waitEvent);
        }
        return this.meinput;
    }

    public boolean getKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }

    public InetAddress getLocalAddress() {
        return this.socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    public int getPort() {
        return this.socket.getPort();
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    public boolean isBound() {
        return this.socket.isBound();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public void sendUrgentData(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    public void setKeepAlive(boolean bl) throws SocketException {
        this.socket.setKeepAlive(bl);
    }

    public void setOOBInline(boolean bl) throws SocketException {
        this.socket.setOOBInline(bl);
    }

    public void setPerformancePreferences(int n2, int n3, int n4) {
        this.socket.setPerformancePreferences(n2, n3, n4);
    }

    public void setReceiveBufferSize(int n2) throws SocketException {
        this.socket.setReceiveBufferSize(n2);
    }

    public void setReuseAddress(boolean bl) throws SocketException {
        this.socket.setReuseAddress(bl);
    }

    public void setSendBufferSize(int n2) throws SocketException {
        this.socket.setSendBufferSize(n2);
    }

    public void setSoLinger(boolean bl, int n2) throws SocketException {
        this.socket.setSoLinger(bl, n2);
    }

    public void setSoTimeout(int n2) throws SocketException {
        this.socket.setSoTimeout(n2);
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.socket.setTcpNoDelay(bl);
    }

    public void setTrafficClass(int n2) throws SocketException {
        this.socket.setTrafficClass(n2);
    }

    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    public String toString() {
        return this.socket.toString();
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.addHandshakeCompletedListener(handshakeCompletedListener);
    }

    public String[] getEnabledCipherSuites() {
        return this.socket.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.socket.getEnabledProtocols();
    }

    public boolean getEnableSessionCreation() {
        return this.socket.getEnableSessionCreation();
    }

    public boolean getNeedClientAuth() {
        return this.socket.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.socket.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.socket.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.socket.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.socket.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.socket.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        this.socket.removeHandshakeCompletedListener(handshakeCompletedListener);
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.socket.setEnabledCipherSuites(stringArray);
    }

    public void setEnabledProtocols(String[] stringArray) {
        this.socket.setEnabledProtocols(stringArray);
    }

    public void setEnableSessionCreation(boolean bl) {
        this.socket.setEnableSessionCreation(bl);
    }

    public void setNeedClientAuth(boolean bl) {
        this.socket.setNeedClientAuth(bl);
    }

    public void setUseClientMode(boolean bl) {
        this.socket.setUseClientMode(bl);
    }

    public void setWantClientAuth(boolean bl) {
        this.socket.setWantClientAuth(bl);
    }

    public void startHandshake() throws IOException {
        this.socket.startHandshake();
    }
}

