/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXAHeteroCloseCallback
implements OracleCloseCallback {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beforeClose(OracleConnection oracleConnection, Object object) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleConnection) + ", " + OracleLog.argument(object));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_10 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void afterClose(Object object) {
        try {
            block14: {
                String string;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(object));
                        }
                        string = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                int n2 = ((OracleXAHeteroConnection)object).getRmid();
                string = ((OracleXAHeteroConnection)object).getXaCloseString();
                try {
                    int n3 = this.t2cDoXaClose(string, n2, 0, 0);
                    if (n3 == 0) break block14;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAHeteroCloseCallback.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + -1 * n3);
                            Object var6_8 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), -1 * n3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (SQLException sQLException) {
                }
            }
            Object var8_12 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleXAHeteroCloseCallback.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_14 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private native int t2cDoXaClose(String var1, int var2, int var3, int var4);

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAHeteroCloseCallback"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

