/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Reader;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderDomHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class OracleWebRowSetXmlReaderImpl
implements OracleWebRowSetXmlReader {
    private static final String JAVA_SAXPARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static final String JAVA_DOMPARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String ORACLE_JAXP_SAXPARSER_FACTORY = "oracle.xml.jaxp.JXSAXParserFactory";
    private static final String ORACLE_JAXP_DOMPARSER_FACTORY = "oracle.xml.jaxp.JXDocumentBuilderFactory";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String WEBROWSET_SCHEMA = "http://java.sun.com/xml/ns/jdbc/webrowset.xsd";
    private Document document = null;
    private String parserStr = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleWebRowSetXmlReaderImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        this.parserStr = this.getSystemProperty(JAVA_SAXPARSER_PROPERTY);
        if (this.parserStr != null) {
            this.readXMLSax((OracleWebRowSet)webRowSet, reader);
        } else {
            this.parserStr = this.getSystemProperty(JAVA_DOMPARSER_PROPERTY);
            if (this.parserStr != null) {
                this.readXMLDom((OracleWebRowSet)webRowSet, reader);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "No valid JAXP parser property specified");
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw new SQLException("No valid JAXP parser property specified");
            }
        }
    }

    public void readData(RowSetInternal rowSetInternal) throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXMLSax(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderContHandler oracleWebRowSetXmlReaderContHandler = new OracleWebRowSetXmlReaderContHandler(oracleWebRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            sAXParser.setProperty(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(oracleWebRowSetXmlReaderContHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + sAXParseException.getMessage());
                    Object var9_14 = null;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLSax: SAXNotRecognizedException: " + sAXNotRecognizedException.getMessage());
                    Object var11_17 = null;
                }
                catch (Throwable throwable) {
                    Object var11_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLSax: SAXNotRecognizedException: " + sAXNotRecognizedException.getMessage());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLSax: SAXException: " + sAXException.getMessage());
                    Object var13_20 = null;
                }
                catch (Throwable throwable) {
                    Object var13_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLSax: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLSax: Parser factory config: " + factoryConfigurationError.getMessage());
                    Object var15_23 = null;
                }
                catch (Throwable throwable) {
                    Object var15_24 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLSax: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLSax: Parser config: " + parserConfigurationException.getMessage());
                    Object var17_26 = null;
                }
                catch (Throwable throwable) {
                    Object var17_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLSax: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLSax: " + exception.getMessage());
                    Object var19_29 = null;
                }
                catch (Throwable throwable) {
                    Object var19_30 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLSax: " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXMLDom(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderDomHandler oracleWebRowSetXmlReaderDomHandler = new OracleWebRowSetXmlReaderDomHandler(oracleWebRowSet);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(inputSource);
            oracleWebRowSetXmlReaderDomHandler.readXMLDocument(this.document);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLDom: SAXException: " + sAXException.getMessage());
                    Object var8_11 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLDom: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLDom: Parser factory config: " + factoryConfigurationError.getMessage());
                    Object var10_14 = null;
                }
                catch (Throwable throwable) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLDom: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLDom: Parser config: " + parserConfigurationException.getMessage());
                    Object var12_17 = null;
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLDom: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleWebRowSetXmlReaderImpl.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + "readXMLDom: " + exception.getMessage());
                    Object var14_20 = null;
                }
                catch (Throwable throwable) {
                    Object var14_21 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new SQLException("readXMLDom: " + exception.getMessage());
        }
    }

    private String getSystemProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleWebRowSetXmlReaderImpl"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

