/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;

public class OracleCachedRowSetReader
implements RowSetReader,
Serializable {
    static final long serialVersionUID = -3565405169674271176L;
    static final transient int SETUNICODESTREAM_INTLENGTH = 1;
    static final transient int SETBINARYSTREAM_INTLENGTH = 2;
    static final transient int SETASCIISTREAM_INTLENGTH = 3;
    static final transient int SETCHARACTERSTREAM_INTLENGTH = 4;
    static final transient int TWO_PARAMETERS = 2;
    static final transient int THREE_PARAMETERS = 3;
    private static transient boolean driverManagerInitialized = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleCachedRowSetReader() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection(RowSetInternal rowSetInternal) throws SQLException {
        Connection connection = null;
        Connection connection2 = rowSetInternal.getConnection();
        if (connection2 != null && !connection2.isClosed()) {
            connection = connection2;
        } else if (((RowSet)((Object)rowSetInternal)).getDataSourceName() != null) {
            try {
                Object object;
                InitialContext initialContext = null;
                try {
                    object = System.getProperties();
                    initialContext = new InitialContext((Hashtable<?, ?>)object);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (initialContext == null) {
                    initialContext = new InitialContext();
                }
                object = (DataSource)initialContext.lookup(((RowSet)((Object)rowSetInternal)).getDataSourceName());
                String string = ((RowSet)((Object)rowSetInternal)).getUsername();
                String string2 = ((RowSet)((Object)rowSetInternal)).getPassword();
                if (string == null && string2 == null) {
                    connection = object.getConnection();
                }
                connection = object.getConnection(string, string2);
            }
            catch (NamingException namingException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 300 + namingException.getMessage());
                        Object var9_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_16 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 300, namingException.getMessage());
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        } else if (((RowSet)((Object)rowSetInternal)).getUrl() != null) {
            if (!driverManagerInitialized) {
                DriverManager.registerDriver(new OracleDriver());
                driverManagerInitialized = true;
            }
            String string = ((RowSet)((Object)rowSetInternal)).getUrl();
            String string3 = ((RowSet)((Object)rowSetInternal)).getUsername();
            String string4 = ((RowSet)((Object)rowSetInternal)).getPassword();
            if (string.equals("") || string3.equals("") || string4.equals("")) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 301);
                        Object var11_18 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_19 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 301);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            connection = DriverManager.getConnection(string, string3, string4);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParams(Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        block22: for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n2 = 0;
            if (objectArray[i2] instanceof byte[]) {
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            try {
                n2 = Array.getLength(objectArray[i2]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                preparedStatement.setObject(i2 + 1, objectArray[i2]);
                continue;
            }
            Object[] objectArray2 = (Object[])objectArray[i2];
            if (n2 == 2) {
                if (objectArray2[0] == null) {
                    preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1]);
                    continue;
                }
                if (objectArray2[0] instanceof Date) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setDate(i2 + 1, (Date)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                            Object var7_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_8 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (objectArray2[0] instanceof Time) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setTime(i2 + 1, (Time)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                            Object var9_16 = null;
                        }
                        catch (Throwable throwable) {
                            Object var9_17 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (objectArray2[0] instanceof Timestamp) {
                    if (objectArray2[1] instanceof Calendar) {
                        preparedStatement.setTimestamp(i2 + 1, (Timestamp)objectArray2[0], (Calendar)objectArray2[1]);
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                            Object var11_19 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_20 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (!(objectArray2[1] instanceof Integer)) continue;
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1]);
                continue;
            }
            if (n2 != 3) continue;
            if (objectArray2[0] == null) {
                preparedStatement.setNull(i2 + 1, (Integer)objectArray2[1], (String)objectArray2[2]);
                continue;
            }
            if (objectArray2[0] instanceof Reader) {
                switch ((Integer)objectArray2[2]) {
                    case 4: {
                        preparedStatement.setCharacterStream(i2 + 1, (Reader)objectArray2[0], (Integer)objectArray2[1]);
                        continue block22;
                    }
                    default: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                Object var13_22 = null;
                            }
                            catch (Throwable throwable) {
                                Object var13_23 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
            if (objectArray2[0] instanceof InputStream) {
                switch ((Integer)objectArray2[2]) {
                    case 1: {
                        preparedStatement.setUnicodeStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block22;
                    }
                    case 2: {
                        preparedStatement.setBinaryStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block22;
                    }
                    case 3: {
                        preparedStatement.setAsciiStream(i2 + 1, (InputStream)objectArray2[0], (Integer)objectArray2[1]);
                        continue block22;
                    }
                    default: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                                Object var15_25 = null;
                            }
                            catch (Throwable throwable) {
                                Object var15_26 = null;
                                OracleLog.recursiveExit();
                                throw throwable;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
            }
            if (objectArray2[1] instanceof Integer && objectArray2[2] instanceof Integer) {
                preparedStatement.setObject(i2 + 1, objectArray2[0], (Integer)objectArray2[1], (int)((Integer)objectArray2[2]));
                continue;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 323);
                    Object var17_28 = null;
                }
                catch (Throwable throwable) {
                    Object var17_29 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 323);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readData(RowSetInternal rowSetInternal) throws SQLException {
        try {
            Connection connection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(rowSetInternal));
                    }
                    connection = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            OracleCachedRowSet oracleCachedRowSet = (OracleCachedRowSet)rowSetInternal;
            connection = this.getConnection(rowSetInternal);
            if (connection == null || oracleCachedRowSet.getCommand() == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCachedRowSetReader.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 342);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 342);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            try {
                connection.setTransactionIsolation(oracleCachedRowSet.getTransactionIsolation());
            }
            catch (Exception exception) {
                // empty catch block
            }
            PreparedStatement preparedStatement = connection.prepareStatement(oracleCachedRowSet.getCommand(), oracleCachedRowSet.getType(), oracleCachedRowSet.getConcurrency());
            this.setParams(rowSetInternal.getParams(), preparedStatement);
            try {
                preparedStatement.setMaxRows(oracleCachedRowSet.getMaxRows());
                preparedStatement.setMaxFieldSize(oracleCachedRowSet.getMaxFieldSize());
                preparedStatement.setEscapeProcessing(oracleCachedRowSet.getEscapeProcessing());
                preparedStatement.setQueryTimeout(oracleCachedRowSet.getQueryTimeout());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            oracleCachedRowSet.populate(resultSet, oracleCachedRowSet.getCurrentPage() * oracleCachedRowSet.getPageSize());
            resultSet.close();
            preparedStatement.close();
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (!oracleCachedRowSet.isConnectionStayingOpen()) {
                connection.close();
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCachedRowSetReader.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_17 = null;
            }
            catch (Throwable throwable) {
                Object var10_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.rowset");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.rowset.OracleCachedRowSetReader"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

