/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleOCIConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public class OracleOCIConnectionPool
extends OracleDataSource {
    public oracle.jdbc.oci.OracleOCIConnection m_connection_pool;
    public static final String IS_CONNECTION_POOLING = "is_connection_pooling";
    private int m_conn_min_limit = 0;
    private int m_conn_max_limit = 0;
    private int m_conn_increment = 0;
    private int m_conn_active_size = 0;
    private int m_conn_pool_size = 0;
    private int m_conn_timeout = 0;
    private String m_conn_nowait = "false";
    private int m_is_transactions_distributed = 0;
    public static final String CONNPOOL_OBJECT = "connpool_object";
    public static final String CONNPOOL_LOGON_MODE = "connection_pool";
    public static final String CONNECTION_POOL = "connection_pool";
    public static final String CONNPOOL_CONNECTION = "connpool_connection";
    public static final String CONNPOOL_PROXY_CONNECTION = "connpool_proxy_connection";
    public static final String CONNPOOL_ALIASED_CONNECTION = "connpool_alias_connection";
    public static final String PROXY_USER_NAME = "proxy_user_name";
    public static final String PROXY_DISTINGUISHED_NAME = "proxy_distinguished_name";
    public static final String PROXY_CERTIFICATE = "proxy_certificate";
    public static final String PROXY_ROLES = "proxy_roles";
    public static final String PROXY_NUM_ROLES = "proxy_num_roles";
    public static final String PROXY_PASSWORD = "proxy_password";
    public static final String PROXYTYPE = "proxytype";
    public static final String PROXYTYPE_USER_NAME = "proxytype_user_name";
    public static final String PROXYTYPE_DISTINGUISHED_NAME = "proxytype_distinguished_name";
    public static final String PROXYTYPE_CERTIFICATE = "proxytype_certificate";
    public static final String CONNECTION_ID = "connection_id";
    public static final String CONNPOOL_MIN_LIMIT = "connpool_min_limit";
    public static final String CONNPOOL_MAX_LIMIT = "connpool_max_limit";
    public static final String CONNPOOL_INCREMENT = "connpool_increment";
    public static final String CONNPOOL_ACTIVE_SIZE = "connpool_active_size";
    public static final String CONNPOOL_POOL_SIZE = "connpool_pool_size";
    public static final String CONNPOOL_TIMEOUT = "connpool_timeout";
    public static final String CONNPOOL_NOWAIT = "connpool_nowait";
    public static final String CONNPOOL_IS_POOLCREATED = "connpool_is_poolcreated";
    public static final String TRANSACTIONS_DISTRIBUTED = "transactions_distributed";
    private Hashtable m_lconnections = null;
    private Lifecycle lifecycle = Lifecycle.NEW;
    private OracleDriver m_oracleDriver = new OracleDriver();
    protected int m_stmtCacheSize = 0;
    protected boolean m_stmtClearMetaData = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen() throws SQLException {
        if (this.lifecycle == Lifecycle.NEW) {
            this.createConnectionPool(null);
        }
        if (this.lifecycle != Lifecycle.OPEN) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 8);
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleOCIConnectionPool(String string, String string2, String string3, Properties properties) throws SQLException {
        this();
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2) + ", " + OracleLog.argument(string3) + ", " + OracleLog.argument(properties));
                    }
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.setURL(string3);
            this.setUser(string);
            this.setPassword(string2);
            this.createConnectionPool(properties);
            Object var8_8 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable2) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleOCIConnectionPool(String string, String string2, String string3) throws SQLException {
        this();
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2) + ", " + OracleLog.argument(string3));
                    }
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.setURL(string3);
            this.setUser(string);
            this.setPassword(string2);
            this.createConnectionPool(null);
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_11 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OracleOCIConnectionPool() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.isOracleDataSource = false;
            this.m_lconnections = new Hashtable(10);
            this.setDriverType("oci8");
            Object var4_4 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var6_9 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_8 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var6_6 = null;
            OracleLog.recursiveExit();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection() throws SQLException {
        Connection connection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    connection = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Connection connection2 = this.getConnection(this.user, this.password);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + connection2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            connection = connection2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Connection getConnection(String string, String string2) throws SQLException {
        oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection;
        try {
            oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                    oracleOCIConnection2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.connectionProperties != null ? new Properties(this.connectionProperties) : new Properties();
            properties.put(IS_CONNECTION_POOLING, "true");
            properties.put("user", string);
            properties.put("password", string2);
            properties.put("connection_pool", CONNPOOL_CONNECTION);
            properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
            oracleOCIConnection2 = (oracle.jdbc.oci.OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
            if (oracleOCIConnection2 == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleOCIConnection2.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(oracleOCIConnection2, oracleOCIConnection2);
            oracleOCIConnection2.setConnectionPool(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleOCIConnection2);
                    }
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleOCIConnection = oracleOCIConnection2;
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleOCIConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Reference getReference() throws NamingException {
        Reference reference;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    reference = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Reference reference2 = new Reference(this.getClass().getName(), "oracle.jdbc.pool.OracleDataSourceFactory", null);
            super.addRefProperties(reference2);
            reference2.add(new StringRefAddr(CONNPOOL_MIN_LIMIT, String.valueOf(this.m_conn_min_limit)));
            reference2.add(new StringRefAddr(CONNPOOL_MAX_LIMIT, String.valueOf(this.m_conn_max_limit)));
            reference2.add(new StringRefAddr(CONNPOOL_INCREMENT, String.valueOf(this.m_conn_increment)));
            reference2.add(new StringRefAddr(CONNPOOL_ACTIVE_SIZE, String.valueOf(this.m_conn_active_size)));
            reference2.add(new StringRefAddr(CONNPOOL_POOL_SIZE, String.valueOf(this.m_conn_pool_size)));
            reference2.add(new StringRefAddr(CONNPOOL_TIMEOUT, String.valueOf(this.m_conn_timeout)));
            reference2.add(new StringRefAddr(CONNPOOL_NOWAIT, this.m_conn_nowait));
            reference2.add(new StringRefAddr(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated())));
            reference2.add(new StringRefAddr(TRANSACTIONS_DISTRIBUTED, String.valueOf(this.isDistributedTransEnabled())));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reference2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            reference = reference2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OracleConnection getProxyConnection(String string, Properties properties) throws SQLException {
        Object object;
        try {
            Object object2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(properties));
                    }
                    object2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (PROXYTYPE_USER_NAME.equals(string)) {
                properties.put("user", properties.getProperty(PROXY_USER_NAME));
            } else if (PROXYTYPE_DISTINGUISHED_NAME.equals(string)) {
                properties.put("user", properties.getProperty(PROXY_DISTINGUISHED_NAME));
            } else if (PROXYTYPE_CERTIFICATE.equals(string)) {
                properties.put("user", String.valueOf(properties.getProperty(PROXY_USER_NAME)));
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 107 + "null properties");
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 107, "null properties");
                ((Throwable)object2).fillInStackTrace();
                throw object2;
            }
            properties.put(IS_CONNECTION_POOLING, "true");
            properties.put(PROXYTYPE, string);
            String[] stringArray = (String[])properties.get(PROXY_ROLES);
            if (stringArray != null) {
                properties.put(PROXY_NUM_ROLES, new Integer(stringArray.length));
            } else {
                properties.put(PROXY_NUM_ROLES, new Integer(0));
            }
            properties.put("connection_pool", CONNPOOL_PROXY_CONNECTION);
            properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
            object2 = (oracle.jdbc.oci.OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
            if (object2 == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            ((OracleOCIConnection)object2).setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(object2, object2);
            ((OracleOCIConnection)object2).setConnectionPool(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object2);
                    }
                    Object var10_15 = null;
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            object = object2;
            Object var12_18 = null;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_22 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_23 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_20 = null;
            }
            catch (Throwable throwable) {
                Object var14_21 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OracleConnection getAliasedConnection(byte[] byArray) throws SQLException {
        oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection;
        try {
            oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray));
                    }
                    oracleOCIConnection2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = new Properties();
            properties.put(IS_CONNECTION_POOLING, "true");
            properties.put(CONNECTION_ID, byArray);
            properties.put("connection_pool", CONNPOOL_ALIASED_CONNECTION);
            properties.put(CONNPOOL_OBJECT, this.m_connection_pool);
            oracleOCIConnection2 = (oracle.jdbc.oci.OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties);
            if (oracleOCIConnection2 == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            oracleOCIConnection2.setStmtCacheSize(this.m_stmtCacheSize, this.m_stmtClearMetaData);
            this.m_lconnections.put(oracleOCIConnection2, oracleOCIConnection2);
            oracleOCIConnection2.setConnectionPool(this);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oracleOCIConnection2);
                    }
                    Object var7_11 = null;
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleOCIConnection = oracleOCIConnection2;
            Object var9_14 = null;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var11_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var11_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleOCIConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws SQLException {
        try {
            oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    oracleOCIConnection = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.lifecycle != Lifecycle.OPEN) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                        Object var4_5 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                Object var6_8 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_11 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.lifecycle = Lifecycle.CLOSING;
            Iterator iterator = this.m_lconnections.values().iterator();
            while (iterator.hasNext()) {
                oracleOCIConnection = (oracle.jdbc.oci.OracleOCIConnection)iterator.next();
                if (oracleOCIConnection != null && oracleOCIConnection != this.m_connection_pool) {
                    oracleOCIConnection.close();
                }
                iterator.remove();
            }
            this.m_connection_pool.close();
            this.lifecycle = Lifecycle.CLOSED;
            Object var6_9 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var8_16 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var8_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var8_13 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPoolConfig(Properties properties) throws SQLException {
        try {
            int[] nArray;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(properties));
                    }
                    nArray = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (properties == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 106 + "null properties");
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, "null properties");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (!this.isPoolCreated()) {
                this.createConnectionPool(properties);
            } else {
                Properties properties2 = new Properties();
                this.checkPoolConfig(properties, properties2);
                nArray = new int[6];
                OracleOCIConnectionPool.readPoolConfig(properties2, nArray);
                this.m_connection_pool.setConnectionPoolInfo(nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5]);
            }
            this.storePoolProperties();
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    public static void readPoolConfig(int n2, int n3, int n4, int n5, boolean bl, boolean bl2, int[] nArray) {
        for (int i2 = 0; i2 < 6; ++i2) {
            nArray[i2] = 0;
        }
        nArray[0] = n2;
        nArray[1] = n3;
        nArray[2] = n4;
        nArray[3] = n5;
        if (bl) {
            nArray[4] = 1;
        }
        if (bl2) {
            nArray[5] = 1;
        }
    }

    public static void readPoolConfig(Properties properties, int[] nArray) {
        String string = properties.getProperty(CONNPOOL_MIN_LIMIT);
        if (string != null) {
            nArray[0] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_MAX_LIMIT)) != null) {
            nArray[1] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_INCREMENT)) != null) {
            nArray[2] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_TIMEOUT)) != null) {
            nArray[3] = Integer.parseInt(string);
        }
        if ((string = properties.getProperty(CONNPOOL_NOWAIT)) != null && string.equalsIgnoreCase("true")) {
            nArray[4] = 1;
        }
        if ((string = properties.getProperty(TRANSACTIONS_DISTRIBUTED)) != null && string.equalsIgnoreCase("true")) {
            nArray[5] = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPoolConfig(Properties properties, Properties properties2) throws SQLException {
        String string = (String)properties.get(TRANSACTIONS_DISTRIBUTED);
        String string2 = (String)properties.get(CONNPOOL_NOWAIT);
        if (string != null && !string.equalsIgnoreCase("true") || string2 != null && !string2.equalsIgnoreCase("true") || properties.get(CONNPOOL_MIN_LIMIT) == null || properties.get(CONNPOOL_MAX_LIMIT) == null || properties.get(CONNPOOL_INCREMENT) == null || Integer.decode((String)properties.get(CONNPOOL_MIN_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_MAX_LIMIT)) < 0 || Integer.decode((String)properties.get(CONNPOOL_INCREMENT)) < 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 106 + "");
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, "");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = properties.getProperty(string3);
            if (TRANSACTIONS_DISTRIBUTED.equals(string3) || CONNPOOL_NOWAIT.equals(string3)) {
                properties2.put(string3, "true");
                continue;
            }
            properties2.put(string3, string4);
        }
    }

    private synchronized void storePoolProperties() throws SQLException {
        Properties properties = this.getPoolConfig();
        this.m_conn_min_limit = Integer.decode(properties.getProperty(CONNPOOL_MIN_LIMIT));
        this.m_conn_max_limit = Integer.decode(properties.getProperty(CONNPOOL_MAX_LIMIT));
        this.m_conn_increment = Integer.decode(properties.getProperty(CONNPOOL_INCREMENT));
        this.m_conn_active_size = Integer.decode(properties.getProperty(CONNPOOL_ACTIVE_SIZE));
        this.m_conn_pool_size = Integer.decode(properties.getProperty(CONNPOOL_POOL_SIZE));
        this.m_conn_timeout = Integer.decode(properties.getProperty(CONNPOOL_TIMEOUT));
        this.m_conn_nowait = properties.getProperty(CONNPOOL_NOWAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getPoolConfig() throws SQLException {
        Properties properties;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    properties = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties2 = this.m_connection_pool.getConnectionPoolInfo();
            properties2.put(CONNPOOL_IS_POOLCREATED, String.valueOf(this.isPoolCreated()));
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + properties2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            properties = properties2;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getActiveSize() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_ACTIVE_SIZE);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPoolSize() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_POOL_SIZE);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int getTimeout() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_TIMEOUT);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = n3;
            Object var7_10 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getNoWait() throws SQLException {
        String string;
        try {
            String string2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string2 = properties.getProperty(CONNPOOL_NOWAIT);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string2);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            string = string2;
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public synchronized int getMinLimit() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_MIN_LIMIT);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            n2 = n3;
            Object var7_10 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_15 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_14 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var9_12 = null;
            OracleLog.recursiveExit();
            return n2;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getMaxLimit() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_MAX_LIMIT);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getConnectionIncrement() throws SQLException {
        int n2;
        try {
            String string;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    string = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            Properties properties = this.m_connection_pool.getConnectionPoolInfo();
            string = properties.getProperty(CONNPOOL_INCREMENT);
            int n3 = Integer.decode(string);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = n3;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isDistributedTransEnabled() {
        block22: {
            boolean bl;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (this.m_is_transactions_distributed != 1) break block22;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                bl = true;
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable2;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            return bl;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                if (OracleLog.isPublic()) {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                }
                Object var6_21 = null;
            }
            catch (Throwable throwable) {
                Object var6_22 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        boolean bl = false;
        Object var8_10 = null;
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_14 = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConnectionPool(Properties properties) throws SQLException {
        if (this.lifecycle != Lifecycle.NEW) {
            return;
        }
        if (this.user == null || this.password == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 106 + " ");
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 106, " ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Properties properties2 = new Properties();
        if (properties != null) {
            this.checkPoolConfig(properties, properties2);
        }
        properties2.put(IS_CONNECTION_POOLING, "true");
        properties2.put("user", this.user);
        properties2.put("password", this.password);
        properties2.put("connection_pool", "connection_pool");
        if (this.getURL() == null) {
            this.makeURL();
        }
        this.m_connection_pool = (oracle.jdbc.oci.OracleOCIConnection)this.m_oracleDriver.connect(this.url, properties2);
        if (this.m_connection_pool == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 67);
                    Object var5_8 = null;
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 67);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.m_connection_pool.setConnectionPool(this);
        this.m_lconnections.put(this.m_connection_pool, this.m_connection_pool);
        this.lifecycle = Lifecycle.OPEN;
        this.storePoolProperties();
        if (properties != null && "true".equalsIgnoreCase(properties.getProperty(TRANSACTIONS_DISTRIBUTED))) {
            this.m_is_transactions_distributed = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean isPoolCreated() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (this.lifecycle == Lifecycle.OPEN));
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            bl = this.lifecycle == Lifecycle.OPEN;
            Object var6_8 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionClosed(oracle.jdbc.oci.OracleOCIConnection oracleOCIConnection) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(oracleOCIConnection));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (this.lifecycle != Lifecycle.CLOSING && this.m_lconnections.remove(oracleOCIConnection) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "internal OracleOCIConnectionPool error");
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "internal OracleOCIConnectionPool error");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var9_13 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStmtCacheSize(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.setStmtCacheSize(n2, false);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (n2 < 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleOCIConnectionPool.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.m_stmtCacheSize = n2;
            this.m_stmtClearMetaData = bl;
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var10_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getStmtCacheSize() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.m_stmtCacheSize);
                    }
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.m_stmtCacheSize;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean isStmtCacheEnabled() {
        boolean bl;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (this.m_stmtCacheSize > 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + true);
                        }
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                }
                boolean bl2 = true;
                Object var8_9 = null;
                if (!TRACE) return bl2;
                if (!OracleLog.recursiveEnter()) return bl2;
                try {
                    OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var10_12 = null;
                    OracleLog.recursiveExit();
                    return bl2;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + false);
                    }
                    Object var6_21 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var6_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            bl = false;
            Object var8_10 = null;
            if (!TRACE) return bl;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var10_17 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var10_16 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return bl;
        try {}
        catch (Throwable throwable) {
            Object var10_15 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleOCIConnectionPool.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var10_14 = null;
        OracleLog.recursiveExit();
        return bl;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleOCIConnectionPool"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Lifecycle {
        NEW,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

