/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public final class UnpickleContext {
    byte[] image;
    int absoluteOffset;
    int beginOffset;
    int markedOffset;
    Vector patches;
    long[] ldsOffsets;
    boolean[] nullIndicators;
    boolean bigEndian;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public UnpickleContext() {
    }

    public UnpickleContext(byte[] byArray, int n2, boolean[] blArray, long[] lArray, boolean bl) {
        this.image = byArray;
        this.beginOffset = n2;
        this.absoluteOffset = n2;
        this.bigEndian = bl;
        this.nullIndicators = blArray;
        this.patches = null;
        this.ldsOffsets = lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.absoluteOffset];
            Object var3_2 = null;
            ++this.absoluteOffset;
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ++this.absoluteOffset;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readVarNumBytes() throws SQLException {
        byte[] byArray = new byte[this.image[this.absoluteOffset] & 0xFF];
        try {
            System.arraycopy(this.image, this.absoluteOffset + 1, byArray, 0, byArray.length);
            Object var3_2 = null;
            this.absoluteOffset += 22;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.absoluteOffset += 22;
            throw throwable;
        }
        return byArray;
    }

    public byte[] readPtrBytes() throws SQLException {
        byte[] byArray = new byte[(this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2];
        System.arraycopy(this.image, this.absoluteOffset, byArray, 0, byArray.length);
        this.absoluteOffset += byArray.length;
        return byArray;
    }

    public void skipPtrBytes() throws SQLException {
        this.absoluteOffset += (this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF) + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n2) throws SQLException {
        try {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.image, this.absoluteOffset, byArray, 0, n2);
            byte[] byArray2 = byArray;
            Object var5_4 = null;
            this.absoluteOffset += n2;
            return byArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.absoluteOffset += n2;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readLong() throws SQLException {
        try {
            long l2 = (((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 2] & 0xFF)) * 256 + (this.image[this.absoluteOffset + 3] & 0xFF);
            Object var4_2 = null;
            this.absoluteOffset += 4;
            return l2;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.absoluteOffset += 4;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short readShort() throws SQLException {
        try {
            short s2 = (short)((this.image[this.absoluteOffset] & 0xFF) * 256 + (this.image[this.absoluteOffset + 1] & 0xFF));
            Object var3_2 = null;
            this.absoluteOffset += 2;
            return s2;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.absoluteOffset += 2;
            throw throwable;
        }
    }

    public byte[] readLengthBytes() throws SQLException {
        long l2 = this.readLong();
        return this.readBytes((int)l2);
    }

    public void skipLengthBytes() throws SQLException {
        long l2 = this.readLong();
        this.absoluteOffset = (int)((long)this.absoluteOffset + l2);
    }

    public void skipTo(long l2) throws SQLException {
        if (l2 > (long)(this.absoluteOffset - this.beginOffset)) {
            this.absoluteOffset = this.beginOffset + (int)l2;
        }
    }

    public void skipTo(int n2) throws SQLException {
        if (n2 > this.absoluteOffset - this.beginOffset) {
            this.absoluteOffset = this.beginOffset + n2;
        }
    }

    public void mark() throws SQLException {
        this.markedOffset = this.absoluteOffset;
    }

    public void reset() throws SQLException {
        this.absoluteOffset = this.markedOffset;
    }

    public void markAndSkip() throws SQLException {
        this.markedOffset = this.absoluteOffset + 4;
        this.absoluteOffset = this.beginOffset + (int)this.readLong();
    }

    public void markAndSkip(long l2) throws SQLException {
        this.markedOffset = this.absoluteOffset;
        this.absoluteOffset = this.beginOffset + (int)l2;
    }

    public void skipBytes(int n2) throws SQLException {
        if (n2 >= 0) {
            this.absoluteOffset += n2;
        }
    }

    public boolean isNull(int n2) {
        return this.nullIndicators[n2];
    }

    public int absoluteOffset() throws SQLException {
        return this.absoluteOffset;
    }

    public int offset() throws SQLException {
        return this.absoluteOffset - this.beginOffset;
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.UnpickleContext"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

