/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class OracleTypeUPT
extends OracleTypeADT
implements Serializable {
    static final long serialVersionUID = -1994358478872378695L;
    static final byte KOPU_UPT_ADT = -6;
    static final byte KOPU_UPT_COLL = -5;
    static final byte KOPU_UPT_REFCUR = 102;
    static final byte KOTTCOPQ = 58;
    byte uptCode = 0;
    OracleNamedType realType = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeUPT() {
    }

    public OracleTypeUPT(String string, OracleConnection oracleConnection) throws SQLException {
        super(string, (Connection)oracleConnection);
    }

    public OracleTypeUPT(OracleTypeADT oracleTypeADT, int n2, OracleConnection oracleConnection) throws SQLException {
        super(oracleTypeADT, n2, (Connection)oracleConnection);
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        if (object != null) {
            return this.realType.toDatum(object, oracleConnection);
        }
        return null;
    }

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        if (object != null) {
            return this.realType.toDatumArray(object, oracleConnection, l2, n2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTypeCode() throws SQLException {
        switch (this.uptCode) {
            case -6: {
                return this.realType.getTypeCode();
            }
            case -5: {
                return 2003;
            }
            case 58: {
                return 2007;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeUPT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Invalid type code");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid type code");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        long l2 = tDSReader.readLong();
        this.uptCode = tDSReader.readByte();
        tDSReader.addNormalPatch(l2, this.uptCode, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n2;
        int n3;
        int n4;
        block7: {
            block6: {
                n4 = 0;
                if (datum == null) {
                    return n4 += pickleContext.writeElementNull();
                }
                n3 = pickleContext.offset();
                n4 += pickleContext.writeLength(PickleContext.KOPI20_LN_MAXV + 1);
                n2 = 0;
                if (this.uptCode != -6 || ((OracleTypeADT)this.realType).isFinalType()) break block6;
                if (datum instanceof STRUCT) {
                    n2 = ((STRUCT)datum).getDescriptor().getOracleTypeADT().pickle81(pickleContext, datum);
                    break block7;
                } else {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeUPT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "invalid upt state");
                            Object var7_6 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_7 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "invalid upt state");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
            n2 = this.realType.pickle81(pickleContext, datum);
        }
        n4 += n2;
        pickleContext.patchImageLen(n3, n2);
        return n4;
    }

    protected Object unpickle81rec(PickleContext pickleContext, int n2, Map map) throws SQLException {
        byte by = pickleContext.readByte();
        if (PickleContext.isElementNull(by)) {
            return null;
        }
        if (n2 == 9) {
            pickleContext.skipBytes(pickleContext.readRestOfLength(by));
            return null;
        }
        pickleContext.skipRestOfLength(by);
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n2, Map map) throws SQLException {
        long l2 = pickleContext.readRestOfLength(by);
        if (n2 == 9) {
            pickleContext.skipBytes((int)l2);
            return null;
        }
        return this.unpickle81UPT(pickleContext, n2, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object unpickle81UPT(PickleContext pickleContext, int n2, Map map) throws SQLException {
        switch (this.uptCode) {
            case -6: {
                switch (n2) {
                    case 1: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 3, n2, map);
                    }
                    case 2: {
                        STRUCT sTRUCT = ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 1, n2, map);
                        return sTRUCT == null ? sTRUCT : sTRUCT.toJdbc(map);
                    }
                    case 9: {
                        return ((OracleTypeADT)this.realType).unpickle81(pickleContext, null, 9, 1, map);
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeUPT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            case -5: {
                return ((OracleTypeCOLLECTION)this.realType).unpickle81(pickleContext, (ARRAY)null, n2 == 9 ? n2 : 3, n2, map);
            }
            case 58: {
                switch (n2) {
                    case 1: 
                    case 9: {
                        return ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                    }
                    case 2: {
                        OPAQUE oPAQUE = ((OracleTypeOPAQUE)this.realType).unpickle81(pickleContext, null, n2, map);
                        return oPAQUE == null ? oPAQUE : oPAQUE.toJdbc(map);
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeUPT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeUPT.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Unrecognized UPT code");
                Object var10_15 = null;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unrecognized UPT code");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        return null;
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor structDescriptor = null;
        structDescriptor = this.sqlName == null ? new StructDescriptor((OracleTypeADT)this.realType, (Connection)this.connection) : StructDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return structDescriptor;
    }

    ArrayDescriptor createArrayDescriptor() throws SQLException {
        ArrayDescriptor arrayDescriptor = null;
        arrayDescriptor = this.sqlName == null ? new ArrayDescriptor((OracleTypeCOLLECTION)this.realType, (Connection)this.connection) : ArrayDescriptor.createDescriptor(this.sqlName, (Connection)this.connection);
        return arrayDescriptor;
    }

    public OracleType getRealType() throws SQLException {
        return this.realType;
    }

    public int getNumAttrs() throws SQLException {
        return ((OracleTypeADT)this.realType).getNumAttrs();
    }

    public OracleType getAttrTypeAt(int n2) throws SQLException {
        return ((OracleTypeADT)this.realType).getAttrTypeAt(n2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.uptCode);
        objectOutputStream.writeObject(this.realType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.uptCode = objectInputStream.readByte();
        this.realType = (OracleNamedType)objectInputStream.readObject();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this.connection = oracleConnection;
        this.realType.setConnection(oracleConnection);
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
        if (this.realType != null) {
            this.realType.setSqlName(this.sqlName);
            this.realType.initChildNamesRecursively(map);
        }
    }

    public void initMetadataRecursively() throws SQLException {
        this.initMetadata(this.connection);
        if (this.realType != null) {
            this.realType.initMetadataRecursively();
        }
    }

    public void cacheDescriptor() throws SQLException {
    }

    public void printXML(PrintWriter printWriter, int n2, boolean bl) throws SQLException {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleTypeUPT sqlName=\"" + this.sqlName + "\" " + " toid=\"" + this.toid + "\" " + ">");
        if (this.realType != null) {
            this.realType.printXML(printWriter, n2 + 1, bl);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            printWriter.print("  ");
        }
        printWriter.println("</OracleTypeUPT>");
    }

    public void printXML(PrintWriter printWriter, int n2) throws SQLException {
        this.printXML(printWriter, n2, false);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeUPT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

