/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPLTZ;

public class OracleTypeTIMESTAMPLTZ
extends OracleType
implements Serializable {
    static final long serialVersionUID = 1615519855865602397L;
    int precision = 0;
    transient OracleConnection connection;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeTIMESTAMPLTZ() {
    }

    public OracleTypeTIMESTAMPLTZ(OracleConnection oracleConnection) {
        this.connection = oracleConnection;
    }

    public int getTypeCode() {
        return -102;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.precision = tDSReader.readByte();
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getPrecision() throws SQLException {
        return this.precision;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.precision = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n2) {
            case 1: {
                return new TIMESTAMPLTZ(byArray);
            }
            case 2: {
                return TIMESTAMPLTZ.toTimestamp(this.connection, byArray);
            }
            case 3: {
                return byArray;
            }
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeTIMESTAMPLTZ.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ;
        block16: {
            tIMESTAMPLTZ = null;
            if (object != null) {
                try {
                    if (object instanceof TIMESTAMPLTZ) {
                        tIMESTAMPLTZ = (TIMESTAMPLTZ)object;
                        break block16;
                    }
                    if (object instanceof byte[]) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((byte[])object);
                        break block16;
                    }
                    if (object instanceof Timestamp) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Timestamp)object);
                        break block16;
                    }
                    if (object instanceof DATE) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (DATE)object);
                        break block16;
                    }
                    if (object instanceof String) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (String)object);
                        break block16;
                    }
                    if (object instanceof Date) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Date)object);
                        break block16;
                    }
                    if (object instanceof Time) {
                        tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)oracleConnection, (Time)object);
                        break block16;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeTIMESTAMPLTZ.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                            Object var5_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                catch (Exception exception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeTIMESTAMPLTZ.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                            Object var7_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
            }
        }
        return tIMESTAMPLTZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object unpickle81rec(UnpickleContext unpickleContext, int n2, int n3, Map map) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeTIMESTAMPLTZ.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

