/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.Datum;

public class OracleTypeBINARY_DOUBLE
extends OracleType
implements Serializable {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    protected OracleTypeBINARY_DOUBLE() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        BINARY_DOUBLE bINARY_DOUBLE = null;
        if (object != null) {
            if (object instanceof BINARY_DOUBLE) {
                bINARY_DOUBLE = (BINARY_DOUBLE)object;
            } else if (object instanceof Double) {
                bINARY_DOUBLE = new BINARY_DOUBLE((Double)object);
            } else if (object instanceof byte[]) {
                bINARY_DOUBLE = new BINARY_DOUBLE((byte[])object);
            } else {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + object);
                        Object var5_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, object);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return bINARY_DOUBLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l2, int n2) throws SQLException {
        Datum[] datumArray = null;
        if (object != null && object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n3 = (int)(n2 == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l2 + 1L, (long)n2));
            datumArray = new Datum[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object2 = objectArray[(int)l2 + i2 - 1];
                if (object2 != null) {
                    if (object2 instanceof Double) {
                        datumArray[i2] = new BINARY_DOUBLE((double)((Double)object2));
                        continue;
                    }
                    if (object2 instanceof BINARY_DOUBLE) {
                        datumArray[i2] = (BINARY_DOUBLE)object2;
                        continue;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                            Object var12_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var12_11 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                datumArray[i2] = null;
            }
        }
        return datumArray;
    }

    public int getTypeCode() {
        return 101;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object toObject(byte[] byArray, int n2, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        if (n2 == 1) {
            return new BINARY_DOUBLE(byArray);
        }
        if (n2 == 2) {
            return new BINARY_DOUBLE(byArray).toJdbc();
        }
        if (n2 == 3) {
            return byArray;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleTypeBINARY_DOUBLE.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 59 + byArray);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, byArray);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.oracore");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.oracore.OracleBINARY_DOUBLE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

