/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;

final class T4CTTIk2rpc
extends T4CTTIfun {
    static final int K2RPClogon = 1;
    static final int K2RPCbegin = 2;
    static final int K2RPCend = 3;
    static final int K2RPCrecover = 4;
    static final int K2RPCsession = 5;
    private int k2rpctyp;
    private int command;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIk2rpc(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)67);
    }

    void doOK2RPC(int n2, int n3) throws IOException, SQLException {
        this.k2rpctyp = n2;
        this.command = n3;
        this.doRPC();
    }

    void marshal() throws IOException {
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(this.k2rpctyp);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalPTR();
        this.meg.marshalUB4(3L);
        this.meg.marshalPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(0L);
        this.meg.marshalNULLPTR();
        this.meg.marshalUB4(this.command);
        this.meg.marshalUB4(0L);
        this.meg.marshalUB4(0L);
    }

    void readRPA() throws IOException, SQLException {
        int n2 = this.meg.unmarshalUB2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.meg.unmarshalUB4();
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIk2rpc"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

