/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.RawCommonAccessor;

class OutRawAccessor
extends RawCommonAccessor {
    static final int MAXLENGTH_NEW = Short.MAX_VALUE;
    static final int MAXLENGTH_OLD = Short.MAX_VALUE;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OutRawAccessor(OracleStatement oracleStatement, int n2, short s2, int n3) throws SQLException {
        this.init(oracleStatement, 23, 23, s2, true);
        this.initForDataAccess(n3, n2, null);
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = this.statement.connection.getVersionNumber() >= 8000 ? Short.MAX_VALUE : Short.MAX_VALUE;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OutRawAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
        }
        return byArray;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OutRawAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

