/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CLOB;

class OracleClobOutputStream
extends OutputStream {
    long lobOffset;
    CLOB clob;
    byte[] buf;
    int count;
    int bufSize;
    boolean isClosed;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    public OracleClobOutputStream(CLOB cLOB, int n2) throws SQLException {
        this(cLOB, n2, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleClobOutputStream(CLOB cLOB, int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection;
        if (cLOB == null || n2 <= 0 || l2 < 1L) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IllegalArgumentException: " + "");
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw new IllegalArgumentException();
        }
        this.clob = cLOB;
        this.lobOffset = l2;
        PhysicalConnection physicalConnection2 = physicalConnection = (PhysicalConnection)cLOB.getInternalConnection();
        synchronized (physicalConnection2) {
            this.buf = physicalConnection.getByteBuffer(n2);
        }
        this.count = 0;
        this.bufSize = n2;
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            if (this.count >= this.bufSize) {
                this.flushBuffer();
            }
            this.buf[this.count++] = (byte)n2;
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var7_9 = null;
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            int n4;
            int n5;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(byArray) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                    Object var5_4 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            this.ensureOpen();
            int n6 = Math.min(n3, byArray.length - n2);
            if (n6 >= 2 * this.bufSize) {
                if (this.count > 0) {
                    this.flushBuffer();
                }
                try {
                    char[] cArray = new char[n6];
                    for (int i2 = 0; i2 < n6; ++i2) {
                        cArray[i2] = (char)byArray[i2 + n2];
                    }
                    this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray);
                }
                catch (SQLException sQLException) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                            Object var9_15 = null;
                            OracleLog.recursiveExit();
                        }
                        catch (Throwable throwable) {
                            Object var9_16 = null;
                            OracleLog.recursiveExit();
                            throw throwable;
                        }
                    }
                    IOException iOException = DatabaseError.createIOException(sQLException);
                    iOException.fillInStackTrace();
                    throw iOException;
                }
                Object var13_18 = null;
                if (!TRACE) return;
                if (!OracleLog.recursiveEnter()) return;
                try {
                    OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var15_21 = null;
                    OracleLog.recursiveExit();
                    return;
                }
                catch (Throwable throwable) {
                    Object var15_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            int n7 = n5 + n6;
            for (n5 = n2; n5 < n7; n5 += n4, this.count += n4) {
                n4 = Math.min(this.bufSize - this.count, n7 - n5);
                System.arraycopy(byArray, n5, this.buf, this.count, n4);
                if (this.count < this.bufSize) continue;
                this.flushBuffer();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                    }
                    Object var11_30 = null;
                    OracleLog.recursiveExit();
                }
                catch (Throwable throwable) {
                    Object var11_31 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
            }
            Object var13_19 = null;
            if (!TRACE) return;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            if (!TRACE) throw throwable;
            if (!OracleLog.recursiveEnter()) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var15_26 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var15_25 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        if (!OracleLog.recursiveEnter()) return;
        try {}
        catch (Throwable throwable) {
            Object var15_24 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
        Object var15_23 = null;
        OracleLog.recursiveExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            this.ensureOpen();
            this.flushBuffer();
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        block32: {
            if (OracleClobOutputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                    var2_1 = null;
                }
                catch (Throwable var1_3) {
                    var2_2 = null;
                    OracleLog.recursiveExit();
                    throw var1_3;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (!this.isClosed) break block33;
            var11_4 = null;
            if (!OracleClobOutputStream.TRACE || !OracleLog.recursiveEnter()) ** GOTO lbl-1000
            try {
                OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var13_7 = null;
            }
            catch (Throwable var12_13) {
                var13_8 = null;
                OracleLog.recursiveExit();
                throw var12_13;
            }
            OracleLog.recursiveExit();
            {
            }
lbl-1000:
            // 2 sources

            {
                block33: {
                    return;
                }
                try {
                    this.isClosed = true;
                    this.flushBuffer();
                    var4_16 = null;
                }
                catch (Throwable var3_34) {
                    var4_17 = null;
                    try {
                        var6_24 = var5_20 = (PhysicalConnection)this.clob.getInternalConnection();
                        synchronized (var6_24) {
                            if (this.buf != null) {
                                var5_20.cacheBuffer(this.buf);
                                this.buf = null;
                            }
                        }
                    }
                    catch (SQLException var5_21) {
                        if (OracleClobOutputStream.TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + var5_21);
                                var9_30 = null;
                            }
                            catch (Throwable var8_33) {
                                var9_31 = null;
                                OracleLog.recursiveExit();
                                throw var8_33;
                            }
                            OracleLog.recursiveExit();
                            {
                            }
                        }
                        var6_25 = DatabaseError.createIOException(var5_21);
                        var6_25.fillInStackTrace();
                        throw var6_25;
                    }
                    throw var3_34;
                }
                try {
                    var6_22 = var5_18 = (PhysicalConnection)this.clob.getInternalConnection();
                    synchronized (var6_22) {
                        if (this.buf != null) {
                            var5_18.cacheBuffer(this.buf);
                            this.buf = null;
                        }
                    }
                }
                catch (SQLException var5_19) {
                    if (OracleClobOutputStream.TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + var5_19);
                            var9_28 = null;
                        }
                        catch (Throwable var8_32) {
                            var9_29 = null;
                            OracleLog.recursiveExit();
                            throw var8_32;
                        }
                        OracleLog.recursiveExit();
                        {
                        }
                    }
                    var6_23 = DatabaseError.createIOException(var5_19);
                    var6_23.fillInStackTrace();
                    throw var6_23;
                }
            }
            var11_5 = null;
            if (OracleClobOutputStream.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    var13_9 = null;
                }
                catch (Throwable var12_14) {
                    var13_10 = null;
                    OracleLog.recursiveExit();
                    throw var12_14;
                }
                OracleLog.recursiveExit();
                {
                    break block32;
                }
            }
            break block32;
            catch (Throwable var10_35) {
                var11_6 = null;
                if (OracleClobOutputStream.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                        var13_11 = null;
                    }
                    catch (Throwable var12_15) {
                        var13_12 = null;
                        OracleLog.recursiveExit();
                        throw var12_15;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                throw var10_35;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushBuffer() throws IOException {
        try {
            if (this.count > 0) {
                char[] cArray = new char[this.count];
                for (int i2 = 0; i2 < this.count; ++i2) {
                    cArray[i2] = (char)this.buf[i2];
                }
                this.lobOffset += (long)this.clob.putChars(this.lobOffset, cArray);
                this.count = 0;
            }
        }
        catch (SQLException sQLException) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            IOException iOException = DatabaseError.createIOException(sQLException);
            iOException.fillInStackTrace();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureOpen() throws IOException {
        block8: {
            try {
                if (!this.isClosed) break block8;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 57 + null);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 57, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            catch (SQLException sQLException) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleClobOutputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + sQLException);
                        Object var4_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                IOException iOException = DatabaseError.createIOException(sQLException);
                iOException.fillInStackTrace();
                throw iOException;
            }
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        try {
            return this.clob.getInternalConnection();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleClobOutputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

