/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.TypeAccessor;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.OPAQUE;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

class NamedTypeAccessor
extends TypeAccessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    NamedTypeAccessor(OracleStatement oracleStatement, String string, short s2, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 109, 109, s2, bl);
        this.initForDataAccess(n2, 0, string);
    }

    NamedTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, String string) throws SQLException {
        this.init(oracleStatement, 109, 109, s2, false);
        this.initForDescribe(109, n2, bl, n3, n4, n5, n6, n7, s2, string);
        this.initForDataAccess(0, n2, string);
    }

    NamedTypeAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2, String string, OracleType oracleType) throws SQLException {
        this.init(oracleStatement, 109, 109, s2, false);
        this.describeOtype = oracleType;
        this.initForDescribe(109, n2, bl, n3, n4, n5, n6, n7, s2, string);
        this.internalOtype = oracleType;
        this.initForDataAccess(0, n2, string);
    }

    OracleType otypeFromName(String string) throws SQLException {
        if (!this.outBind) {
            return TypeDescriptor.getTypeDescriptor(string, this.statement.connection).getPickler();
        }
        if (this.externalType == 2003) {
            return ArrayDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeCOLLECTION();
        }
        if (this.externalType == 2007) {
            return OpaqueDescriptor.createDescriptor(string, (Connection)this.statement.connection).getPickler();
        }
        return StructDescriptor.createDescriptor(string, (Connection)this.statement.connection).getOracleTypeADT();
    }

    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        super.initForDataAccess(n2, n3, string);
        this.byteLength = this.statement.connection.namedTypeAccessorByteLen;
    }

    Object getObject(int n2) throws SQLException {
        return this.getObject(n2, this.statement.connection.getTypeMap());
    }

    Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        return oracleDataFactory.create(this.getObject(n2, this.statement.connection.getTypeMap()), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getObject(int n2, Map map) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            if (this.externalType == 0) {
                Datum datum = this.getOracleObject(n2);
                if (datum == null) {
                    return null;
                }
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                if (datum instanceof OPAQUE) {
                    Object object = ((OPAQUE)datum).toJdbc(map);
                    return object;
                }
                return datum.toJdbc();
            }
            switch (this.externalType) {
                case 2008: {
                    map = null;
                }
                case 2000: 
                case 2002: 
                case 2003: 
                case 2007: {
                    Datum datum = this.getOracleObject(n2);
                    if (datum == null) {
                        return null;
                    }
                    if (datum instanceof STRUCT) {
                        return ((STRUCT)datum).toJdbc(map);
                    }
                    return datum.toJdbc();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Datum getOracleObject(int n2) throws SQLException {
        DatumWithConnection datumWithConnection = null;
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = this.pickledBytes(n2);
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.internalOtype;
        TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(oracleTypeADT.getFullName(), physicalConnection, byArray, 0L);
        switch (typeDescriptor.getTypeCode()) {
            case 2003: {
                datumWithConnection = new ARRAY((ArrayDescriptor)typeDescriptor, byArray, physicalConnection);
                break;
            }
            case 2002: {
                datumWithConnection = new STRUCT((StructDescriptor)typeDescriptor, byArray, physicalConnection);
                break;
            }
            case 2007: {
                datumWithConnection = new OPAQUE((OpaqueDescriptor)typeDescriptor, byArray, physicalConnection);
                break;
            }
            case 2008: {
                datumWithConnection = new JAVA_STRUCT((StructDescriptor)typeDescriptor, byArray, physicalConnection);
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumWithConnection;
    }

    ARRAY getARRAY(int n2) throws SQLException {
        return (ARRAY)this.getOracleObject(n2);
    }

    STRUCT getSTRUCT(int n2) throws SQLException {
        return (STRUCT)this.getOracleObject(n2);
    }

    OPAQUE getOPAQUE(int n2) throws SQLException {
        return (OPAQUE)this.getOracleObject(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNull(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NamedTypeAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 21);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte[] byArray = this.pickledBytes(n2);
        return byArray == null || byArray.length == 0;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NamedTypeAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

