/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import oracle.sql.Datum;
import oracle.sql.utilpack;

public class INTERVALDS
extends Datum {
    private static int MAXLEADPREC = 9;
    private static int MAXHOUR = 23;
    private static int MAXMINUTE = 59;
    private static int MAXSECOND = 59;
    private static int INTERVALDSMAXLENGTH = 11;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;
    static final long serialVersionUID = 7164731704878764759L;

    public INTERVALDS() {
        super(INTERVALDS._initIntervalDS());
    }

    public INTERVALDS(byte[] intervalDS) {
        super(intervalDS);
    }

    public INTERVALDS(String str) {
        super(INTERVALDS.toBytes(str));
    }

    public byte[] toBytes() {
        return this.getBytes();
    }

    public static final INTERVALDS toIntervalds(Duration duration) {
        if (duration == null) {
            return null;
        }
        byte[] bytes = new byte[INTERVALDSMAXLENGTH];
        long seconds = duration.getSeconds();
        if (duration.isNegative()) {
            ++seconds;
        }
        long d = seconds / 86400L;
        long h = seconds / 3600L - d * 24L;
        long m = seconds / 60L - h * 60L - d * 24L * 60L;
        long s = seconds % 60L;
        long n = duration.isNegative() ? (long)(-(1000000000 - duration.getNano())) : (long)duration.getNano();
        n ^= (long)INTERVALDAYOFFSET;
        h += (long)INTERVALDSOFFSET;
        m += (long)INTERVALDSOFFSET;
        s += (long)INTERVALDSOFFSET;
        bytes[0] = (byte)((d ^= (long)INTERVALDAYOFFSET) >> 24);
        bytes[1] = (byte)(d >> 16 & 0xFFL);
        bytes[2] = (byte)(d >> 8 & 0xFFL);
        bytes[3] = (byte)(d & 0xFFL);
        bytes[4] = (byte)(h & 0xFFL);
        bytes[5] = (byte)(m & 0xFFL);
        bytes[6] = (byte)(s & 0xFFL);
        bytes[7] = (byte)(n >> 24);
        bytes[8] = (byte)(n >> 16 & 0xFFL);
        bytes[9] = (byte)(n >> 8 & 0xFFL);
        bytes[10] = (byte)(n & 0xFFL);
        return new INTERVALDS(bytes);
    }

    public static final Duration toDuration(byte[] bytes) {
        long d = (bytes[0] & 0xFF) << 24;
        d |= (long)((bytes[1] & 0xFF) << 16);
        d |= (long)((bytes[2] & 0xFF) << 8);
        d |= (long)(bytes[3] & 0xFF);
        d ^= (long)INTERVALDAYOFFSET;
        long h = bytes[4] - INTERVALDSOFFSET;
        long m = bytes[5] - INTERVALDSOFFSET;
        long s = bytes[6] - INTERVALDSOFFSET;
        int n = (bytes[7] & 0xFF) << 24;
        n |= (bytes[8] & 0xFF) << 16;
        n |= (bytes[9] & 0xFF) << 8;
        n |= bytes[10] & 0xFF;
        return Duration.ofSeconds(d * 86400L + h * 3600L + m * 60L + s, n ^= INTERVALDAYOFFSET);
    }

    public Duration getDuration() {
        return INTERVALDS.toDuration(this.shareBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] toBytes(String str) {
        String secStr;
        String minStr;
        String hourStr;
        int indexOfspace;
        String interStr;
        if (str == null) {
            return null;
        }
        int day = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        int frac = 0;
        byte[] intarr = new byte[INTERVALDSMAXLENGTH];
        String fracStr = null;
        char sign = (interStr = str.trim()).charAt(0);
        int startIndex = sign != '-' && sign != '+' ? 0 : 1;
        String dayStr = (interStr = interStr.substring(startIndex)).substring(0, indexOfspace = interStr.indexOf(32));
        if (dayStr.length() > MAXLEADPREC) {
            throw new NumberFormatException();
        }
        String secondStr = interStr.substring(indexOfspace + 1);
        StringTokenizer secTok = new StringTokenizer(secondStr, ":.");
        if (!secTok.hasMoreTokens()) throw new NumberFormatException();
        try {
            hourStr = secTok.nextToken();
            minStr = secTok.nextToken();
            secStr = secTok.nextToken();
            try {
                fracStr = secTok.nextToken();
            }
            catch (NoSuchElementException nse) {
                fracStr = null;
            }
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
        day = Integer.valueOf(dayStr);
        hour = Integer.valueOf(hourStr);
        min = Integer.valueOf(minStr);
        sec = Integer.valueOf(secStr);
        if (hour > MAXHOUR) {
            throw new NumberFormatException();
        }
        if (min > MAXMINUTE) {
            throw new NumberFormatException();
        }
        if (sec > MAXSECOND) {
            throw new NumberFormatException();
        }
        if (fracStr != null) {
            if (fracStr.length() > MAXLEADPREC) throw new NumberFormatException();
            if (fracStr.length() < MAXLEADPREC) {
                char[] fullfracStr = new char[MAXLEADPREC];
                for (int i = 0; i < fracStr.length(); ++i) {
                    fullfracStr[i] = fracStr.charAt(i);
                }
                for (int j = i; j < MAXLEADPREC; ++j) {
                    fullfracStr[j] = 48;
                }
                String localfracStr = new String(fullfracStr);
                frac = Integer.valueOf(localfracStr);
            } else {
                frac = Integer.valueOf(fracStr);
            }
        }
        if (sign == '-') {
            day = -day;
            hour = -hour;
            min = -min;
            sec = -sec;
            frac = -frac;
        }
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(day += INTERVALDAYOFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(day);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(day);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(day);
        intarr[4] = (byte)(hour + INTERVALDSOFFSET);
        intarr[5] = (byte)(min + INTERVALDSOFFSET);
        intarr[6] = (byte)(sec + INTERVALDSOFFSET);
        intarr[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(frac += INTERVALDAYOFFSET);
        intarr[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(frac);
        intarr[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(frac);
        intarr[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(frac);
        return intarr;
    }

    public static String toString(byte[] inparray) {
        int i;
        if (inparray == null || inparray.length == 0) {
            return new String();
        }
        boolean positive = true;
        int intFrac = 0;
        int intDay = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[0]);
        intDay |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[1]);
        intDay |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[2]);
        intDay |= inparray[3] & 0xFF;
        intDay -= INTERVALDAYOFFSET;
        int intHour = inparray[4] - INTERVALDSOFFSET;
        int intMin = inparray[5] - INTERVALDSOFFSET;
        int intSec = inparray[6] - INTERVALDSOFFSET;
        intFrac = utilpack.LEFTSHIFTFIRSTNIBBLE(inparray[7]);
        intFrac |= utilpack.LEFTSHIFTSECONDNIBBLE(inparray[8]);
        intFrac |= utilpack.LEFTSHIFTTHIRDNIBBLE(inparray[9]);
        intFrac |= inparray[10] & 0xFF;
        intFrac -= INTERVALDAYOFFSET;
        if (intDay < 0) {
            positive = false;
            intDay = -intDay;
            intHour = -intHour;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intHour < 0) {
            positive = false;
            intHour = -intHour;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intMin < 0) {
            positive = false;
            intMin = -intMin;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intSec < 0) {
            positive = false;
            intSec = -intSec;
            intFrac = -intFrac;
        } else if (intFrac < 0) {
            positive = false;
            intFrac = -intFrac;
        }
        String fracString = String.format("%09d", intFrac);
        char[] fracChars = fracString.toCharArray();
        for (i = fracChars.length; i > 1 && fracChars[i - 1] == '0'; --i) {
        }
        fracString = fracString.substring(0, i);
        String result = intDay + " " + intHour + ":" + intMin + ":" + intSec + "." + fracString;
        if (!positive) {
            result = "-" + result;
        }
        return result;
    }

    @Override
    public Object toJdbc() {
        return this;
    }

    @Override
    public String stringValue() {
        return INTERVALDS.toString(this.getBytes());
    }

    public String toString() {
        return INTERVALDS.toString(this.getBytes());
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls.getName().compareTo("java.lang.String") == 0;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        INTERVALDS[] intds = new INTERVALDS[arraySize];
        return intds;
    }

    private static byte[] _initIntervalDS() {
        byte[] intarr = new byte[INTERVALDSMAXLENGTH];
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int fsec = 0;
        intarr[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(day += INTERVALDAYOFFSET);
        intarr[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(day);
        intarr[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(day);
        intarr[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(day);
        intarr[4] = (byte)(hour + INTERVALDSOFFSET);
        intarr[5] = (byte)(minute + INTERVALDSOFFSET);
        intarr[6] = (byte)(second + INTERVALDSOFFSET);
        intarr[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(fsec += INTERVALDAYOFFSET);
        intarr[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(fsec);
        intarr[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(fsec);
        intarr[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(fsec);
        return intarr;
    }
}

