/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.OracleType;
import oracle.jdbc.VectorMetaData;

final class VectorMetaDataImpl
implements VectorMetaData {
    static final VectorMetaData UNKNOWN = new VectorMetaDataImpl(-1, OracleType.VECTOR, double[].class, false);
    private final int length;
    private final OracleType type;
    private final Class<?> arrayClass;
    private final boolean isSparse;

    private VectorMetaDataImpl(int length, OracleType type, Class<?> arrayClass, boolean isSparse) {
        this.length = length;
        this.type = type;
        this.arrayClass = arrayClass;
        this.isSparse = isSparse;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public OracleType type() {
        return this.type;
    }

    @Override
    public Class<?> arrayClass() {
        return this.arrayClass;
    }

    @Override
    public boolean isSparse() {
        return this.isSparse;
    }

    static VectorMetaDataImpl create(int length, int typeCode, boolean isSparse) {
        switch (typeCode) {
            case -105: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR, double[].class, isSparse);
            }
            case -108: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_FLOAT64, double[].class, isSparse);
            }
            case -107: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_FLOAT32, float[].class, isSparse);
            }
            case -106: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_INT8, byte[].class, isSparse);
            }
            case -109: {
                return new VectorMetaDataImpl(length, OracleType.VECTOR_BINARY, byte[].class, isSparse);
            }
        }
        throw new IllegalStateException("Not a VECTOR: " + typeCode);
    }
}

