/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.utils;

import java.util.Objects;
import oracle.jdbc.driver.utils.ThrowingFunction;
import oracle.jdbc.internal.OpaqueString;
import oracle.net.nt.SSLConfig;

public interface WalletLocation {
    public static WalletLocation parse(String locationString) {
        if (locationString == null || locationString.isEmpty()) {
            return null;
        }
        if (locationString.charAt(0) == '(') {
            return new SQLNetLocation(locationString);
        }
        if (locationString.startsWith("file:")) {
            return new FileURILocation(locationString);
        }
        if (SSLConfig.isDataUri(locationString)) {
            return new DataURILocation(locationString);
        }
        if ("SYSTEM".equalsIgnoreCase(locationString)) {
            return SystemLocation.INSTANCE;
        }
        return new PathLocation(locationString);
    }

    public static <T, E extends Exception> T switchExpression(WalletLocation walletLocation, ThrowingFunction<SystemLocation, T, E> caseSystemLocation, ThrowingFunction<PathLocation, T, E> casePathLocation, ThrowingFunction<FileURILocation, T, E> caseFileURILocation, ThrowingFunction<SQLNetLocation, T, E> caseSQLNetLocation, ThrowingFunction<DataURILocation, T, E> caseDataURILocation) throws E {
        if (walletLocation == null) {
            return null;
        }
        if (walletLocation instanceof SystemLocation) {
            return caseSystemLocation.applyOrThrow((SystemLocation)walletLocation);
        }
        if (walletLocation instanceof PathLocation) {
            return casePathLocation.applyOrThrow((PathLocation)walletLocation);
        }
        if (walletLocation instanceof FileURILocation) {
            return caseFileURILocation.applyOrThrow((FileURILocation)walletLocation);
        }
        if (walletLocation instanceof SQLNetLocation) {
            return caseSQLNetLocation.applyOrThrow((SQLNetLocation)walletLocation);
        }
        if (walletLocation instanceof DataURILocation) {
            return caseDataURILocation.applyOrThrow((DataURILocation)walletLocation);
        }
        throw new IllegalStateException("Unrecognized WalletLocation class: " + String.valueOf(walletLocation.getClass()));
    }

    public static OpaqueString revertToString(WalletLocation walletLocation) {
        return WalletLocation.switchExpression(walletLocation, systemLocation -> OpaqueString.newOpaqueString(systemLocation.systemString()), pathLocation -> OpaqueString.newOpaqueString(pathLocation.pathString()), fileUriLocation -> OpaqueString.newOpaqueString(fileUriLocation.uriString()), sqlNetLocation -> OpaqueString.newOpaqueString(sqlNetLocation.sqlNetString()), DataURILocation::opaqueUriString);
    }

    public static final class DataURILocation
    implements WalletLocation {
        private final OpaqueString opaqueUriString;

        public DataURILocation(String dataUri) {
            this(OpaqueString.newOpaqueString(dataUri));
        }

        public DataURILocation(OpaqueString opaqueUriString) {
            if (OpaqueString.isNull(opaqueUriString)) {
                throw new NullPointerException("opaqueUriString is null");
            }
            this.opaqueUriString = opaqueUriString;
        }

        public OpaqueString opaqueUriString() {
            return this.opaqueUriString;
        }

        public String toString() {
            return "DataURILocation[opaqueUri=" + String.valueOf(this.opaqueUriString) + "]";
        }

        public boolean equals(Object other) {
            return other instanceof DataURILocation && ((DataURILocation)other).opaqueUriString.equals(this.opaqueUriString);
        }

        public int hashCode() {
            return this.opaqueUriString.hashCode();
        }
    }

    public static final class FileURILocation
    implements WalletLocation {
        private final String uriString;

        public FileURILocation(String uriString) {
            this.uriString = Objects.requireNonNull(uriString);
        }

        public String uriString() {
            return this.uriString;
        }

        public String toString() {
            return "FileURILocation[uriString=" + this.uriString + "]";
        }

        public boolean equals(Object other) {
            return other instanceof FileURILocation && ((FileURILocation)other).uriString.equals(this.uriString);
        }

        public int hashCode() {
            return this.uriString.hashCode();
        }
    }

    public static final class PathLocation
    implements WalletLocation {
        private final String pathString;

        public PathLocation(String pathString) {
            this.pathString = Objects.requireNonNull(pathString);
        }

        public String pathString() {
            return this.pathString;
        }

        public String toString() {
            return "PathLocation[pathString=" + this.pathString + "]";
        }

        public boolean equals(Object other) {
            return other instanceof PathLocation && ((PathLocation)other).pathString.equals(this.pathString);
        }

        public int hashCode() {
            return this.pathString.hashCode();
        }
    }

    public static final class SQLNetLocation
    implements WalletLocation {
        private final String sqlNetString;

        public SQLNetLocation(String sqlNetString) {
            this.sqlNetString = Objects.requireNonNull(sqlNetString);
        }

        public String sqlNetString() {
            return this.sqlNetString;
        }

        public String toString() {
            return "SQLNetLocation[sqlNetString=" + this.sqlNetString + "]";
        }

        public boolean equals(Object other) {
            return other instanceof SQLNetLocation && ((SQLNetLocation)other).sqlNetString.equals(this.sqlNetString);
        }

        public int hashCode() {
            return this.sqlNetString.hashCode();
        }
    }

    public static final class SystemLocation
    implements WalletLocation {
        private static final SystemLocation INSTANCE = new SystemLocation();
        private static final String SYSTEM_STRING = "SYSTEM";

        private SystemLocation() {
        }

        public String systemString() {
            return SYSTEM_STRING;
        }

        public String toString() {
            return "SystemLocation[]";
        }

        public boolean equals(Object other) {
            return other instanceof SystemLocation;
        }

        public int hashCode() {
            return SYSTEM_STRING.hashCode();
        }
    }
}

