/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import oracle.net.url.common.MalformedURLException;
import oracle.net.url.parser.ExtendedPropertiesParser;
import oracle.net.url.parser.ParserUtils;

final class NameValueParser {
    private static final Set<Character> META_CHARS = ParserUtils.setOf(Character.valueOf('('), Character.valueOf(')'));
    private final String url;
    private final char[] urlChars;
    private int currentPosition = -1;
    private NameValuePair root;
    private Properties connectionProperties;

    NameValueParser(String url) throws MalformedURLException {
        this.url = url;
        this.urlChars = url == null ? null : url.toCharArray();
        this.currentPosition = 0;
        this.parse();
    }

    public NameValuePair rootNode() {
        return this.root;
    }

    public Properties connectionProperties() {
        return this.connectionProperties;
    }

    private NameValuePair parse() throws MalformedURLException {
        if (this.urlChars == null || this.urlChars.length == 0 || this.ignoreWhitespaces()) {
            throw new IllegalArgumentException("URL is null or empty");
        }
        if (this.urlChars[this.currentPosition] != '(') {
            throw new MalformedURLException("URL must start with '('", this.url, this.currentPosition);
        }
        this.root = this.parseNameValuePair();
        ++this.currentPosition;
        this.parseExtendedProperties();
        return this.root;
    }

    private void parseExtendedProperties() throws MalformedURLException {
        this.ignoreWhitespaces();
        if (this.isEOS()) {
            this.connectionProperties = new Properties();
            return;
        }
        if (this.urlChars[this.currentPosition] != '?') {
            throw new MalformedURLException(null, this.url, this.currentPosition);
        }
        ++this.currentPosition;
        this.connectionProperties = new ExtendedPropertiesParser(this.urlChars, this.currentPosition).getProperties();
    }

    private NameValuePair parseNameValuePair() throws MalformedURLException {
        String name;
        NameValuePair nvPair = new NameValuePair();
        nvPair.name = name = this.parseName();
        this.ignoreWhitespaces();
        if (this.isEOS() || this.urlChars[this.currentPosition] != '=') {
            throw new MalformedURLException(null, this.url, this.currentPosition);
        }
        ++this.currentPosition;
        this.ignoreWhitespaces();
        if (this.isEOS()) {
            throw new MalformedURLException("Expected close parenthesis", this.url, this.currentPosition);
        }
        if (this.urlChars[this.currentPosition] == '(') {
            while (!this.isEOS() && this.urlChars[this.currentPosition] == '(') {
                this.parseValues(nvPair);
                ++this.currentPosition;
                this.ignoreWhitespaces();
            }
        } else {
            String value;
            nvPair.value = this.urlChars[this.currentPosition] == ')' ? "" : (value = this.parseLiteral(ParserUtils.setOf(Character.valueOf(')'))));
        }
        if (this.isEOS() || this.urlChars[this.currentPosition] != ')') {
            throw new MalformedURLException("Expected close parenthesis for " + name, this.url, this.currentPosition);
        }
        return nvPair;
    }

    private String parseName() throws MalformedURLException {
        this.ignoreWhitespaces();
        if (this.isEOS() || this.urlChars[this.currentPosition] != '(') {
            throw new MalformedURLException("Name-value pair must begin with a (", this.url, this.currentPosition);
        }
        ++this.currentPosition;
        String name = this.parseLiteral(ParserUtils.setOf(Character.valueOf('=')));
        if (name == null || name.isEmpty()) {
            throw new MalformedURLException("Name can't be empty", this.url, this.currentPosition);
        }
        return name;
    }

    private void parseValues(NameValuePair nvPair) throws MalformedURLException {
        int start = this.currentPosition++;
        this.ignoreWhitespaces();
        String value1 = this.parseLiteral(ParserUtils.setOf(Character.valueOf(')'), Character.valueOf('='), Character.valueOf(',')));
        if (this.urlChars[this.currentPosition] == ')') {
            this.assignValue(nvPair, value1);
        } else if (this.urlChars[this.currentPosition] == ',') {
            this.assignValue(nvPair, this.parseCommaSeparatedValue(value1));
        } else if (this.urlChars[this.currentPosition] == '=') {
            if (nvPair.value != null) {
                throw new MalformedURLException(nvPair.name + " has already value " + nvPair.value + ", can't have child nodes ", this.url, this.currentPosition);
            }
            this.currentPosition = start;
            nvPair.hasNestedChild = true;
            nvPair.children.add(this.parseNameValuePair());
        } else {
            throw new MalformedURLException(null, this.url, this.currentPosition);
        }
    }

    private void assignValue(NameValuePair nvPair, String value) throws MalformedURLException {
        if (nvPair.value != null || nvPair.hasNestedChild) {
            throw new MalformedURLException("Invalid value : " + value + ", for " + nvPair.name, this.url, this.currentPosition);
        }
        nvPair.value = value;
    }

    private String parseCommaSeparatedValue(String firstVal) throws MalformedURLException {
        StringBuilder commaSepValue = new StringBuilder(firstVal);
        while (this.urlChars[this.currentPosition] != ')') {
            this.ignoreWhitespaces();
            if (this.urlChars[this.currentPosition] != ',') {
                throw new MalformedURLException(null, this.url, this.currentPosition);
            }
            ++this.currentPosition;
            commaSepValue.append(',').append(this.parseLiteral(ParserUtils.setOf(Character.valueOf(')'), Character.valueOf(','))));
        }
        return commaSepValue.toString();
    }

    private String parseLiteral(Set<Character> delimiters) throws MalformedURLException {
        if (this.ignoreWhitespaces()) {
            throw new MalformedURLException(null, this.url, this.currentPosition);
        }
        if (this.urlChars[this.currentPosition] == '\'' || this.urlChars[this.currentPosition] == '\"') {
            char quoteChar = this.urlChars[this.currentPosition];
            return this.readQuotedToken(quoteChar);
        }
        StringBuilder tknBuilder = new StringBuilder();
        while (!this.isEOS() && !delimiters.contains(Character.valueOf(this.urlChars[this.currentPosition]))) {
            if (META_CHARS.contains(Character.valueOf(this.urlChars[this.currentPosition]))) {
                throw new MalformedURLException(null, this.url, this.currentPosition);
            }
            tknBuilder.append(this.urlChars[this.currentPosition]);
            ++this.currentPosition;
        }
        return tknBuilder.toString().trim();
    }

    private String readQuotedToken(char quoteChar) throws MalformedURLException {
        int start = this.currentPosition++;
        while (!this.isEOS()) {
            if (this.urlChars[this.currentPosition] == quoteChar && this.urlChars[this.currentPosition - 1] != '\\') {
                return this.url.substring(start, ++this.currentPosition);
            }
            ++this.currentPosition;
        }
        throw new MalformedURLException("Quoted value at " + start + " not closed properly", this.url, this.currentPosition);
    }

    private boolean ignoreWhitespaces() {
        while (!this.isEOS() && Character.isWhitespace(this.urlChars[this.currentPosition])) {
            ++this.currentPosition;
        }
        return this.currentPosition >= this.urlChars.length;
    }

    private boolean isEOS() {
        return this.currentPosition >= this.urlChars.length;
    }

    static class NameValuePair {
        String name;
        String value;
        boolean hasNestedChild = false;
        List<NameValuePair> children = new LinkedList<NameValuePair>();

        NameValuePair() {
        }
    }
}

