/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.parser;

import oracle.net.url.builder.ConnectDescriptorBuilder;
import oracle.net.url.builder.URLBuilder;
import oracle.net.url.common.MalformedURLException;
import oracle.net.url.common.Node;
import oracle.net.url.common.NodeType;
import oracle.net.url.common.URLFormat;
import oracle.net.url.parser.NameValueParser;
import oracle.net.url.parser.URLParseResult;

final class ConnectDescriptorParser {
    private final boolean strictMode;

    ConnectDescriptorParser(boolean strictMode) {
        this.strictMode = strictMode;
    }

    URLParseResult parse(String url) throws MalformedURLException {
        NameValueParser parser = new NameValueParser(url);
        NameValueParser.NameValuePair rootNVPair = parser.rootNode();
        NodeType rootType = NodeType.valueOf(rootNVPair.name);
        ConnectDescriptorBuilder urlBuilder = URLBuilder.newInstance(ConnectDescriptorBuilder.class).strictMode(this.strictMode).rootNode(ConnectDescriptorBuilder.nodeClass(rootType), rootNode -> this.addChildNodes(rootNVPair, (Node)rootNode));
        return new URLParseResult(urlBuilder.rootNode(), parser.connectionProperties(), URLFormat.CONNECT_DESCRIPTOR);
    }

    private void addChildNodes(NameValueParser.NameValuePair parentNVPair, Node parentNode) {
        parentNVPair.children.forEach(childNVPair -> {
            if (childNVPair.hasNestedChild || NodeType.valueOf(childNVPair.name) != NodeType.UNKNOWN_TYPE) {
                NodeType childType = NodeType.valueOf(childNVPair.name);
                parentNode.addChild(ConnectDescriptorBuilder.nodeClass(childType), childNode -> {
                    if (childType == NodeType.UNKNOWN_TYPE) {
                        childNode.name(childNVPair.name);
                    }
                    this.addChildNodes((NameValueParser.NameValuePair)childNVPair, (Node)childNode);
                });
            } else {
                parentNode.param(childNVPair.name, childNVPair.value);
            }
        });
    }
}

