/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import oracle.net.url.builder.EZConnectBuilder;
import oracle.net.url.common.DriverType;

class EZConnectBuilderImpl
implements EZConnectBuilder {
    private Properties userProperties = new Properties();
    private DriverType driverType = DriverType.DEFAULT;
    private Map<Integer, Set<String>> defaultAddressMap = new HashMap<Integer, Set<String>>();
    private Map<String, Map<Integer, Set<String>>> addressListMap = new HashMap<String, Map<Integer, Set<String>>>();
    private String protocol = "tcp";
    private String serviceName = "";
    private String serverMode;
    private String instanceName;
    private boolean strictMode;

    EZConnectBuilderImpl() {
    }

    @Override
    public EZConnectBuilderImpl addProperties(Properties connectionProps) {
        this.userProperties.putAll((Map<?, ?>)connectionProps);
        return this;
    }

    @Override
    public EZConnectBuilderImpl addProperty(String name, String value) {
        this.userProperties.setProperty(name, value);
        return this;
    }

    @Override
    public EZConnectBuilderImpl driverType(DriverType dt) {
        this.driverType = dt;
        return this;
    }

    @Override
    public EZConnectBuilder addAddress(String host, int port) {
        this.defaultAddressMap.computeIfAbsent(port, k -> new LinkedHashSet()).add(host);
        return this;
    }

    @Override
    public EZConnectBuilder addAddressToList(String listName, String host, int port) {
        this.addressListMap.computeIfAbsent(listName, k -> new LinkedHashMap()).computeIfAbsent(port, k -> new LinkedHashSet()).add(host);
        return this;
    }

    @Override
    public EZConnectBuilder serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @Override
    public EZConnectBuilder instance(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Override
    public EZConnectBuilder serverMode(String serverMode) {
        this.serverMode = serverMode;
        return this;
    }

    @Override
    public EZConnectBuilder protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public EZConnectBuilder strictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    @Override
    public String build() {
        StringBuilder url = new StringBuilder();
        this.appendDriverPrefix(url);
        this.appendProtocol(url);
        this.appendAddressInformation(url);
        this.appendServiceName(url);
        this.appendServerMode(url);
        this.appendInstanceName(url);
        return this.getURLWithProperties(url);
    }

    private void appendDriverPrefix(StringBuilder url) {
        if (this.driverType != null) {
            url.append(this.driverType.urlPrefix());
        }
    }

    private void appendProtocol(StringBuilder url) {
        if (this.protocol != null) {
            url.append(this.protocol);
            url.append("://");
        }
    }

    private void appendAddressInformation(StringBuilder url) {
        ArrayList<String> hostInfo = new ArrayList<String>();
        this.addToHostInfo(this.defaultAddressMap, hostInfo);
        this.addressListMap.values().forEach(addrMap -> this.addToHostInfo((Map<Integer, Set<String>>)addrMap, (List<String>)hostInfo));
        url.append(String.join((CharSequence)";", hostInfo));
    }

    private void addToHostInfo(Map<Integer, Set<String>> addressMap, List<String> hostInfo) {
        if (addressMap.isEmpty()) {
            return;
        }
        LinkedList addrInfo = new LinkedList();
        addressMap.forEach((key, hostSet) -> {
            int port = key;
            addrInfo.add(String.join((CharSequence)",", hostSet) + ":" + port);
        });
        hostInfo.add(String.join((CharSequence)",", addrInfo));
    }

    private void appendServiceName(StringBuilder url) {
        if (this.serviceName != null) {
            url.append("/").append(this.serviceName);
        }
    }

    private void appendServerMode(StringBuilder url) {
        if (this.serverMode != null) {
            url.append(":").append(this.serverMode);
        }
    }

    private void appendInstanceName(StringBuilder url) {
        if (this.instanceName != null) {
            url.append("/").append(this.instanceName);
        }
    }

    private String getURLWithProperties(StringBuilder url) {
        if (this.userProperties == null || this.userProperties.isEmpty()) {
            return url.toString();
        }
        url.append("?");
        this.userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> url.append(key).append("=").append(val).append("&")));
        return url.substring(0, url.length() - 1);
    }
}

