/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.util.HashMap;
import java.util.Map;

public class AddressInfo {
    String protocol;
    String host;
    String port;
    Map<String, String> protocolOptions;

    public AddressInfo(String protocol, String host, String port) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.protocolOptions = new HashMap<String, String>();
    }

    public AddressInfo(String protocol, String host, String port, Map<String, String> protocolOptions) {
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.protocolOptions = protocolOptions != null ? protocolOptions : new HashMap();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public Map<String, String> getProtocolOptions() {
        return this.protocolOptions;
    }

    public void setProtocolOptions(Map<String, String> protocolOptions) {
        this.protocolOptions = protocolOptions != null ? protocolOptions : new HashMap();
    }

    public void addProtocolOption(String name, String value) {
        if (this.protocolOptions == null) {
            this.protocolOptions = new HashMap<String, String>();
        }
        this.protocolOptions.put(name, value);
    }

    public void setHttpProxy(String proxyHost, String proxyPort) {
        this.addProtocolOption("HTTPS_PROXY", proxyHost);
        this.addProtocolOption("HTTPS_PROXY_PORT", proxyPort);
    }

    public void setWebsocketURI(String uri) {
        this.addProtocolOption("WEBSOCK_URI", uri);
    }

    public boolean hasProtocolOptions() {
        return this.protocolOptions != null && !this.protocolOptions.isEmpty();
    }

    public String toString() {
        return this.protocol + "://" + this.host + ":" + this.port;
    }
}

