/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.sql.SQLException;
import java.time.Instant;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.provider.opentelemetry.OpenTelemetryTraceEventListenerMBean;

public class OpenTelemetryTraceEventListener
implements TraceEventListener,
OpenTelemetryTraceEventListenerMBean {
    public static final String OPEN_TELEMENTRY_TRACE_EVENT_LISTENER_ENABLED = "oracle.jdbc.provider.opentelemetry.enabled";
    public static final String OPEN_TELEMENTRY_TRACE_EVENT_LISTENER_SENSITIVE_ENABLED = "oracle.jdbc.provider.opentelemetry.sensitive-enabled";
    private static final String TRACE_KEY = "clientcontext.ora$opentelem$tracectx";
    private static final Map<TraceEventListener.JdbcExecutionEvent, Integer> EXECUTION_EVENTS_PARAMETERS = new EnumMap<TraceEventListener.JdbcExecutionEvent, Integer>(TraceEventListener.JdbcExecutionEvent.class){
        {
            this.put(TraceEventListener.JdbcExecutionEvent.AC_REPLAY_STARTED, 3);
            this.put(TraceEventListener.JdbcExecutionEvent.AC_REPLAY_SUCCESSFUL, 3);
            this.put(TraceEventListener.JdbcExecutionEvent.VIP_RETRY, 8);
        }
    };
    private static Logger logger = Logger.getLogger(OpenTelemetryTraceEventListener.class.getName());
    private Tracer tracer;

    public OpenTelemetryTraceEventListener() {
        this(GlobalOpenTelemetry.get().getTracer(OpenTelemetryTraceEventListener.class.getName()));
    }

    public OpenTelemetryTraceEventListener(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public boolean isEnabled() {
        return Configuration.INSTANCE.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        Configuration.INSTANCE.setEnabled(enabled);
    }

    @Override
    public boolean isSensitiveDataEnabled() {
        return Configuration.INSTANCE.isSensitiveDataEnabled();
    }

    @Override
    public void setSensitiveDataEnabled(boolean enabled) {
        Configuration.INSTANCE.setSensitiveDataEnabled(enabled);
    }

    public Object roundTrip(TraceEventListener.Sequence sequence, TraceEventListener.TraceContext traceContext, Object userContext) {
        if (!this.isEnabled()) {
            return null;
        }
        if (sequence == TraceEventListener.Sequence.BEFORE) {
            Span span = this.initAndGetSpan(traceContext, traceContext.databaseOperation());
            try (Scope ignored = span.makeCurrent();){
                traceContext.setClientInfo(TRACE_KEY, this.getTraceValue(span));
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            return span;
        }
        if (userContext instanceof Span) {
            Span span = (Span)userContext;
            span.setStatus(traceContext.isCompletedExceptionally() != false ? StatusCode.ERROR : StatusCode.OK);
            this.endSpan(span);
        }
        return null;
    }

    public Object onExecutionEventReceived(TraceEventListener.JdbcExecutionEvent event, Object userContext, Object ... params) {
        if (!this.isEnabled()) {
            return null;
        }
        if (EXECUTION_EVENTS_PARAMETERS.get(event) == params.length) {
            if (event == TraceEventListener.JdbcExecutionEvent.VIP_RETRY) {
                SpanBuilder spanBuilder = this.tracer.spanBuilder(event.getDescription()).setAttribute("Error message", params[0].toString()).setAttribute("VIP Address", params[7].toString());
                if (Configuration.INSTANCE.isSensitiveDataEnabled()) {
                    logger.log(Level.FINEST, "Sensitive information on");
                    spanBuilder.setAttribute("Protocol", params[1].toString()).setAttribute("Host", params[2].toString()).setAttribute("Port", params[3].toString()).setAttribute("Service name", params[4].toString()).setAttribute("SID", params[5].toString()).setAttribute("Connection data", params[6].toString());
                }
                return spanBuilder.startSpan();
            }
            if (event == TraceEventListener.JdbcExecutionEvent.AC_REPLAY_STARTED || event == TraceEventListener.JdbcExecutionEvent.AC_REPLAY_SUCCESSFUL) {
                SpanBuilder spanBuilder = this.tracer.spanBuilder(event.getDescription()).setAttribute("Error Message", params[0].toString()).setAttribute("Error code", (long)((SQLException)params[1]).getErrorCode()).setAttribute("SQL state", ((SQLException)params[1]).getSQLState()).setAttribute("Current replay retry count", params[2].toString());
                return spanBuilder.startSpan();
            }
            logger.log(Level.WARNING, "Unknown event received : " + event.toString());
        } else {
            logger.log(Level.WARNING, "Wrong number of parameters received for event " + event.toString());
        }
        return null;
    }

    public boolean isDesiredEvent(TraceEventListener.JdbcExecutionEvent event) {
        return true;
    }

    private Span initAndGetSpan(TraceEventListener.TraceContext traceContext, String spanName) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(spanName).setAttribute("thread.id", Thread.currentThread().getId()).setAttribute("thread.name", Thread.currentThread().getName()).setAttribute("Connection ID", traceContext.getConnectionId()).setAttribute("Database Operation", traceContext.databaseOperation()).setAttribute("Database User", traceContext.user()).setAttribute("Database Tenant", traceContext.tenant()).setAttribute("SQL ID", traceContext.getSqlId());
        if (this.isSensitiveDataEnabled()) {
            logger.log(Level.FINEST, "Sensitive information on");
            spanBuilder.setAttribute("Original SQL Text", traceContext.originalSqlText()).setAttribute("Actual SQL Text", traceContext.actualSqlText());
        }
        return spanBuilder.setSpanKind(SpanKind.SERVER).startSpan();
    }

    private void endSpan(Span span) {
        span.end(Instant.now());
    }

    private String getTraceValue(Span span) {
        String traceParent = this.initAndGetTraceParent(span);
        String traceState = this.initAndGetTraceState(span);
        return traceParent + traceState;
    }

    private String initAndGetTraceParent(Span span) {
        SpanContext spanContext = span.getSpanContext();
        String version = "00";
        String traceId = spanContext.getTraceId();
        String parentId = spanContext.getSpanId();
        String traceFlags = spanContext.getTraceFlags().toString();
        return String.format("traceparent: %s-%s-%s-%s\r\n", "00", traceId, parentId, traceFlags);
    }

    private String initAndGetTraceState(Span span) {
        TraceState traceState = span.getSpanContext().getTraceState();
        StringBuilder stringBuilder = new StringBuilder();
        traceState.forEach((k, v) -> stringBuilder.append((String)k).append("=").append((String)v));
        return String.format("tracestate: %s\r\n", stringBuilder);
    }

    private static enum Configuration {
        INSTANCE(true, false);

        private AtomicBoolean enabled;
        private AtomicBoolean sensitiveDataEnabled;

        private Configuration(boolean enabled, boolean sensitiveDataEnabled) {
            String enabledStr = System.getProperty(OpenTelemetryTraceEventListener.OPEN_TELEMENTRY_TRACE_EVENT_LISTENER_ENABLED);
            String sensitiveStr = System.getProperty(OpenTelemetryTraceEventListener.OPEN_TELEMENTRY_TRACE_EVENT_LISTENER_SENSITIVE_ENABLED);
            this.enabled = new AtomicBoolean(enabledStr == null ? enabled : Boolean.parseBoolean(enabledStr));
            this.sensitiveDataEnabled = new AtomicBoolean(sensitiveStr == null ? sensitiveDataEnabled : Boolean.parseBoolean(sensitiveStr));
        }

        private boolean isEnabled() {
            return this.enabled.get();
        }

        private void setEnabled(boolean enabled) {
            this.enabled.set(enabled);
        }

        private boolean isSensitiveDataEnabled() {
            return this.sensitiveDataEnabled.get();
        }

        private void setSensitiveDataEnabled(boolean enabled) {
            this.sensitiveDataEnabled.set(enabled);
        }
    }
}

