/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.vault;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.secrets.SecretsClient;
import com.oracle.bmc.secrets.model.SecretBundle;
import com.oracle.bmc.secrets.requests.GetSecretBundleRequest;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.provider.cache.CachedResourceFactory;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.OciResourceFactory;
import oracle.jdbc.provider.oci.Ocid;
import oracle.jdbc.provider.oci.vault.Secret;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public final class SecretFactory
extends OciResourceFactory<Secret> {
    public static final Parameter<String> OCID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<Secret> INSTANCE = CachedResourceFactory.create((ResourceFactory)new SecretFactory());

    private SecretFactory() {
    }

    public static ResourceFactory<Secret> getInstance() {
        return INSTANCE;
    }

    @Override
    protected Resource<Secret> request(AbstractAuthenticationDetailsProvider authenticationDetails, ParameterSet parameterSet) {
        String secretOcid = (String)parameterSet.getRequired(OCID);
        Ocid ocid = new Ocid(secretOcid);
        if (ocid.getRegion() == null) {
            throw new IllegalStateException("Region is missing in Secret OCID: " + ocid.getContent());
        }
        SecretBundle secretBundle = this.requestSecret(authenticationDetails, ocid);
        Secret secret = Secret.fromSecretBundle(secretBundle);
        Date expireTimeDate = secretBundle.getTimeOfExpiry();
        if (expireTimeDate == null) {
            return Resource.createPermanentResource((Object)secret, (boolean)true);
        }
        OffsetDateTime expireTime = expireTimeDate.toInstant().atOffset(ZoneOffset.UTC);
        return Resource.createExpiringResource((Object)secret, (OffsetDateTime)expireTime, (boolean)true);
    }

    private SecretBundle requestSecret(AbstractAuthenticationDetailsProvider authenticationDetails, Ocid ocid) {
        try (SecretsClient client = ((SecretsClient.Builder)SecretsClient.builder().region(ocid.getRegion())).build(authenticationDetails);){
            GetSecretBundleRequest request = GetSecretBundleRequest.builder().secretId(ocid.getContent()).stage(GetSecretBundleRequest.Stage.Current).build();
            SecretBundle secretBundle = client.getSecretBundle(request).getSecretBundle();
            return secretBundle;
        }
    }

    private Region parseRegion(String ocid) {
        String regex = "ocid1\\.[^.]+\\.[^.]+\\.([^.]+)\\..+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(ocid);
        if (matcher.matches()) {
            return Region.fromRegionCode((String)matcher.group(1));
        }
        throw new IllegalStateException("Fail to parse region from the Secret OCID: " + ocid);
    }
}

