/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Map;
import oracle.jdbc.provider.oci.resource.OciResourceProvider;
import oracle.jdbc.provider.oci.vault.SecretFactory;
import oracle.jdbc.provider.resource.ResourceParameter;
import oracle.jdbc.provider.util.CommonParameters;
import oracle.jdbc.provider.util.TNSNames;
import oracle.jdbc.spi.ConnectionStringProvider;
import oracle.jdbc.spi.OracleResourceProvider;

public class VaultConnectionStringProvider
extends OciResourceProvider
implements ConnectionStringProvider {
    private static final ResourceParameter[] PARAMETERS = new ResourceParameter[]{new ResourceParameter("ocid", SecretFactory.OCID), new ResourceParameter("tnsAlias", CommonParameters.TNS_ALIAS)};

    public VaultConnectionStringProvider() {
        super("vault-tnsnames", PARAMETERS);
    }

    public String getConnectionString(Map<OracleResourceProvider.Parameter, CharSequence> parameterValues) {
        TNSNames tnsNames;
        String alias;
        try {
            alias = (String)this.parseParameterValues(parameterValues).getRequired(CommonParameters.TNS_ALIAS);
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Required parameter 'tnAlias' is missing", e);
        }
        String secretValue = this.getVaultSecret(parameterValues).getBase64Secret();
        byte[] fileBytes = Base64.getDecoder().decode(secretValue);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);){
            tnsNames = TNSNames.read((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read tnsnames.ora content", e);
        }
        String connectionString = tnsNames.getConnectionStringByAlias(alias);
        if (connectionString == null) {
            throw new IllegalArgumentException("Alias specified does not exist in tnsnames.ora: " + alias);
        }
        return connectionString;
    }
}

