/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.objectstorage;

import com.oracle.bmc.Region;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.objectstorage.ObjectStorageClient;
import com.oracle.bmc.objectstorage.requests.GetObjectRequest;
import com.oracle.bmc.objectstorage.responses.GetObjectResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.OciResourceFactory;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public class ObjectFactory
extends OciResourceFactory<InputStream> {
    public static final Parameter<String> OBJECT_URL = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<InputStream> INSTANCE = new ObjectFactory();

    private ObjectFactory() {
    }

    public static ResourceFactory<InputStream> getInstance() {
        return INSTANCE;
    }

    @Override
    protected Resource<InputStream> request(AbstractAuthenticationDetailsProvider authenticationDetails, ParameterSet parameterSet) {
        Resource resource;
        block9: {
            String urlString = (String)parameterSet.getRequired(OBJECT_URL);
            ObjectUrl objectUrl = new ObjectUrl(urlString);
            ObjectStorageClient client = ObjectStorageClient.builder().build(authenticationDetails);
            try {
                client.setRegion(objectUrl.region);
                GetObjectResponse getResponse = client.getObject(GetObjectRequest.builder().namespaceName(objectUrl.namespaceName).bucketName(objectUrl.bucketName).objectName(objectUrl.objectName).build());
                resource = Resource.createPermanentResource((Object)this.cloneInputStream(getResponse.getInputStream()), (boolean)false);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw new IllegalStateException("Failed to read data stream from Object Storage", ioException);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error occurs while acquiring Object Storage client", e);
                }
            }
            client.close();
        }
        return resource;
    }

    private InputStream cloneInputStream(InputStream source) throws IOException {
        int len;
        ByteArrayOutputStream clonedSource = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((len = source.read(buffer)) > -1) {
            clonedSource.write(buffer, 0, len);
        }
        clonedSource.flush();
        return new ByteArrayInputStream(clonedSource.toByteArray());
    }

    private static class ObjectUrl {
        private static final String NAME = "([-_\\w]*)";
        private static final Pattern URL_PATTERN = Pattern.compile("https://objectstorage\\.([-_\\w]*)\\.oraclecloud\\.com\\/n\\/([-_\\w]*)\\/b\\/([-_\\w]*)\\/o\\/(.*)", 2);
        private static final Pattern NEW_URL_PATTERN = Pattern.compile("https://([-_\\w]*)\\.objectstorage\\.([-_\\w]*)\\.oci\\.customer-oci\\.com\\/n\\/\\1\\/b\\/([-_\\w]*)\\/o\\/(.*)", 2);
        private Region region;
        private String namespaceName;
        private String bucketName;
        private String objectName;

        ObjectUrl(String urlString) {
            Matcher urlMatcher = URL_PATTERN.matcher(urlString);
            Matcher newUrlMatcher = NEW_URL_PATTERN.matcher(urlString);
            if (urlMatcher.matches()) {
                this.region = Region.fromRegionId((String)urlMatcher.group(1));
                this.namespaceName = urlMatcher.group(2);
                this.bucketName = urlMatcher.group(3);
                this.objectName = urlMatcher.group(4);
            } else if (newUrlMatcher.matches()) {
                this.namespaceName = newUrlMatcher.group(1);
                this.region = Region.fromRegionId((String)newUrlMatcher.group(2));
                this.bucketName = newUrlMatcher.group(3);
                this.objectName = newUrlMatcher.group(4);
            } else {
                throw new IllegalArgumentException("Fail to parse Object URL: " + urlString);
            }
        }
    }
}

