/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.databasetools;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.databasetools.DatabaseToolsClient;
import com.oracle.bmc.databasetools.model.DatabaseToolsConnection;
import com.oracle.bmc.databasetools.requests.GetDatabaseToolsConnectionRequest;
import com.oracle.bmc.databasetools.responses.GetDatabaseToolsConnectionResponse;
import oracle.jdbc.provider.factory.Resource;
import oracle.jdbc.provider.factory.ResourceFactory;
import oracle.jdbc.provider.oci.OciResourceFactory;
import oracle.jdbc.provider.oci.Ocid;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;

public class DatabaseToolsConnectionFactory
extends OciResourceFactory<DatabaseToolsConnection> {
    public static final Parameter<String> CONNECTION_OCID = Parameter.create((Parameter.Attribute[])new Parameter.Attribute[]{Parameter.CommonAttribute.REQUIRED});
    private static final ResourceFactory<DatabaseToolsConnection> INSTANCE = new DatabaseToolsConnectionFactory();

    private DatabaseToolsConnectionFactory() {
    }

    public static ResourceFactory<DatabaseToolsConnection> getInstance() {
        return INSTANCE;
    }

    @Override
    protected Resource<DatabaseToolsConnection> request(AbstractAuthenticationDetailsProvider authenticationDetails, ParameterSet parameterSet) {
        Resource resource;
        block9: {
            String connectionOcid = (String)parameterSet.getRequired(CONNECTION_OCID);
            Ocid ocid = new Ocid(connectionOcid);
            if (ocid.getRegion() == null) {
                throw new IllegalStateException("Region is missing in Database Tools Connection OCID: " + ocid.getContent());
            }
            DatabaseToolsClient client = DatabaseToolsClient.builder().build(authenticationDetails);
            try {
                client.setRegion(ocid.getRegion());
                GetDatabaseToolsConnectionResponse getResponse = client.getDatabaseToolsConnection(GetDatabaseToolsConnectionRequest.builder().databaseToolsConnectionId(ocid.getContent()).build());
                resource = Resource.createPermanentResource((Object)getResponse.getDatabaseToolsConnection(), (boolean)true);
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error occurs while acquiring Database Tools Connection client", e);
                }
            }
            client.close();
        }
        return resource;
    }
}

