/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.configuration;

import java.io.InputStream;
import java.util.HashMap;
import oracle.jdbc.driver.OracleConfigurationJsonProvider;
import oracle.jdbc.provider.oci.configuration.OciConfigurationParameters;
import oracle.jdbc.provider.oci.objectstorage.ObjectFactory;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.util.OracleConfigurationCache;

public class OciObjectStorageProvider
extends OracleConfigurationJsonProvider {
    public InputStream getJson(String objectUrl) {
        if (!objectUrl.startsWith("https://")) {
            objectUrl = "https://" + objectUrl;
        }
        HashMap<String, String> optionsWithUrl = new HashMap<String, String>(this.options);
        optionsWithUrl.put("object_url", objectUrl);
        ParameterSet parameters = OciConfigurationParameters.getParser().parseNamedValues(optionsWithUrl);
        return (InputStream)ObjectFactory.getInstance().request(parameters).getContent();
    }

    public String getType() {
        return "ociobject";
    }

    public OracleConfigurationCache getCache() {
        return CACHE;
    }
}

