/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci.authentication;

import com.oracle.bmc.Region;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import oracle.jdbc.provider.oci.authentication.AuthenticationDetailsFactory;
import oracle.jdbc.provider.oci.authentication.InteractiveAuthenticationDetails;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.util.JsonWebTokenParser;

final class InteractiveAuthentication {
    private static final byte[] SCRIPT_RESPONSE = "<script type='text/javascript'>\n  hash = window.location.hash\n  window.location.hash = '';\n  \n  // Remove the leading '#' from the URL fragment\n  if (hash[0] === '#') {\n      hash = hash.substr(1)\n  }\n  \n  function reqListener () {\n      document.write('Authorization completed! Please close this window and return to your application.')\n      document.close();\n  }\n  \n  var oReq = new XMLHttpRequest();\n  oReq.addEventListener(\"load\", reqListener);\n  oReq.open(\"GET\", \"/token?\" + hash);\n  oReq.send();\n</script>".getBytes(StandardCharsets.UTF_8);

    private InteractiveAuthentication() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static InteractiveAuthenticationDetails getSessionToken(ParameterSet parameterSet) {
        Region region = (Region)parameterSet.getOptional(AuthenticationDetailsFactory.REGION);
        InetSocketAddress redirectAddress = new InetSocketAddress("localhost", 8181);
        CompletableFuture<LoginResult> loginFuture = InteractiveAuthentication.acceptRedirect(redirectAddress);
        try {
            KeyPair keyPair = InteractiveAuthentication.generateKeyPair();
            InteractiveAuthentication.openBrowser(region, keyPair.getPublic(), redirectAddress);
            LoginResult loginResult = InteractiveAuthentication.awaitLogin(loginFuture);
            if (region == null) {
                region = loginResult.getIssuerRegion();
            }
            InteractiveAuthenticationDetails interactiveAuthenticationDetails = new InteractiveAuthenticationDetails(region, loginResult.securityToken, keyPair);
            return interactiveAuthenticationDetails;
        }
        finally {
            loginFuture.cancel(true);
        }
    }

    private static KeyPair generateKeyPair() {
        try {
            return KeyPairGenerator.getInstance("RSA").generateKeyPair();
        }
        catch (NoSuchAlgorithmException rsaNotAvailable) {
            throw new IllegalStateException(rsaNotAvailable);
        }
    }

    private static CompletableFuture<LoginResult> acceptRedirect(InetSocketAddress redirectAddress) {
        HttpServer server;
        try {
            server = HttpServer.create(redirectAddress, 0);
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failed to create an HTTP server", ioException);
        }
        CompletableFuture<LoginResult> loginFuture = new CompletableFuture<LoginResult>();
        server.createContext("/", httpExchange -> {
            try {
                InteractiveAuthentication.handleScriptRequest(httpExchange);
            }
            catch (Exception exception) {
                loginFuture.completeExceptionally(exception);
            }
        });
        server.createContext("/token", httpExchange -> {
            try {
                loginFuture.complete(InteractiveAuthentication.handleTokenRequest(httpExchange));
            }
            catch (Exception exception) {
                loginFuture.completeExceptionally(exception);
            }
        });
        server.setExecutor(null);
        server.start();
        loginFuture.whenComplete((result, error) -> server.stop(0));
        return loginFuture;
    }

    private static void handleScriptRequest(HttpExchange httpExchange) {
        try (AutoCloseable autoClose = httpExchange::close;){
            httpExchange.sendResponseHeaders(200, SCRIPT_RESPONSE.length);
            httpExchange.getResponseBody().write(SCRIPT_RESPONSE);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to handle HTTP request", exception);
        }
    }

    private static LoginResult handleTokenRequest(HttpExchange httpExchange) {
        LoginResult loginResult;
        block8: {
            AutoCloseable autoClose = httpExchange::close;
            try {
                String query = httpExchange.getRequestURI().getQuery();
                LoginResult loginResult2 = LoginResult.fromUriQuery(query);
                httpExchange.sendResponseHeaders(200, -1L);
                loginResult = loginResult2;
                if (autoClose == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (autoClose != null) {
                        try {
                            autoClose.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw new IllegalStateException("Failed to handle HTTP request", exception);
                }
            }
            autoClose.close();
        }
        return loginResult;
    }

    private static void openBrowser(Region region, PublicKey publicKey, InetSocketAddress redirectAddress) {
        try {
            Desktop.getDesktop().browse(URI.create(String.format("https://login.%s.%s/v1/oauth2/authorize", region == null ? "oci" : region.getRegionId(), region == null ? "oraclecloud.com" : region.getRealm().getSecondLevelDomain()) + "?action=login&client_id=iaas_console&response_type=" + InteractiveAuthentication.encodeUrlParameter("token id_token") + "&nonce=" + InteractiveAuthentication.encodeUrlParameter(UUID.randomUUID().toString()) + "&scope=openid&public_key=" + InteractiveAuthentication.encodeUrlParameter(Base64.getUrlEncoder().encodeToString(InteractiveAuthentication.encodeJwk(publicKey).getBytes(StandardCharsets.UTF_8))) + "&redirect_uri=" + InteractiveAuthentication.encodeUrlParameter(String.format("http://%s:%d", redirectAddress.getHostName(), redirectAddress.getPort()))));
        }
        catch (IOException ioException) {
            throw new IllegalStateException("Failed to open a web browser", ioException);
        }
    }

    private static String encodeJwk(PublicKey publicKey) {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new IllegalStateException("Not an RSA public key: " + publicKey.getClass());
        }
        return String.format("{ \"kty\": \"RSA\", \"n\": \"%s\", \"e\": \"%s\", \"kid\": \"Ignored\" }", Base64.getUrlEncoder().encodeToString(((RSAPublicKey)publicKey).getModulus().toByteArray()), Base64.getUrlEncoder().encodeToString(((RSAPublicKey)publicKey).getPublicExponent().toByteArray()));
    }

    private static String encodeUrlParameter(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException utf8NotSupported) {
            throw new IllegalStateException(utf8NotSupported);
        }
    }

    private static LoginResult awaitLogin(CompletableFuture<LoginResult> loginFuture) {
        try {
            return loginFuture.get();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException("Interactive authentication interrupted", interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IllegalStateException(executionException);
        }
    }

    private static final class LoginResult {
        final String securityToken;
        final String idToken;

        private LoginResult(String securityToken, String idToken) {
            this.securityToken = securityToken;
            this.idToken = idToken;
        }

        Region getIssuerRegion() {
            Map idTokenClaims = JsonWebTokenParser.parseClaims((CharSequence)this.idToken);
            String regionCode = (String)idTokenClaims.get("issuer_region");
            if (regionCode == null) {
                throw new IllegalStateException("id_token does not contain an issuer_region claim");
            }
            return Region.fromRegionCode((String)regionCode);
        }

        static LoginResult fromUriQuery(String query) {
            if (query == null) {
                throw new IllegalStateException("Query section not included in request on /token endpoint");
            }
            Map<String, String> queryParameters = Arrays.stream(query.split("&")).map(nameEqualsValue -> nameEqualsValue.split("=")).collect(Collectors.toMap(nameValue -> nameValue[0], nameValue -> ((String[])nameValue).length == 1 ? "" : nameValue[1]));
            String securityToken = queryParameters.get("security_token");
            if (securityToken == null) {
                throw new IllegalStateException("Query section does not include a security_token in request on /token endpoint");
            }
            String idToken = queryParameters.get("id_token");
            if (idToken == null) {
                throw new IllegalStateException("Query section does not include a id_token in request on /token endpoint");
            }
            return new LoginResult(securityToken, idToken);
        }
    }
}

