/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oci;

import com.oracle.bmc.Region;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Ocid {
    private final String content;
    private final Region region;
    private static final String REGEX = "ocid1\\.[^.]+\\.[^.]+\\.([^.]*)\\..+";
    private static final Pattern PATTERN = Pattern.compile("ocid1\\.[^.]+\\.[^.]+\\.([^.]*)\\..+");

    public Ocid(String content) {
        this.content = content;
        this.region = Ocid.parseRegion(content);
    }

    private static Region parseRegion(String content) {
        Matcher matcher = PATTERN.matcher(content);
        if (matcher.matches()) {
            String regionCode = matcher.group(1);
            if (regionCode.equals("")) {
                return null;
            }
            return Region.fromRegionCode((String)matcher.group(1));
        }
        throw new IllegalStateException("Fail to parse region from the OCID: " + content);
    }

    public Region getRegion() {
        return this.region;
    }

    public String getContent() {
        return this.content;
    }
}

