/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class PemData {
    private static final Logger LOGGER = Logger.getLogger(PemData.class.getName());
    private static final byte[] ASCII_NEW_LINE = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private final Label label;
    private final byte[] base64Data;

    private PemData(Label label, byte[] base64Data) {
        this.label = label;
        this.base64Data = base64Data;
    }

    public InputStream createInputStream() {
        List<InputStream> inputStreams = Arrays.asList(new ByteArrayInputStream(ASCII_NEW_LINE), new ByteArrayInputStream(this.label.beginTag.getBytes(StandardCharsets.US_ASCII)), new ByteArrayInputStream(ASCII_NEW_LINE), new ByteArrayInputStream(this.base64Data), new ByteArrayInputStream(ASCII_NEW_LINE), new ByteArrayInputStream(this.label.endTag.getBytes(StandardCharsets.US_ASCII)), new ByteArrayInputStream(ASCII_NEW_LINE));
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    public Label label() {
        return this.label;
    }

    public byte[] data() {
        return Base64.getMimeDecoder().decode(this.base64Data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PemData encodePrivateKey(PrivateKey privateKey) {
        byte[] pkcs8Key = privateKey.getEncoded();
        try {
            byte[] base64Data = Base64.getMimeEncoder().encode(pkcs8Key);
            PemData pemData = new PemData(Label.PRIVATE_KEY, base64Data);
            return pemData;
        }
        finally {
            Arrays.fill(pkcs8Key, (byte)0);
        }
    }

    public static List<PemData> decode(InputStream pemData) {
        ArrayList<PemData> pemDataList = new ArrayList<PemData>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(pemData, StandardCharsets.US_ASCII));
        try {
            String line;
            while (null != (line = reader.readLine())) {
                String labelName = PemData.parseBeginLabelName(line);
                if (labelName == null) continue;
                Label label = (Label)((Object)Label.NAME_TO_LABEL_MAP.get(labelName));
                if (label == null) {
                    LOGGER.warning("Ignoring unrecognized PEM label: " + labelName);
                    PemData.parseData(reader, null, PemData.toEndTag(labelName));
                    continue;
                }
                ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
                PemData.parseData(reader, dataStream, label.endTag);
                pemDataList.add(new PemData(label, dataStream.toByteArray()));
            }
            return pemDataList;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static String parseBeginLabelName(String line) {
        if (!(line = line.trim()).startsWith("-----BEGIN ")) {
            return null;
        }
        if (!line.endsWith("-----")) {
            return null;
        }
        return line.substring("-----BEGIN ".length(), line.length() - "-----".length());
    }

    private static String toEndTag(String labelName) {
        return "-----END " + labelName + "-----";
    }

    private static void parseData(BufferedReader reader, OutputStream outputStream, String endTag) throws IOException {
        String line;
        while (null != (line = reader.readLine()) && !endTag.equals(line = line.trim())) {
            if (outputStream == null) continue;
            outputStream.write(line.getBytes(StandardCharsets.US_ASCII));
        }
        if (line == null) {
            throw PemData.missingEndTag(endTag);
        }
    }

    private static IllegalStateException missingEndTag(String endTag) {
        return new IllegalStateException("Missing END tag: " + endTag);
    }

    public static enum Label {
        PRIVATE_KEY("PRIVATE KEY"),
        ENCRYPTED_PRIVATE_KEY("ENCRYPTED PRIVATE KEY"),
        CERTIFICATE("CERTIFICATE");

        private static final Map<String, Label> NAME_TO_LABEL_MAP;
        static final String BEGIN_PREFIX = "-----BEGIN ";
        static final String END_PREFIX = "-----END ";
        static final String TAG_POSTFIX = "-----";
        private final String labelName;
        private final String beginTag;
        private final String endTag;

        private Label(String labelName) {
            this.labelName = labelName;
            this.beginTag = BEGIN_PREFIX + labelName + TAG_POSTFIX;
            this.endTag = PemData.toEndTag(labelName);
        }

        static {
            NAME_TO_LABEL_MAP = Arrays.stream(Label.values()).collect(Collectors.toMap(label -> label.labelName, Function.identity()));
        }
    }
}

