/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.parameter;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class UriParameters {
    private UriParameters() {
    }

    public static Map<String, String> parse(CharSequence uri) {
        if (uri == null) {
            return Collections.emptyMap();
        }
        return UriParameters.parseQuery(UriParameters.toURI(uri));
    }

    public static String toString(Map<String, String> namedValues) {
        if (namedValues == null) {
            return "";
        }
        return namedValues.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
    }

    private static URI toURI(CharSequence uriCharSequence) {
        URI uri = URI.create(uriCharSequence.toString());
        if (!uri.isOpaque()) {
            return uri;
        }
        try {
            return new URI(uri.getScheme(), "//" + uri.getSchemeSpecificPart(), uri.getFragment());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new IllegalArgumentException(uriSyntaxException);
        }
    }

    private static Map<String, String> parseQuery(URI uri) {
        TreeMap<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String query = uri.getQuery();
        if (query == null) {
            return Collections.emptyMap();
        }
        for (String nameEqualsValue : query.split("&")) {
            String[] nameValue = nameEqualsValue.split("=");
            int expectedLength = 2;
            if (nameValue.length < 2) continue;
            values.put(nameValue[0], nameValue[1]);
        }
        return values;
    }
}

