/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.parameter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import oracle.jdbc.provider.parameter.Parameter;
import oracle.jdbc.provider.parameter.ParameterSet;
import oracle.jdbc.provider.parameter.ParameterSetBuilder;
import oracle.jdbc.provider.parameter.ParameterSetParser;
import oracle.jdbc.provider.parameter.UriParameters;

final class ParameterSetParserImpl
implements ParameterSetParser {
    private final Map<String, ParameterParser> parameterParsers = new TreeMap<String, ParameterParser>(String.CASE_INSENSITIVE_ORDER);

    ParameterSetParserImpl(Builder builder) {
        this.parameterParsers.putAll(builder.parameterParsers);
    }

    @Override
    public ParameterSet parseNamedValues(Map<String, String> namedValues) {
        Objects.requireNonNull(namedValues, "namedValues is null");
        ParameterSetBuilder builder = ParameterSet.builder();
        for (ParameterParser parameterParser : this.parameterParsers.values()) {
            parameterParser.setDefaultValue(builder);
        }
        for (Map.Entry entry : namedValues.entrySet()) {
            String name = (String)entry.getKey();
            ParameterParser parameterParser = this.parameterParsers.get(name);
            if (parameterParser == null) {
                throw new IllegalArgumentException(String.format("Unrecognized parameter name: \"%s\". Valid parameter names are: %s", name, Arrays.toString(this.parameterParsers.keySet().toArray())));
            }
            parameterParser.setValue(builder, (String)entry.getValue());
        }
        return builder.build();
    }

    @Override
    public ParameterSet parseUrl(CharSequence url) {
        Map<String, String> parameters = UriParameters.parse(url);
        return this.parseNamedValues(parameters);
    }

    static final class Builder
    implements ParameterSetParser.Builder {
        private final Map<String, ParameterParser> parameterParsers = new HashMap<String, ParameterParser>();

        Builder() {
        }

        @Override
        public ParameterSetParser build() {
            return new ParameterSetParserImpl(this);
        }

        @Override
        public Builder addParameter(String name, Parameter<String> parameter) {
            this.addParameterParser(name, ParameterParser.SET_NO_DEFAULT, (value, builder) -> builder.add(name, parameter, value));
            return this;
        }

        @Override
        public Builder addParameter(String name, Parameter<String> parameter, String defaultValue) {
            this.addParameterParser(name, builder -> builder.add(name, parameter, defaultValue), (value, builder) -> builder.add(name, parameter, value));
            return this;
        }

        @Override
        public <T> Builder addParameter(String name, Parameter<T> parameter, Function<String, T> valueParser) {
            this.addParameterParser(name, ParameterParser.SET_NO_DEFAULT, (value, builder) -> builder.add(name, parameter, valueParser.apply((String)value)));
            return this;
        }

        @Override
        public <T> Builder addParameter(String name, Parameter<T> parameter, T defaultValue, Function<String, T> valueParser) {
            this.addParameterParser(name, builder -> builder.add(name, parameter, defaultValue), (value, builder) -> builder.add(name, parameter, valueParser.apply((String)value)));
            return this;
        }

        @Override
        public Builder addParameter(String name, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            this.addParameterParser(name, ParameterParser.SET_NO_DEFAULT, valueSetter);
            return this;
        }

        @Override
        public Builder addParameter(String name, Consumer<ParameterSetBuilder> defaultValueSetter, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            this.addParameterParser(name, defaultValueSetter, valueSetter);
            return this;
        }

        private void addParameterParser(String name, Consumer<ParameterSetBuilder> defaultValueSetter, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            ParameterParser parameterParser = new ParameterParser(defaultValueSetter, valueSetter);
            this.parameterParsers.put(name, parameterParser);
        }
    }

    private static final class ParameterParser {
        private static final Consumer<ParameterSetBuilder> SET_NO_DEFAULT = builder -> {};
        private final Consumer<ParameterSetBuilder> defaultValueSetter;
        private final BiConsumer<String, ParameterSetBuilder> valueSetter;

        private ParameterParser(Consumer<ParameterSetBuilder> defaultValueSetter, BiConsumer<String, ParameterSetBuilder> valueSetter) {
            this.defaultValueSetter = defaultValueSetter;
            this.valueSetter = valueSetter;
        }

        void setDefaultValue(ParameterSetBuilder builder) {
            this.defaultValueSetter.accept(builder);
        }

        void setValue(ParameterSetBuilder builder, String value) {
            this.valueSetter.accept(value, builder);
        }
    }
}

